+++
author = ["authors/donna-maurer.md"]
categories = "How-To"
date = "2019-03-28T00:32:49+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = "Have you ever wondered, when taking on music lessons, what requirements there may be when starting? Some instructors might give you a list of their requirements ahead of time, but most probably don't. It is important to be aware that learning a musical skill, even just as a hobby or on the side, still takes attention, dedication, and hard work. Some may be unaware of what's expected of them when they decide to take on learning an instrument, and it helps to have a good idea of what the instructor wants from you. Music instructors do and will have certain expectations that they would like you to know about when working with them. Below are some of the top misconceptions and significant aspects that should be noted by students studying music."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1553733724/media/2019/03/sqMusicTeacher.jpg"
primary_image_credit = ""
related_articles = ["articles/4-tips-for-when-there-are-too-many-notes.md", "articles/surprising-practice-tips-4-arias-to-try-too-fast.md", "articles/the-practice-tip-you-dont-want-to-hear.md"]
related_companies = []
related_people = []
short_description = "Have you ever wondered, when taking on music lessons, what requirements there may be when starting? Some instructors might give you a list of their requirements ahead of time, but most probably don't."
slug = "the-top-5-things-your-music-instructor-wants-you-to-know"
title = "The Top 5 Things Your Music Instructor Wants You To Know"
youtube_url = ""

+++
### Music is a Real Job and Subject

First and foremost, music teachers want to be taken seriously, as their job is their livelihood. Music is also a core academic subject - it's more than a fun hobby. It can be tested on, just like any other subject, because your skill won't advance without proper learning and evaluations. 

Vincent Reina, founder of the music school [Music To Your Home](https://www.musictoyourhome.com/), said that he was once asked: "Are you just a music teacher?", which can actually be perceived as an offensive question by instructors in the field. In response, he emphasized that music is "no different than any other subject, like math or science, and is a foundation for building essential life skills within students." 

>Music requires discipline, practice, and dedication.

This includes things like hand-eye coordination and development of language and motor skills, as well as stimulating the brain through emotion and creativity. In fact, students who study music have been shown to have higher SAT score ratings than those who don't. These are just some of the many benefits of learning music. It is not an "easy" job, as many music teachers are musicians themselves, and plenty of practice and work is required to become a successful instructor.

### Take Time To Practice

Music instructors are not miracle workers. If you have an hour with your instructor each session, you should not expect that you would have the ability to master an instrument or music skill in such a short amount of time.  It is up to you to set aside time for practice, and this is crucial in the development of your musicianship. Music requires discipline, practice, and dedication. 

This goes along with taking the subject matter seriously: if you don't give yourself extra time for practice, there is very little chance that you will be able to master your music (unless you have a unique hidden talent for learning extremely quickly). Nothing about learning a new instrument or skill is easily attained, even with talent. 

>If you know yourself well, you should know what sort of learning style you adapt well to.

Most music instructors view the concept of practicing as common knowledge, but it is important to assess your time as a student and be sure that you will have the opportunity to give yourself extra wiggle room to rehearse outside of your lessons.

### Ask for Help When Needed

Teachers are there for their students; they don't want you to feel like you don't know something or need more time. Don't be afraid to ask for help if you need it! The main and most important job of a music instructor, or any instructor for that matter, is to assist students in their learning. 

If something is not making sense or you're struggling in any way, bring it up to your instructor immediately. It cannot get better if you are too afraid to voice your issues or concerns. Give your educator some information so that they can properly assess the situation and provide a sound resolution. Problem-solving is a significant aspect of learning, and part of your teacher's job is to be there to guide you through.

### They Will Personalize Your Lessons To Help You Succeed

No one student learns the same as another, and being aware of learning styles is of great help to your instructor. There are many varieties of approaches to learning that work well for some students and not for others. If you know yourself well, you should know what sort of learning style you adapt well to. 

Let your teacher know what sort of tools, tips or tricks help you to develop your skills, or the best ways that you learn and retain knowledge. This way, your instructor can tailor your lessons to fit that style as best they can. It will go great lengths to help with your mastery of music. 

>Teachers enjoy helping their students grow and learn.

If you're a parent of a music student, take the opportunity to talk with the instructor and figure out the best approach for working with your child. Provide feedback on areas of doubt or concern, as this will give the teacher great insight. If you feel you need help in this area, take this quiz on how to figure out your best learning style.

### They Love What They Do

Music instructors are extremely passionate about what they do for a living. Music is an art that involves creativity and is always evolving. Music sparks a desire for learning and instills a positive attitude towards it. With such a positive impact, it's easy to see why people gravitate to the subject. Learning music provides a new outlook on the world, encourages confidence and builds self-esteem within the student.

Teachers enjoy helping their students grow and learn. One of the most rewarding parts of being a music instructor is watching students excel, forming bonds between student and teacher, and experiencing the thing they love most - making music with a fellow musician.