+++
author = ["authors/jeremy-hirsch.md"]
categories = "Review"
date = "2018-01-17T21:02:00-05:00"
lastmod = "2018-01-18T09:09:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516240460857/sq---Echo_Drift_Baranova-7020.jpg.jpg"
primary_image_credit = "Blythe Gaissert in The Echo Drift, Prototype Festival, 2018. Photo: Maria Baranova."
publishDate = "2018-01-17T21:02:00-05:00"
related_articles = ["articles/an-operatic-horror-story-proving-up.md"]
related_companies = ["scene/companies/beth-morrison-projects.md","scene/companies/american-opera-projects.md"]
related_people = ["scene/people/blythe-gaissert.md"]
short_description = "The moth, appealingly mesmerizing, could have a spin-off opera all to itself. Created by individual acrylic paintings set in stop-motion animation, it moves like an insect shadow ricocheting off a porch light on a chilly autumn night in the country."
slug = "the-start-of-something-powerful-the-echo-drift"
title = "The start of something powerful: The Echo Drift"
+++

Solitary confinement, like the death penalty, is a uniquely American punitive practice. Experts generally agree that it is dysfunctional and amoral. Advocacy site [*Solitary Watch*](http://solitarywatch.com/) reports that in 2011, the UN chief torture investigator recommended all UN member nations ban prolonged isolation, describing it as utterly harmful and akin to torture. But the American public and political body, uninformed, tend to uphold it as a necessary evil, and so the practice persists.

A prisoner isolated in a supermax facility is typically stowed in a concrete poured room - unmovable concrete bed, desk, stool - for about 23 hours a day. The free hour can be spent exercising in a caged "dog-run" or showering shackled by the ankles.

Brutally starved of human interaction, the brain can deteriorate to irreversible degrees. Inmates become catatonic, suicidal, overwhelmed with delusions, or consumed by extreme anger and revenge fantasies against their imprisoners. All these results are undoubtedly antithetical to rehabilitation.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516240514253/Echo_Drift_Baranova-7174.jpg.jpg)
<figcaption>Blythe Gaissert in *The Echo Drift*, Prototype Festival, 2018. Photo: Maria Baranova.</figcaption>
</figure>

*The Echo Drift*, a new opera premiering at this year's Prototype Festival (co-produced by [Beth Morrison Projects](/scene/companies/beth-morrison-projects/), HERE, and [American Opera Projects](/american-opera-projects-youre-seeing-the-opera-in-microcosm/)), centers on convicted murderer Walker Loats ([Blythe Gaissert](/scene/people/blythe-gaissert/)). One unfortunate night, Loats is attacked while monitoring the local shipyard. She must kill to preserve her life. But, when she sees that someone has witnessed the slaying, she murders that man in cold blood, landing her in prison.

Now she counts time in solitary confinement at the Hersh supermax facility. Or tries to. Her "job", as she describes it, is to tinker at a homemade timekeeper; what amounts to a large metronome supported by a wood scaffolding, its moving parts made from contraband (spoons, springs, screws, even screwdrivers).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516240487654/Echo_Drift_Baranova-2786.jpg.jpg)
<figcaption>Blythe Gaissert in *The Echo Drift*, Prototype Festival, 2018. Photo: Maria Baranova.</figcaption>
</figure>

She monologues in halting fragments, distractedly fiddling at her contraption. The next twist of a screw could set things in motion. A romping rhythm rises with Loats' quickening pulse. The pistons of her mechanical mind fire aloud as she nears completion. A final heave, and ah, "There it is", she says. Time begins.

And passes. Soon, lunch comes. The usual gray glue soup. Loats lifts a spoon-full and disgusted, drips the paint-like gruel back into its bowl. But something catches her eye. She surgically slides her utensil into the viscous pool and extracts a small, dripping, pristine orb: a cocoon.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516240559097/Echo_Drift_Baranova-6780.jpg.jpg)
<figcaption>Blythe Gaissert in *The Echo Drift*, Prototype Festival, 2018. Photo: Maria Baranova.</figcaption>
</figure>

Loats attaches the cocoon to a crease in the ceiling. During a thunder-rocked night, static-electric throbs vibrate the room as the white, hanging, shriveled sack of life pumps larger and larger to bursting. Slow chromatic, melodic tendrils sneak up the walls. A rapid, rising wail becomes a roar, then a crash. Sound and light settle and amongst the debris, a compressed rustle of wings signals new life. Like a living Rorschach blot, a moth, hatched, flutters quickly about, growing and shrinking with a rapidity only afforded shadows. Loats now has a companion. And it speaks.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516240584184/Echo_Drift_Baranova-7358.jpg.jpg)
<figcaption>Blythe Gaissert in *The Echo Drift*, Prototype Festival, 2018. Photo: Maria Baranova.</figcaption>
</figure>

Loats will not discuss her criminal past. But the talking moth (actor John Kelly), with enough needling, goads her into reliving her crime. However to do so, she must break her time device and enter something called the "echo drift". She agrees, wrenching a crucial gear from her machine's heart.

A large fluorescent square is drawn line by line. Concentric versions of the square grow outwardly from its border, joining a larger square. A chest-rattling bass throbs with each glowing rush of neon. Now squares shooting inward implode as though in a geometric nightmare. A final flash, and the docks appear. A fresh corpse is splayed on the ground with a handgun feet away from its rigor mortised fist.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516240575027/Echo_Drift_Baranova-7037.jpg.jpg)
<figcaption>Blythe Gaissert in *The Echo Drift*, Prototype Festival, 2018. Photo: Maria Baranova.</figcaption>
</figure>

Loats is caught in her memory, forced to relive it moment by moment. She again murders the witness, whose identity, once revealed, clarifies why her crime is too damning to face. Back in her cell, she is left lying calmly on her side, longingly poking at the component parts of her time device spread before her on the ground. Freedom will not be forthcoming.

Loats' personal history is generic noire. She started as a lowly dock worker but with unmatched gumption became a boss. She communicates with snarky, quasi-philosophical quips that approach but never quite achieve wit. Outwardly, she appears more angsty teen than homicidal crime Donna. Made neither docile nor furious by her imprisonment, she seems basically annoyed by the whole thing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516240610416/Echo_Drift_Baranova-3189.jpg.jpg)
<figcaption>Blythe Gaissert in *The Echo Drift*, Prototype Festival, 2018. Photo: Maria Baranova.</figcaption>
</figure>

Her digs in the prison are more IKEA than supermax. The bed, desk, and stool have a friendly, rounded-off design that undermines what should be a claustrophobic terror cell.

The production features neither supertitles nor a printed libretto. Of course, diction coaches exist for a reason. Still, the vocal line often and abruptly pops into a register that forces Gaissert to modify her elocution beyond comprehension. Sentence after sentence was indecipherable. Musically, the overly dramatic tessitura neutralized climaxes and limited Gaissert's sonic palette.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516240647350/Echo_Drift_Baranova-7076.jpg.jpg)
<figcaption>Blythe Gaissert in *The Echo Drift*, Prototype Festival, 2018. Photo: Maria Baranova.</figcaption>
</figure>

The beauty of Gaissert's well-sized instrument suffered from being miked. The amplification emphasized vibrato over tone. The most affecting vocal moments were when the singer's melody resolved with an upward sweep into sweetly extended major harmonies.

The orchestra benefitted from the electro-acoustic setting. Low, swelling drones in the cello and bass became bodily experiences, felt as much as heard. The piano and harp's timbral ranges increased, acquiring a uniquely sharp, percussive quality when played at a volume that might otherwise not be audible.

Karlsson's score is frequently driven by jaunty ostinati. His romps dance propulsively whether the beat is divided into two, three, four, or five. He peppers the score with ripping Gershwin-esque clarinet soli that evoke the noire-ish atmosphere of the docks. The players from International Contemporary Ensemble (ICE), led enthusiastically by Nicholas DeMaison (ICE) unsurprisingly functioned superbly in both ensemble and soloistic passages.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516240666003/Echo_Drift_Baranova-6965.jpg.jpg)
<figcaption>Blythe Gaissert in *The Echo Drift*, Prototype Festival, 2018. Photo: Maria Baranova.</figcaption>
</figure>

The moth, appealingly mesmerizing, could have a spin-off opera all to itself. Created by individual acrylic paintings set in stop-motion animation, it moves like an insect shadow ricocheting off a porch light on a chilly autumn night in the country.

John Kelly's voice had a hushed, almost sibilant quality. Captured in his tone was the conflict between the moth's fragility at the awareness of his miniscule life-span and the stoic acceptance of his place in the natural cycle of death.

As the governor, Kelly's face took on sallow weight. Bags formed under his eyes. He resurrected a man burdened by the daily indignities of a dysfunctional, mob-tied bureaucracy; a life drenched in moral ambiguity.

It's hard to say whether the piece has a beating heart. It has little to say about the specific cruelty of solitary confinement. Its protagonist would be mere background talent on *Orange is the New Black*, she is so rife with prison clichés. That said, actor John Kelly is effortlessly engrossing, the score as a work of chamber music is taught and pulsing with life, and the visual art and design are delicious eye candy. If only there were a gripping story to bind it all together.
