+++
author = ["authors/neil-weisensel.md"]
categories = "Review"
date = 2020-11-12T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1605192974/media/2020/11/sqMO-TSOW-LidaSzkwarek_i7liox.jpg"
primary_image_credit = "Lida Szkwarek in The Sopranos of Winnipeg, November 7, 2020. Photo courtesy of Manitoba Opera."
related_articles = ["articles/heartfelt-and-intimate-manitoba-operas-la-traviata.md", "articles/susannah-is-topical-relevance-like-it-or-not.md"]
related_companies = ["scene/companies/manitoba-opera.md"]
related_people = ["scene/people/lida-szkwarek.md", "scene/people/tracy-dahl.md", "scene/people/andriana-chuchman.md", "scene/people/lara-ciekiewicz.md", "scene/people/andrea-lett.md"]
short_description = "I'm going to write this as a live-blog, as one of the advantages of attending virtually is you can type as you listen, instead of having to remember all your thoughts from the concert!"
slug = "an-embarrassment-of-riches-the-sopranos-of-winnipeg"
title = "An embarrassment of riches: The Sopranos of Winnipeg"
youtube_url = ""

+++
As I settled in to watch Manitoba Operas's livestream of _The Sopranos of Winnipeg_ this past Saturday November 7th , I was struck by a sudden sense of calm. My life lately, like many others I'm sure, has been a blur of non-stop Zoom teaching, meetings, and other online affairs. Tonight, I was only a spectator, nobody would be looking at me. How novel!

For a city of well under a million inhabitants, Winnipeg certainly boasts more top notch sopranos-per-capita than, I would hazard a guess, practically any city in the world. Why is that, I wonder? Part of the why, is the great teaching available at our local universities, University of Manitoba, Canadian Mennonite University and Brandon University. Others on the YouTube chat for tonight's concert (a very cool thing to be able to do by the way!) are also appreciative of our embarrassment of riches in the soprano category. Another why - you can actually live here on a singer's salary! Yet another reason is that singing is baked into the fabric of this cold, barren climate. Singing warms the heart, I guess…

Like almost every industry, the performing arts have taken a sh*t-kicking from the pandemic. How can we cope with what has happened to our world? Well, the intrepid folks at [Manitoba Opera](/scene/companies/manitoba-opera/) (MO) and the Winnipeg Symphony Orchestra (WSO) are not going to let a pandemic stop some serious music-making. As MO had already booked Winnipeg's Centennial Concert Hall and the WSO for an anticipated production of Sondheim's _Sweeney Todd_, MO decided to go all-in local with a concert featuring seven of Winnipeg's finest sopranos - [Andriana Chuchman](/scene/people/andriana-chuchman/), [Lara Ciekiewicz](/scene/people/lara-ciekiewicz/), [Tracy Dahl](/scene/people/tracy-dahl/), [Monica Huisman](/scene/people/monica-huisman/), [Andrea Lett](/scene/people/andrea-lett/), [Lara Secord-Haid](/scene/people/lara-secord-haid/), and [Lida Szkwarek](/scene/people/lida-szkwarek/) - accompanied by the musicians of the WSO and ably conducted by long-time MO Chorus Director Tadeusz Biernacki. The program runs the gamut from the obligatory Wolfgang Mozart overture (from _Marriage of Figaro_), through French music (Jacques Offenbach, from _Tales of Hoffman_ and Amboise Thomas’ _Mignon_) to something modern, an aria from John Estacio’s _Filumena_.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1605193052/media/2020/11/MO_-_TSOW_-_Group_curtain_call_sje5iy.jpg){{% /md %}}

<figcaption>The Sopranos of Winnipeg, November 7, 2020. Photo courtesy of Manitoba Opera.</figcaption>

</figure>

I'm going to write this as a live-blog, as one of the advantages of attending virtually is you can type as you listen, instead of having to remember all your thoughts from the concert!

***

It's starting! Ahhhhh – the familiar sound of an orchestra warming up. Lord do I miss that! Since my days growing up watching Bugs Bunny and from countless orchestral evenings since, this sound always elicits warm happy feelings. Here's the Overture to Wolfgang Mozart's _The Marriage of Figaro_ – a beloved piece for both musicians and audiences alike, and a great choice to open this concert. I'm happy to report that the sound is astoundingly good! I'm so glad – kudos to the technicians, as an orchestra is no easy thing to make sound good with microphones. Performance-wise, the musicians of the WSO sound as excellent as ever, which couldn't have been easy with such a large amount of time since their last performance, a livestream on Oct. 3rd. It is indeed odd to see the players – and indeed the conductor – masked, but that's what we need to do these days to put on the show safely. The musicians are certainly getting into it, given their engaged body language and intensity. It does seem funny to bow after the performance when there's nobody in the audience, and nobody clapping…

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1605193199/media/2020/11/MO_-_TSOW_-_Andrea_Lett_omjwdh.jpg){{% /md %}}

<figcaption>Andrea Lett in The Sopranos of Winnipeg, November 7, 2020. Photo courtesy of Manitoba Opera.</figcaption>

</figure>

First up – "The Doll Song" from Jacques Offenbach’s _Tales of Hoffman_, with soprano Andrea Lett. She's dressed in a super-cute purple periwinkle dress with her hair in a silver bow, and freckles on her face. Her wind-up doll movements are fun and engaging, somebody program this piece for a kid’s concert! Maestro Biernacki gets in on the fun to "wind her up" when she runs out of energy, but instead of the traditional wind-up key, he uses a remote - very 2020. Lett's singing is a treat, exquisite in many places, and she nails all the high notes perfectly. I wonder if she and Tracy Dahl had a laugh about this piece before the concert – it's one of Dahl's signature pieces. The evening's gracious host, MO marketing maven Darlene Ronald mentioned in Lett's introduction that she won a competition with this song - that's no surprise!

> So glad the musicians are clapping – it seems a shame to not have applause after a tremendous performance like that.

Next up – Lara Secord-Haid singing Guiseppe Verdi's famous "Sempre libera" from _La Traviata_. She's wearing a beautiful white dress with a shimmering star pattern on the front. I have heard Ms. Secord Haid in various locales over the past few years. I feel like her voice is still growing in size, but is still incredibly agile, and it seems she has more raw power than the last time I heard her. Her voice seems to be getting darker, but still has amazing resonance and overtones. The orchestra was a bit loud occasionally but this didn't distract from a commanding performance of this barn-burner of an aria. I would love to hear/see her sing this role, she's ready!

One thing that's great about a livestream is how close you get to the performers in this virtual setting. There are many nice close-ups when particular players have solos – kudos to the camera team! Also, I just noticed that the trombones and trumpets are wearing bell covers – I wonder how that affects the sound? All string players are masked but the woodwind players are not. There is a lot of Plexiglas onstage separating sections of musicians, and even within sections, like the strings. I wonder how they are able to play with such a crisp ensemble with these barriers in place, and without monitors from the sopranos' microphones?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1605193116/media/2020/11/MO_-_TSOW_-_Lara_Secord-Haid_nxk7zd.jpg){{% /md %}}

<figcaption>Lara Secord-Haid in The Sopranos of Winnipeg, November 7, 2020. Photo courtesy of Manitoba Opera.</figcaption>

</figure>

Now we come an artist I've not heard before– Lida Szkwarek singing "There will be a storm tonight" from John Estacio's 2003 opera _Filumena_. (Fun fact – Estacio is my opera composer twin – we are born on the same day.) More exceptional camerawork by the visuals team – more kudos! Estacio is certainly getting a shimmering, thrilling performance of his aria tonight by Ms. Szkwarek and the WSO - I hope he's listening. And wow – what an ending! So glad the musicians are clapping – it seems a shame to not have applause after a tremendous performance like that.

> Also, it's so great to hear the Appalachian twang in her English, after all the high-falutin' Italian and Czech.

As a musical interlude we have the famous "Intermezzo" from _Cavalleria Rusticana_ by Pietro Mascagni. Here the orchestra sounds a bit rough in places, with tuning and ensemble issues. To be fair, besides the Plexiglas barriers to contend with, I know for a fact that the amount of rehearsal time orchestral musicians get for operas is pared down to what seems like a ridiculous minimum. But opera company budgets being what they are, that is the norm. Again – why are they standing and bowing when there is no applause? Can't we just settle into the silence that comes after a lovely performance of a beautiful piece like that? (Ok, ok – I’ll stop complaining about that now…)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1605193138/media/2020/11/MO_-_TSOW_-_Monica_Huisman_etdgm8.jpg){{% /md %}}

<figcaption>Monica Huisman in The Sopranos of Winnipeg, November 7, 2020. Photo courtesy of Manitoba Opera.</figcaption>

</figure>

Here's Dutch-Canadian soprano Monica Huisman, singing Antonin Dvorak's "Song to the Moon" from the opera _Rusalka_. She’s wearing a simple black dress with a lovely sparkling shawl and a very nice necklace. I find it interesting that Dvořák would double the vocal with trumpet – it's always a bit too loud and takes away the ability of the soprano to phrase her vocal line more naturally with the text. But, what do I know? Ms. Huisman is at her best here, her voluptuous and creamy voice perfectly suited to this music. I am lucky enough to say I have heard her sing a role in one of my operas with librettist and director Michael Cavanagh – _The Master’s Stroke_ (1999).

Lara Ciekiewicz singing "The trees on the mountain" from Carlisle Floyd's 1955 opera _Susannah_ is enough to melt your heart, pandemic or no pandemic. Way to go MO, programming arias by two living composers! I saw Ms. Ciekiewicz perform this role last year with MO, it’s like she was made to sing this music. Her character's varying degrees of confidence and vulnerability are on full display here – another fine aspect to a livestream compared to a live performance, when only the most expensive seats would get to see this kind of affecting detail. Also, it's so great to hear the Appalachian twang in her English, after all the high-falutin' Italian and Czech.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1605193168/media/2020/11/MO_-_TSOW_-_Lara_Ciekiewicz_ogkzao.jpg){{% /md %}}

<figcaption>The Sopranos of Winnipeg, November 7, 2020. Photo courtesy of Manitoba Opera.</figcaption>

</figure>

> Dahl is so fun to watch, displays such expressivity, and her voice can really do anything any composer could demand.

Andriana Chuchman now sings Susanna’s aria "Deh vieni non tardar" from Wolfgang Mozart's _Marriage of Figaro_. With exquisite singing always a given for this outstanding performer, the fact that she reflects in her face every variation of the text's expressivity is a clear reminder of why she’s in demand on many of the world's most important stages, including the Met in New York. We were very fortunate indeed to hear her sing this role here in Winnipeg in 2015.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1605193097/media/2020/11/MO_-_TSOW_-_Andriana_Chuchman_svh4bn.jpg){{% /md %}}

<figcaption>Andriana Chuchman in The Sopranos of Winnipeg, November 7, 2020. Photo courtesy of Manitoba Opera.</figcaption>

</figure>

Finally, Ambroise Thomas' opera _Mignon_ with Winnipeg star soprano Tracy Dahl singing the aria "Je suis Titania la blonde". This is not an aria I know, it will surely be interesting to hear. Ms. Dahl has such a vast repertoire, it's obvious she chose this aria because she loves to sing it. It's a tour de force piece and performance, with pyrotechnical vocalizations and long vocal lines. She sounds a fabulous as she ever has, wow – she is a true Winnipeg treasure! So much energy coming out of her eyes, and then a crazy hard cadenza with chromatic octave leaps, trills - what a capstone on a magnificent concert! Dahl is so fun to watch, displays such expressivity, and her voice can really do anything any composer could demand. Now how to convince her to sing in one of my operas…

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1605193220/media/2020/11/MO_-_TSOW_-_Tracy_Dahl_ehyjsj.jpg){{% /md %}}

<figcaption>Tracy Dahl in The Sopranos of Winnipeg, November 7, 2020. Photo courtesy of Manitoba Opera.</figcaption>

</figure>

There were 621 tickets sold, most likely representing over 1000 actual viewers. This is a far cry from the usual attendance at MO mainstage events, but for the first foray into this new world of performing we find ourselves in, it's pretty darn good. Further to that last thought: nobody has any idea when we will be able to gather in a concert hall to witness a live performance of many artists onstage performing an opera. While a livestream is not optimum, it's the best we have for now. I have enumerated some of the best things about them, in an attempt to focus on the positive. Another important thing livestreams offer is a chance to take in high-quality performances from any location in the world, which is a good way to start enhancing the audience reach of organizations. I highly recommend taking in as many livestreams as you can, especially from local organizations like Manitoba Opera and the Winnipeg Symphony Orchestra, as they really need your support in these challenging times.