+++
author = ["authors/hannah-de-priest.md"]
categories = "Review"
date = "2018-02-05T21:55:00-05:00"
lastmod = "2018-02-06T16:28:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517927985480/sq---Albina-Shagimuratova_I-PURITANI_LYR180201_0127_c.Todd-Rosenberg.jpg.jpg"
primary_image_credit = "Albina Shagimuratova in *I Puritani*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg."
publishDate = "2018-02-05T21:55:00-05:00"
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/lawrence-brownlee.md","scene/people/albina-shagimuratova.md","scene/people/anthony-clark-evans.md"]
short_description = "While no tenor on earth welcomes comparisons to the undisputed &quot;King of High C&#039;s,&quot; Brownlee is a triumph in this role and it&#039;s not just the singing — Brownlee is a physically-engaged actor, throwing off coloratura while crawling between set pieces and even dashing through the auditorium during a chase scene. And yes, he does take the high F (the F above tenor high C) in the final act&#039;s &quot;Credeasi misera.&quot;"
slug = "the-singing-reigns-in-chicagos-i-puritani"
title = "The singing reigns in Chicago&#039;s I Puritani"
+++

On Superbowl Sunday, a different kind of spectator sport was underway at the Lyric Opera of Chicago: an athletic display of bel canto bravura coloratura by the brilliant cast of Vincenzo Bellini's [*I Puritani*](https://www.lyricopera.org/concertstickets/calendar/2017-2018/productions/lyricopera/i-puritani-opera-tickets).

In 1833, Bellini traveled to France to tie up a lucrative contract with the Paris Opera. The quick trip he anticipated turned into a year of protracted negotiations, during which Bellini became a fixture of the Parisian social scene and did very little composing. Ultimately, in 1834, another important opera house, Théâtre-Italien, awarded him a favorable commission for a new opera—the opera that would prove to be Bellini's last — *I Puritani*.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517885219632/Adrian-Sa%CC%82mpetrean_Lawrence-Brownlee_Anthony-Clark-Evans_Albina-Shagimuratova_I-PURITANI_LYR180201_1199_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Adrian Sâmpetrean, Lawrence Brownlee, Anthony Clark Evans, and Albina Shagimuratova in *I Puritani*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

This epic love story is set in the unlikeliest of places. The curtain opens in puritanical England immediately before King Charles I's execution at the hands of Cromwell (Cromwello). Bellini’s opera was an adaptation of a popular play: *Têtes Rondes et Cavaliers*. In the play, and Bellini’s opera, the conflict between the Royalists and Puritans provides a rich historical backdrop but focuses on a woman in the grip of madness. As history unspools around her, Elvira, too, unravels. Even at the opera’s happy end, her grasp on reality is only tentatively reestablished. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517885230051/Albina-Shagimuratova_Adrian-Sa%CC%82mpetrean_I-PURITANI_LYR180201_0459_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Albina Shagimuratova and Adrian Sâmpetrean in *I Puritani*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

Soprano [Albina Shagimuratova](/scene/people/albina-shagimuratova/), returning to the Lyric one year after her turn as Lucia di Lammermoor, was dazzling as Elvira. In her much-anticipated Act II aria "Qui la voce," Shagimuratova let her glittering voice fly, seamlessly interpolating her own ornaments over Bellini's melodies. Throughout the opera, Shagimuratova maintains a youthful, bright sound and a sense of vocal ease that belies the careful pacing and technical agility required to persist through this hefty bel canto role. She is as lovely to watch as she is to hear, and her chemistry with Arturo (star tenor [Lawrence Brownlee](/scene/people/lawrence-brownlee/)) stuns with convincing passion. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517885250203/Lawrence-Brownlee_I-PURITANI_LYR180201_1052_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Lawrence Brownlee in *I Puritani*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

From the moment he sprints onstage grinning broadly, Brownlee is a winning Arturo, Elvira's beloved and the charismatic hero of the piece. Brownlee's voice is liquid gold, remarkably even throughout his considerable range and consistently plush and warm. In a twist of sartorial serendipity, Brownlee appears in a [pair of boots](https://www.facebook.com/lawrencebrownleeofficial/photos/a.402321329807800.95086.380448701995063/1781335135239739/?type=3&theater) previously worn by Pavarotti in his turn as Arturo at the Metropolitan Opera in 1976. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517885261237/Lawrence-Brownlee_Albina-Shagimuratova_I-PURITANI_LYR180201_0346_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Lawrence Brownlee and Albina Shagimuratova in *I Puritani*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

While no tenor on earth welcomes comparisons to the undisputed "King of High C's," Brownlee is a triumph in this role and it's not just the singing — Brownlee is a physically-engaged actor, throwing off coloratura while crawling between set pieces and even dashing through the auditorium during a chase scene. And yes, he does take the high F (the F above tenor high C) in the final act's "Credeasi misera."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517885276815/Anthony-Clark-Evans_Adrian-Sa%CC%82mpetrean_I-PURITANI_LYR180201_0929_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Anthony Clark Evans and Adrian Sâmpetrean in *I Puritani*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

Rounding out an exceptional principal cast are a number of incredible vocalists worthy of note. Ryan Center alum [Anthony Clark Evans](/scene/people/anthony-clark-evans/) played Arturo's antagonist, Riccardo, and Romanian bass Adrian Sâmpetrean was Elvira's sympathetic uncle Sir Giorgio Walton. Sâmpetrean gave some of the most effective, lyrical singing of the afternoon in his Act II "Cinta di fiori," in which Sir Giorgio is pressured to give an accounting of his niece's madness to a gathering of townspeople. Sâmpetrean held the rapt attention not just of those assembled onstage, but the entire auditorium. Equally gripping was his duet with Riccardo later in the same act, "Suoni la tromba."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517885291523/I-PURITANI_LYR180201_0715_c.Todd-Rosenberg.jpg.jpg)
<figcaption>A scene from *I Puritani*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

When the sight of a political prisoner — the banished Queen Enrichetta — derails the promised nuptials of Elvira and her beloved Arturo, the opera lurches into a plot of political dissidence. Arturo's royalist sympathies inspire his vow to help the Queen flee from her would-be executioners, endangering his life and abandoning his beloved in the process. To obscure her identity during the escape, the Queen, (solidly sung by lush-voiced Ryan Center member Lauren Decker), is bedecked in Elvira's wedding veil. Elvira witnesses the Queen's escape and beings to lose her grip on reality. She struggles to reconcile two interpretations of the scene: Has a stranger has run away with her beloved or was this a vision of herself running away with Arturo?

Elvira's madness is a dissociative disruption; she vacillates wildly from thinking she's still betrothed to him to thinking he's married another. At one moment, she mistakes Riccardo for Arturo, the next, she is asking where Elvira has gone. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517885306023/Albina-Shagimuratova_Adrian-Sa%CC%82mpetrean_Lawrence-Brownlee_I-PURITANI_CU-113_c.Andrew-Cioffi.jpg.jpg)
<figcaption>Albina Shagimuratova, Adrian Sâmpetrean, and Lawrence Brownlee in *I Puritani*, Lyric Opera of Chicago, 2018. Photo: Andrew Cioffi.</figcaption>
</figure>

A happy outcome seems less and less likely, especially after Arturo is captured and brought to the townsquare to answer for his crime. As the townspeople gather for his execution, a deus ex machina in the form of a pardon from Cromwell arrives. Arturo, his crime absolved, is free to marry Elvira and the opera ends on a very literal, very high note - matching high C's from our two ebulliant lovers.

The 19th century's fascination with the psychology of grieving women is a subject for lengthy dissertations, but it is worth ruminating on the particularities of Elvira's madness in this staging of *I Puritani*. The Lyric's production team liberates her decline and its attendant action from the proscenium, challenging the implicit deal that the audience is to observe at a distance. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517885321177/I-PURITANI_WS-58_c.Andrew-Cioffi.jpg.jpg)
<figcaption>A scene from *I Puritani*, Lyric Opera of Chicago, 2018. Photo: Andrew Cioffi.</figcaption>
</figure>

Arturo and the Queen escape down the aisles of the auditorium, chased in earnest by Puritan soldiers as patrons hurry to draw their feet and errant scarves to make way. A clever technical manipulation sends the off-stage singing of the chorus of soldiers through a sequence of different speakers in the hall — they are suddenly here, suddenly there, but also nowhere all at once. Arturo evades their patrol as he clutches the actual wall of the theater. Elsewhere, Elvira — in one of several well-choreographed collapses — faints onto the proscenium arch itself. The chorus, most often positioned as a wall of bodies facing the audience directly, becomes a kind of mirror, doubling and reflecting back the audience's own dark anticipation of Elvira's impending breakdown. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517885342572/Ablina-Shagimuratova_Anthony-Clark-Evans_I-PURITANI_CU-76_c.Andrew-Cioffi.jpg.jpg)
<figcaption>Albina Shagimuratova and Anthony Clark Evans in *I Puritani*, Lyric Opera of Chicago, 2018. Photo: Andrew Cioffi.</figcaption>
</figure>

Director Eric Einhorn's choices amplify the elements in Bellini's score that seek to similarly augment the audience's experience. Diegetic and non-diegetic singing happens off-stage throughout the opera, constantly separating the sound from the sounding body. When Arturo hears Elvira singing their love song, "A una fonte," is he hearing a memory? A ghost? Or is it Elvira? But even after Elvira's physical entrance into the scene, doubt lingers; she is altered by her madness. 

Chicago, you will read elsewhere that bel canto singing is an empty show of vocal agility. You'll hear that *I Puritani* is beautiful music set against an absurd backdrop. But just as (I'm told) football is more than the bodies moving on the field, Bellini's opera is far richer than even his most sumptuous bit of coloratura. 

You do not want to miss this. [*I Puritani*](https://www.lyricopera.org/concertstickets/calendar/2017-2018/productions/lyricopera/i-puritani-opera-tickets) is onstage for six more performances this February at the Lyric Opera of Chicago.
