+++
author = ["authors/rich-coburn.md"]
categories = "Op-ed"
date = "2016-05-06T17:12:00+01:00"
lastmod = "2016-05-07T12:21:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462550875883/2016-06-07---Score.jpg.jpg"
publishDate = "2016-05-07T12:21:00+01:00"
related_articles = ["articles/new-opera-more-singer-input-needed.md","articles/bach-was-all-about-that-bass.md","articles/tales-from-the-score-violetta.md","articles/kevin-puts-i-know-who-i-am-as-a-composer.md","articles/quintus-4-has-no-choice-but-to-have-a-unique-sound.md"]
short_description = "What if, like the composer, you could look at the score as an output instead of an input? That is, instead of taking the score and making it sound, you take sound and make it into a score. And what if you could get a glimpse into the composer&#039;s relationship with the score, even as someone who has no inclination to compose?"
slug = "the-score-how-to-see-what-a-composer-sees"
title = "The score: how to see what a composer sees"
+++

Most classical musicians spend their time in a very one-sided relationship with the score. The score says something, you do your best to figure out what it means, and you to do it. End of process. This works reasonably well for some very detailed scores like Poulenc and Britten opera (Britten folk songs are a completely different story). But other music, generally with less precise or detailed scores, often demands a degree of interpretation; while the music is great, the page is sometimes really boring. I’m looking at you, Schubert.

In this music, there is a big difference between knowing intellectually that you are allowed to take certain liberties, and knowing confidently that where the boundaries of good taste lie. So how can you confidently find that boundary?

The problem is, as I just said, that our relationship with a score is unidirectional. You don’t get to ask questions, or get any verification that your idea is even close to right. But what if you could reverse the relationship? 

What if, like the composer, you could look at the score as an output instead of an input? That is, instead of taking the score and making it sound, you take sound and make it into a score. And what if you could get a glimpse into the composer's relationship with the score, even as someone who has no inclination to compose? Would I have written these paragraphs if I weren’t about to offer you that opportunity?

One day last July I was stuck in a practice shed in the woods, and it was raining, and I had no umbrella. Feeling completely uninspired to practice, I decided to improvise until the rain stopped. Luckily, I also decided to record it. 

What I ended up with was a fifteen-minute improvisation on Massenet’s *Elegie* (inspired more by the [inventiveness of Art Tatum](https://www.youtube.com/watch?v=aNAJlqn0nO4) than by Massenet). Several months later I decided to transcribe that recording. 

You can find both the recording and transcription [here](http://imslp.org/wiki/Improvisation_on_a_Rainy_Day_%28Coburn,_Rich%29). But before you check them out, I want you to consider this. Generally when you’re reading a score, the composer is absent (and likely buried). Because we have no channel of two-way communication, the score is assumed to be correct, and the performance is judged as more or less good partially in terms of how well it could be said to reproduce the literally and figuratively two-dimensional score. 

In this case, the performance came first; it is in every way correct (except for a couple wrong notes) regardless of what the score says. It’s the score that should be judged based on its ability to represent the performance. 

And I'll be the first to admit, there are some elements that don’t work very well on paper. The major fail was rhythm. For example, there are tons of times that the hands just aren’t playing together. Bar 34 (1:45) is a perfect example. The c and c# on the 4th eighth are about an eighth note apart on the recording, but they both come on the and of 2 conceptually. The hands are just performing rubato independently of each other. How do you write that? 

And am I really supposed to notate all of the rubato I used? And if I mark the really big stretches — which don’t generally play structurally clarifying roles here as they sometimes do elsewhere — doesn’t it imply that the rest is mostly in time? And isn't the nature of rubato freedom, implying that someone else could put them in different places anyway? 

And don’t get me started about voicing (the relative balance of chords) and micro inflections of phrase.

It was astounding to me to consider the vast amount of information that was lost between recording and score. Then I realized that this much information could be missing from every score of every great master I’ve ever read. Trying to bring life to this score, when I played it myself, was like trying to animate a pale shadow of my original conception of the piece. 

The only way to come close to what I originally played (without listening to the recording and copying which is both cheating and boring) is to have a correct understanding of what this score actually represents. That is, it contains most of the fundamental information about the piece (pitches, rhythms, etc.). But almost none of the really interesting information. 

And when you look at it, this score is not so much less detailed than the scores of many great composers. How much information beyond pitches and durations is in a [Bach Prelude](http://conquest.imslp.info/files/imglnks/usimg/9/96/IMSLP02206-BWV0846.pdf)? What about a [Schubert song](http://hz.imslp.info/files/imglnks/usimg/e/e6/IMSLP234915-WIMA.85cb-Schubert_D795.02-Wohin-Part.pdf)? More for sure, but you can still find whole passages completely devoid of it. Or [Tosti](http://petrucci.mus.auth.gr/imglnks/usimg/4/4d/IMSLP52229-PMLP108221-Tosti_Ultima_Canzone.pdf)? Sure there are many markings, but the contrast between the rhythmic simplicity of the score and complexity of a great performance is obvious. 

So, if you haven’t done so yet, I’d encourage you to listen to the [improvisation](http://imslp.org/wiki/Improvisation_on_a_Rainy_Day_%28Coburn,_Rich%29) with the score now. Pay attention to what the score looks like, what you would sing/play if you were presented with the score, and what actually happens. 

And I hope this little experiment can encourage you to consider, philosophically and practically, the relationship a composer had with the next score you are studying.
