+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = "2018-06-21T18:41:00-04:00"
lastmod = "2018-06-21T18:41:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529620312128/sqTRE5.jpg.jpg"
primary_image_credit = "The Rose Elf (Samantha Hankey) Photo: Matthew Placek."
publishDate = "2018-06-21T18:41:00-04:00"
related_articles = ["articles/rb-schlather-susan-b-anthony-connecting-opera-with-community.md","articles/talking-with-singers-samantha-hankey.md"]
related_people = ["scene/people/rb-schlather.md","scene/people/samantha-hankey.md"]
short_description = "Early in the opera the lovers share a moment in which they assume the role of rose petals and enfold the elf, quite literally, within themselves. It was a wildly passionate action, which, like the presence of a life-size elf, distorts our sense of reality, even within the confines of this dark fairy tale."
slug = "the-rose-elf-hot-times-in-the-cool-catacombs"
title = "The Rose Elf: Hot Times In The Cool Catacombs"
+++

The hot and exotic topic concerning the world premiere of *The Rose Elf*, David Hertzberg’s disturbingly romantic opera, and the entire series, *The Angel's Share*, has been the setting - the cool and austere Catacombs of Green-Wood Cemetery. Created at a time when the fear of being buried alive still lingered, it is a dark and somber sanctuary located in Brooklyn. One walks into this interment area, built in the 1850's, through an ornate entrance in the side of a large and sloping hill.

A long dark hall, off which are rooms filled with coffins sealed within the Catacomb walls, sets the scene. Director [R.B. Schlather](/scene/people/rb-schlather/) seizes the obvious limitations and maximizes its musical and dramatic potential. Last year intrepid opera goers saw Schlather, to lively effect, take over an entire opera house, devoid of seats, in Hudson, New York, with the Virgil Thompson/Gertrude Stein opera, [*The Mother Of Us All*](/rb-schlather-susan-b-anthony-connecting-opera-with-community/). The Catacombs shows once again that this adventurous director revels in architectural and acoustical challenges.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529620406656/TRE7.jpg.jpg)
<figcaption>The Brother (Andrew Bogard) in *The Rose Elf*. Photo: Matthew Placek</figcaption>
</figure>

The audience in the Catacombs was arranged on opposite sides of the long hall. A distinct comfort was to be had with the visibility of other people. A nine-piece orchestra conducted by Teddy Poll, showing no indication that the dank surroundings impeded its precision, was placed at the far end. The dimensions of the playing areas can be described as extremely narrow by very long. Hertzberg's composition sounds like it was composed with the setting it mind. (It wasn't.) And the brutalist lighting design by the masterful JAX Messenger at once conquered the space and encouraged audience etiquette. The costumes were an eclectic mix of non-matching flower prints covering every item of clothing. Ranging in look from mod to mad, they had their own lyricism. Despite its extreme dimensions, both literally and figuratively, Schlather gave the opera a solid feel.

The audience had a direct view of one aspect of the story or another, depending on seat location, and an angular view of the others. It was useful to take the advice of *The Angels Share* producer, Andrew Ousley, and give an advance read to the short and quite grim, Hans Christian Andersen fairy tale, on which the opera is based. (It is available for free on [Wikipedia](https://en.wikisource.org/wiki/The_Elf_of_the_Rose).)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529620398333/TRE2.jpg.jpg)
<figcaption>The Girl (Alisa Jordheim), The Lover (Kyle Bielfield), and The Brother (Andrew Bogard) in *The Rose Elf*. Photo: Matthew Placek.</figcaption>
</figure>
 
The long hall was filled with action. At one moment there was a writhing and demonic brother at the far end, his sister's dead lover in the center and the elegantly eerie Rose Elf hovering near the Catacomb entrance. Unless you suffered from a case of the-grass is-always-greener syndrome, you never felt removed. There were enough evil goings-on, fairy tale parading and erotically charged activity to go around.

The story concerns a murder that is witnessed by an elf who lives in a nearby rose. It is a malevolent brother who kills his sister's lover for reasons that become plain as he suggestively crawls over the body. Not entirely sated, he proceeds to emotionally destroy his sister by entering her dreams. The elf, mortified by the act, sets out to punish the brother. In Andersen's tale, neighboring elves and a back-up swarm of bees come into play. In the opera, for which Hertzberg wrote the astringent libretto, justice is ravishingly achieved by the dumping of flower petals from one of the Catacomb's skylights, on to the evil brother.

Hertzberg's libretto consists of pithy and poetic passages that serve as moody guidelines to the story. For the most part, the acoustics work in favor of the singers and their diction is generally good so the projection of the text was not absolutely necessary. The supertitles did, however help us to refocus if the lurid and deftly executed dragging, pulling, caressing, and crushing diverted our attention from the storyline.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529620419769/TRE12.jpg.jpg)
<figcaption>The Lover (Kyle Bielfield) in *The Rose Elf.* Photo: Matthew Placek</figcaption>
</figure>

Hertzberg's music, shimmering and romantic at one moment, foreboding and shocking the next, flourished in an amorphous state that engulfed the Catacombs. Hertzberg may infuriate some who want the composition to fall on one side of modernism or the other, but to this ear, his inventive orchestrations and reoccurring sound arrangements, taking the place of conventional themes, were hallmarks of a piece that was lushly accessible while projecting a lean and contemporary style. The work's relentless atmosphere is what made the music sound so specific to the setting.

Mezzo-soprano, [Samantha Hankey](/talking-with-singers-samantha-hankey/) was an commanding elf, resplendent in a sparkling dress with exaggerated red lips, ears and hands. Elves, of course, are tiny by nature (or fairy tale logic), which the statuesque Hankey is obviously not, but the scale of her imposing presence was spellbinding. Hertzberg assigns much of the vocal heavy lifting to Hankey and she provided deep, rich tones of unearthly vehemence. This elf has a moral center, no minor feat for such an exotic character, and Hankey expressed it with power and commitment.

The character of the Brother, sung by bass-baritone, Andrew Bogard benefited from the acoustical irregularities of the Catacombs, his assured and penetrating voice, sounding genuinely disembodied at times. He is literally corrupting his sister's dreams, a process that was chillingly effective when his voice appeared to emerge from thin air. The physical power of his assault on his sister and her lover and the homoerotic fervor with which he desecrates everything in his path was frightening from any angle.

The victimized lovers were well matched. Kyle Bliefield gave the Lover a winsome charm, as much by his mystified expression as his sweet and clear tenor voice. He was callowness personified, appearing too simple at times to be worth destroying. But we learned that the Brother's evil intent wasn't based on anything intellectual. Soprano, Alisa Jordheim as the Girl, grew in intensity as the fate of her lover and the intrusion of her dreams drove her to madness. Her voice, almost too delicate at first, stiffened and coarsened and her posture became increasingly stilted. The depth of her reaction to the effects of pure evil was a potent expression of the opera's tragedy.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529620413586/TRE9.jpg.jpg)
<figcaption>The Girl (Alisa Jordheim) and The Lover (Kyle Bielfield) in *The Rose Elf*. Photo: Matthew Placek.</figcaption>
</figure>

Early in the opera the lovers share a moment in which they assume the role of rose petals and enfold the elf, quite literally, within themselves. It was a wildly passionate action, which, like the presence of a life-size elf, distorts our sense of reality, even within the confines of this dark fairy tale.

Throughout the relatively short performance, JAX Messenger sculpted a tunnel of light, quite amazing if you stopped to think about it, through the darkness. If one chose to look in the direction of its source, a sense of enhanced interrogation or alien abduction might have been induced. In short order the audience was encouraged to sit back, thereby keeping sight lines clear, and await the characters that would, in one way or another, inevitably approach them. The mood lingered after the performance. Only upon walking from the Catacombs into the night air, did the real world revive itself.

*The Angel's Share* continues in August with two innovative concerts of chamber and piano music and culminates in October with another premiere, Greg Kallor's *Sketches From Frankenstein*, all presented in the Catacombs. More information on this series and Ousley's other, *The Crypt Sessions*, can be found on his ironically titled web site, [deathofclassical.com](https://www.deathofclassical.com/).
