+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-11-25T11:34:00+00:00"
lastmod = "2016-11-25T16:48:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480078918785/2016-11-25---Summer.jpg.jpg"
publishDate = "2016-11-25T16:48:00+00:00"
related_companies = ["scene/companies/cosi-centre-for-opera-studies-in-italy.md"]
short_description = "Your colleagues are not competition. Along with you, the motivated young artist, the singers and pianists that are learning beside you are the ones who, in a handful of years, will become founders of opera companies and concert series; they&#039;ll become assistant conductors and directors, and they may eventually end up in a position to hire someone like you. "
slug = "the-real-value-of-summer-programs"
title = "The real value of summer programs"
+++

For young artists who are straddling the line between training and professional experience, it can seem as though there are nothing but costs along the way to becoming a real-deal opera singer, conductor, or director. They pay for audition recordings, headshots, website design, flights to New York, packable-yet-flattering performance wardrobe, and they certainly pay for their training; if it's not tuition at a university or a conservatory, young artists pay by the hour for lessons and coachings.

Though their bank accounts may not be impressive, opera folk are a driven bunch, and instead of packing their summers full of road trips or days at the beach, many of them seek out summer opera programs as a way to maintain momentum. The perks of summer programs are tempting: a focused, high-paced environment where they can learn from new teachers and coaches, gain experience onstage, and sing auditions - "mock" or otherwise - for people who are difficult to track down on one's own.

And it's true: all of that costs more money.

It's an elective cost, to attend a summer program. Young artists may feel pressure to "make the most" of their summer; they may see their classmates and colleagues heading off to some form of operatic boot camp, motivated to progress, and not regress, during the months between academic years. Or, their teachers may give them the side-eye at the prospect of wasted time, of their not investing in their own professional development.

Young artists, pressure is not a good reason for you to attend a summer program. When the fees seem steep, it's no surprise that you look harder and harder for reasons to justify the cost. The obvious criteria include quality of teachers and coaches; and really, most everything else - what role you get in the show, who you get to audition for, whether or not you get to go somewhere pretty - are rewards that only *you* can reap. 

The real value of a summer program is in relationships. There are many ways to build professional relationships, but programs like the [Centre for Opera Studies in Italy (COSI)](http://www.co-si.com/), gather together a critical mass of industry folk in one place, with the understanding that mingling and socializing are expected and welcome. And while it's always wise to be friendly and open with the conductors, directors, and teachers available, there's incredible value in honing your relationships with fellow participants.

Your colleagues are not competition. Along with you, the motivated young artist, the singers and pianists that are learning beside you are the ones who, in a handful of years, will become founders of opera companies and concert series; they'll become assistant conductors and directors, and they may eventually end up in a position to hire someone like you. Or, they'll be fellow singers who can pass along your name for casting directors who have a few spots to fill for an upcoming production, or to music directors who need a great répétiteur.

Even if it's just evenings spent watching *Planet Earth* together or exploring an Italian market on days off - the time spent with your fellow summer-program-goers counts as networking. It's much more relaxed and honest than, say, a "voluntold" cocktail party where you may be expected to casually drop info about yourself to agents and Artistic Directors, and so you're likely to be better at this kind of professional mingling. 

Summer programs are like every other part of the opera industry; the opportunities are presented, but it's up you, the artist, to take avantage. Once you all go home after a few weeks on the Adriatic coast, it's on you to maintain the relationships you've built. Add them on Facebook, go see shows they're involved in, and let them know when you've got an upcoming gig. Pay attention to where your colleagues end up over the years, and if there's an opportunity for your paths to cross again in person, take the first step in making that happen.

For us in particular, COSI is a great example of a condensed, 5-week period of programs that has earned lasting rewards. We've seen apprentices become Artistic Directors, and we've worked for their new company; we've been paid by the hour to coach the singers we met during that one summer. Even in recent years as the creators of Schmopera, our [impressive list of artist interviews](/what-weve-learned-by-talking-with-108-opera-singers/) has had strong roots in the pool of colleagues whom we know personally.

Not every summer program will offer you quite the same thing, yet for all of them, there's true value in the lasting effects of meeting like-minded colleagues in an environment set up to foster your artistic future. Young artists, realize that you're not paying for a passive, networking-on-a-platter experience; while you may find more immediate value in a series of lessons with your favourite teacher or coach, it's difficult to replicate the benefits of meeting a broader pool of fellow artists, a pool that will inevitably populate the coming generation of operatic talent.

The deadline to apply for the Centre for Opera Studies in Italy's 2017 [Opera](http://www.co-si.com/programs/opera-ensemble/) and [Opera Scenes](http://www.co-si.com/programs/opera-scenes/) programs is **November 27**. Find out more on [COSI's website](http://www.co-si.com/programs/), and get networking over fab pizza at [Il Vecchio Muro](http://www.vecchiomuro.it/).
