+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2019-04-20T13:37:26+00:00"
disclaimer = ""
image_gallery = []
postamble = "Odyssey Opera's Helen of Troy-themed season continues in June with Offenbach's _La belle Hélène_. For details and tickets, [click here](https://www.odysseyopera.org/2019-offenbach-la-belle-helene/)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1555782382/media/2019/04/sqOdysseyOperaOrchestraandEnsemble-pc-KathyWittman.jpg"
primary_image_credit = "The Odyssey Opera Orchestra and Ensemble performing Die Aegyptische Helena, 2019. Photo: Kathy Wittman."
related_articles = []
related_companies = ["scene/companies/odyssey-opera.md"]
related_people = ["scene/people/katrina-galka.md", "scene/people/kirsten-chambers.md", "scene/people/clay-hilley.md"]
short_description = "The plot is rather fantastical even compared to some of Strauss' prior works, to the point that I would almost be tempted to call it hallucinogenic: Helen and Menelaus find themselves washed up on an island where a sorceress enchants Menelaus to fall in love with Helen all over again."
slug = "the-rapture-and-troubles-of-egyptian-helena"
title = "The rapture and troubles of Egyptian Helena"
youtube_url = ""

+++
Whenever one thinks of Richard Strauss and his operas, one inevitably thinks of his early efforts, particularly in _Salome_ and _Elektra_, his depraved early masterpieces with enough lurid content to stand as a benchmark for how opera can, in fact, venture into the gruesome in unexpected ways. What one always seems to forget, however, is that his music is frequently rapturous while doing so, and while some of his later operas lose the hyper-intense subject matter the lush music always remains, particularly when his plots concern themselves with the fantastical. This is especially true of his lesser-performed output, of which there are quite a few of these around.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1555782555/media/2019/04/KirstenChambers-pc-KathyWittman.jpg){{% /md %}}

<figcaption>Kirsten Chambers in Die Aegyptische Helena, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

Perhaps none of these is stranger than _Die Ägyptische Helena_, his penultimate collaboration with Hugo von Hoffmansthal surrounding Helen of Troy. The plot is rather fantastical even compared to some of Strauss' prior works, to the point that I would almost be tempted to call it hallucinogenic: Helen and Menelaus find themselves washed up on an island where a sorceress enchants Menelaus to fall in love with Helen all over again.

> _Ägyptische Helena_ also has an exceedingly difficult score, one whose lushness and scale is unforgiving to orchestra and singer alike.

There's an almost dream-like quality to how the work unfolds across its two-act runtime, a fact that Menelaus tends to lampshade with how he is never quite sure where in reality he is at any given moment. Thus, it’s rather perfect for Strauss' music, which ebbs and flows rhapsodically along as the opera goes through its paces. The music here is absolutely rapturous, and it can be very easy to get caught up in the lush, post-Romantic stylings of this score, particularly in the climaxes when everything typically goes wild.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1555782532/media/2019/04/KatrinaGalka-pc-KathyWittman.jpg){{% /md %}}

<figcaption>Katrina Galka in Die Aegyptische Helena, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

However, as with all Strauss, _Ägyptische Helena_ also has an exceedingly difficult score, one whose lushness and scale is unforgiving to orchestra and singer alike. And this is where some issues can arise, and alas a few issues did indeed arise in Odyssey Opera's concert performance of the work. The primary issue seems to be that the orchestra seemed slightly below the standard I am used to with Odyssey Opera: in particular, this performance was rife with balance issues within the orchestra where a good amount of Strauss' orchestration seemed to have been flattened out by the chordal material coming out too loud, especially from a lot of overzealous brass players.

Even in the non-operatic works, this is deadly in Strauss: letting every orchestral texture speak clearly is critical to establishing the arc of any given work of his, and the fact that this is opera means that it comes with the added problem that the orchestra can also drown the singers completely if it is not careful. Clearly, Maestro Rose did his best to corral his orchestra through some of the trickier balance spots, but even his best efforts could not help an orchestra that seemed insecure with the material.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1555782487/media/2019/04/KirstenChambers_ClayHilley_byKathyWittman.jpg){{% /md %}}

<figcaption>Kirsten Chambers and Clay Hilley in Die Aegyptische Helena, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

As well, where the orchestra was a little bit lacking, it was more than made up for with the stellar cast that rose up to singing Strauss' punishing vocal writing. In particular, [Clay Hilley](/talking-with-singers-clay-hilley) as Menelaus was a thrill to watch. It is rare that tenors get to sink their teeth into really juicy Strauss roles, and Hilley ran with Menelaus, his strident voice managing to carry above the orchestra even in its loudest moments. His acting was also spot on, and he navigated the dream-like arc of his character with incredible commitment. Also notable was [Kirsten Chambers](/scene/people/kirsten-chambers/) as Helen: perhaps Strauss’s writing did not help her in the spots where her tessitura was low, but she also brought a sparkling energy to the queen of Troy, one that helped her transcend the libretto’s admittedly uneven and inconsistent portrayal of the character. She also decided to change gowns twice throughout the concert performance, and while some would likely balk at this I found it to be a great touch that went along with the way the opera presented Helen at different points.

> As per usual, Odyssey Opera should be applauded for bringing a work like this into the Boston stage.

Additionally, there were a few stand-outs in the supporting cast. Of particular note was [Katrina Galka](/scene/people/katrina-galka/)'s Aithra, the sorceress who enchants Helen and Menelaus throughout the work. Her voice may not have had all of the power necessary to project over the orchestra, but it was still bright and crystalline in a way that fit perfectly for the character and the vocal writing. [Won Whi Choi](/scene/people/won-whi-choi/) as Da-ud was also a stand-out for just how easily his voice projected over the proceedings: his role was rather short in the grand scheme of the opera, but he left a huge impact with what little stage time he had.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1555782472/media/2019/04/EricaBrookhyser-pc-KathyWittman.jpg){{% /md %}}

<figcaption>Erica Brookhyser in Die Aegyptische Helena, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

Thus, even despite the missteps in the orchestral playing, this was indeed a performance to remember. While the score is perhaps not up to some of Strauss' best opera scores, it is indeed worthy enough in its own right that it puzzles me why _Die Ägyptische Helena_ does not see more performances, and even with the issues in the orchestra's performance it was still a rapturous evening where it was easy to get caught up in the work's sound world. As per usual, Odyssey Opera should be applauded for bringing a work like this into the Boston stage, as even despite the technical hiccups in the orchestral playing they brought a great reading of this complex, not so frequently heard score to a newer audience.