+++
author = ["authors/greg.md"]
categories = "Review"
date = 2022-06-07T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1654615525/media/2022/06/sqCOC_Queen_DSC_4323_s9bz5v.jpg"
primary_image_credit = "Teiya Kasahara 笠原貞野 in the Canadian Opera Company’s production of The QueenIn Me, 2022. Conductor Daniel Bartholomew-Poyser, co-directors Andrea Donaldson and Aria Umezawa, set and costume designer Joanna Yu, lighting designer André du Toit, projection designer Laura Warren. Photo: Gaetz Photography."
related_articles = ["articles/orlando-gender-bending-and-the-sound-of-androgyny-in-vienna.md", "articles/taking-a-bow-curtain-calls-for-your-voice-type.md"]
related_companies = ["scene/companies/amplified-opera.md", "scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/aria-umezawa.md", "scene/people/teiya-kasahara.md"]
short_description = "The Queen in Me at the Canadian Opera Company is the culmination of years of work by Kasahara and their creative team to create this monolith of a one-person show. A true one-person show -- not a recital, not a cabaret or salon, but a dramatically driven show that would need to be seen to be believed. "
slug = "the-queen-in-me-yas-kween"
title = "The Queen in Me: yaassss kweeeeeeen"
youtube_url = ""

+++
Hello, Schmop-tops!

I have to say: this weekend I witnessed an event.

Usually when I go to review a show, I do my best to settle in and view it more as an actual audience member, not as a juror in a university exam panel. Oftentimes, that can't happen. My analytical brain takes over, choices made may take me out of the universe, any number of distractions over the course of a 3.5-hour operatic production could be the reason I am not always afforded that opportunity.

But [Teiya Kasahara](/scene/people/teiya-kasahara/) got me shook.

_The Queen in Me_ at the [Canadian Opera Company](/scene/companies/canadian-opera-company/) is the culmination of years of work by Kasahara and their creative team to create this monolith of a one-person show. A true one-person show -- not a recital, not a cabaret or salon, but a dramatically driven show that would need to be seen to be believed.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1654615616/media/2022/06/COC_Queen_15_qvawex.jpg){{% /md %}}

<figcaption>Teiya Kasahara 笠原貞野 in the Canadian Opera Company’s production of The QueenIn Me, 2022. Conductor Daniel Bartholomew-Poyser, co-directors Andrea Donaldson and Aria Umezawa, set and costume designer Joanna Yu, lighting designer André du Toit, projection designer Laura Warren. Photo: Gaetz Photography.</figcaption>

</figure>

Devised by Kasahara, this production teams them with the COC's Company-in-Residence [Amplified Opera](/scene/companies/amplified-opera/) and stage director [Aria Umezawa](/scene/people/aria-umezawa/), as well as Andrea Donaldson of Nightwood Theatre - all in co-production with the COC and Theatre Gargantua - to bring us the salve that the opera industry has been craving. We finally have an answer to the age-old click-bait question "Is Opera Dead?" This production provides a loud, proud, definitive "NO" as an answer.

First, let's talk about the singing for a moment. I know Teiya personally; we met working together on _Figaro's Wedding_ with [Against the Grain Theatre](/scene/companies/against-the-grain-theatre/) and I also cast them as the Queen of the Night in my Confidential Opera Project. The growth between then and now is exponential.

> What if the soprano singing these roles day in and day out and portraying these women onstage doesn't identify as a woman themselves?

Teiya always had strength and clarity and cleanliness. What we have now is that strength turned into a power that has an elasticity and depth. They sings their Verdi like Mozart and vice versa. It's an instrument that just gets better and better the more you hear it. Also we need to give a shoutout to their stamina: at no point during the almost over 90-minute runtime where they sang everything from QotN to Turandot to Lady Macbetto to Lucia and back again _all while delivering mountains_ of divinely delivered spoken text, and at _no point_ was there even a whisper of fatigue.

Now, let's talk about the show. The show has The Queen set on a pedestal in the middle of a compacted stage space - reminiscent of a punch-and-judy puppet theatre or one of those 25-cent fortune teller game things. (Think the movie [_BIG_](https://youtu.be/Q6RK4479XD8)_._) They spend the entire duration of the performance locked in this one position, the queen's dress actually bleeding into and becoming part of the pedestal itself, her hands covered in absurdly long sleeves that simultaneously added to the movement of the arms while hiding the hands completely.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1654615630/media/2022/06/COC_Queen_25_h2qcks.jpg){{% /md %}}

<figcaption>Teiya Kasahara 笠原貞野 in the Canadian Opera Company’s production of The QueenIn Me, 2022. Conductor Daniel Bartholomew-Poyser, co-directors Andrea Donaldson and Aria Umezawa, set and costume designer Joanna Yu, lighting designer André du Toit, projection designer Laura Warren. Photo: Gaetz Photography.</figcaption>

</figure>

The story begins with a "traditional" delivery of "Der Hölle rache", which Queen quickly halts, stopping the show and letting the conductor and audience in on what struggles Queen has been dealing with. The inherent misogyny, white supremacy, among a host of other issues that every soprano has to deal with when playing these, albeit beloved, problematic women over and over. They discuss the lenses through which the roles are presented as well as viewed. They discuss what happens when you're an artist with the instrument but you don't fit the "cookie-cutter" mould that companies seem to use as a template for all their casting choices.

>  Kasahara is proof positive that opera singers, when given the breathing room, can indeed act - and skillfully to boot.

They call out the fact that if a female lead doesn't die, she gets married. They talk about the struggle of living your life out of a suitcase as a travelling performer, but still expected to be a whole-ass grounded human when you hit the stage. There's shade thrown at audiences, there's shade thrown at people who think they know another person's voice better than they do; there was a great dig at people who use the phrase "Is she a mezzo or just a lazy soprano?"

Then at this point, the show gets even more personal, if you can imagine. What if the soprano singing these roles day in and day out and portraying these women onstage doesn't identify as a woman themselves?

The show ends with a return to the iconic aria from _Magic Flute_ and here's where I was destroyed. After spending the entirety of the show sequestered in one position, she begins to reveal their true form - their actual body. Their muscular arms are revealed earlier on, but is taken to the next level as the show ends in them removing their "shackled" (the hyper-feminine form of the stylized QotN) to reveal and free their real, trans body. A beautiful, whole, happy, talented, sacred body that deserves to be celebrated, that deserves to be unshackled and take up their own space. With all bias aside: I will honestly say it was one of the most powerful moments of theatre I've experienced in years.

You bet your sweet bippy I ugly-cried a few times.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1654615643/media/2022/06/COC_Queen_DSC_4175_nh03xg.jpg){{% /md %}}

<figcaption>Teiya Kasahara 笠原貞野 in the Canadian Opera Company’s production of The QueenIn Me, 2022. Conductor Daniel Bartholomew-Poyser, co-directors Andrea Donaldson and Aria Umezawa, set and costume designer Joanna Yu, lighting designer André du Toit, projection designer Laura Warren. Photo: Gaetz Photography.</figcaption>

</figure>

Kasahara's Queen is acted beautifully and they show a remarkable mastery of a thick German accent. They slide effortlessly between speaking and singing, and as someone who does that on a regular basis as part of my repertoire, it's not as easy as it sounds. The spoken texts were amplified by microphone while the singing was acoustic. Big props to the sound board for mixing it so exquisitely that there difference between spoken and sung text was almost imperceptible.

The orchestra under the baton of Daniel Bartholomew-Poyser played thrillingly. This show required a wide range of operatic literature that requires completely different orchestra sizes. Bartholomew-Poyser and the musicians of the COC Orchestra made each except sound as though they were playing with an orchestra contracted specifically for each work. Bravi!

A lot of the spoken text was delivered as melodrama (spoken text over orchestration), which is an art in its own right. Kasahara's Queen delivered both grandeur and sincerity simultaneously. Kasahara is proof positive that opera singers, when given the breathing room, can indeed act - and skillfully to boot.

This is the kind of show we need right now: Political without being preachy, informative without being condescending, and vulnerable without being traumatic. The energy in the audience was electric. Both really funny and really poignant, it felt the way it _should_ feel at live theatre. Whether it's opera, a play, a ballet, or musical - if you tell a truthful story, your audience will respond. And this one did. Their standing ovation was more than deserved.

In fact, I still don't think I've sat down yet.

PS: Happy Pride to my fellow LGBTQIA2S+ family! I hope you're living your truth out loud and taking up your space! You have my love - now and always.