+++
author = ["authors/thomas-pierce.md"]
categories = "Review"
date = "2017-12-19T21:03:00-05:00"
lastmod = "2017-12-19T21:03:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513735176151/sq---DOMINIC-SEDGWICK-AS-MARULLO%2C-DIMITIRI-PLATANIAS-AS-RIGOLETTO-ROH.-PHOTO-BY-MARK-DOUET_31B2186.jpg.jpg"
primary_image_credit = "Dimitri Platanias in the title role of Rigoletto, ROH, 2017. Photo: Mark Douet."
publishDate = "2017-12-19T21:03:00-05:00"
related_articles = ["articles/in-review-rigoletto-at-eno.md","articles/searching-for-superlatives-locs-suberb-rigoletto.md","articles/great-music-distracting-sexuality-rigoletto.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/rolando-villazon.md","scene/people/dimitri-platanias.md","scene/people/sofia-fomina.md","scene/people/lucy-crowe.md"]
short_description = "A patch of barbed wire symbolised Gilda&#039;s fragility in this ruthless world. Giovanna, Gilda&#039;s nurse, meets the Duke and the two converse through the fence. A slit in the middle of it, hinting at Gilda&#039;s sexuality, becomes the medium for the Duke to bribe Giovanna, and he punches his fist through it in boorish coarseness. Gilda is clearly too pure for this world."
slug = "the-price-of-vengeance-rigoletto-at-roh"
title = "The price of vengeance: Rigoletto at ROH"
+++

Vendetta: that infamous word, tarnished by association with Mafia bloodshed and *The Godfather*. Vendettas have a nasty tendency to self-perpetuate, as each act of retribution in turn generates further reprisals, ad infinitum. The burning lust for revenge can be passed on for generations, until groups have long forgotten why they despise their opponents in the first place. Vendetta plays a central role in Verdi's opera *Rigoletto*. After all, one of the eponymous character's most celebrated arias is "Si! Vendetta, tremenda vendetta!"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513721877182/2017-12-20---RIGOLETTO-PRODUCTION-IMAGE-ROH.-PHOTO-BY-MARK-DOUET_80A1575.jpg.jpg)
<figcaption>Production image from *Rigoletto*, ROH, 2017. Photo: Mark Douet.</figcaption>
</figure>

Rigoletto is a pitiful character. Hunch-backed, and in this production reliant on walking-sticks too, his job as professional pain-in-the-arse to the court of Mantua wins him few friends. The sole joy in his life is Gilda, his virtuous daughter. In contrast to her, the ball scene in the first act was sexed-up to the extreme. Given what I like to call the "Game of Thrones treatment", exposed breasts and graphic sex occupied the stage, culminating in two chorus members being totally stripped naked. A bit much for the first fifteen minutes. Scene two meanwhile featured Gilda as the quintessential chaste maiden, swanning around stage in a silken white gown. Never in my life have I been so receptive to sexual purity. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513721907427/2017-12-20---SOFIA-FOMINA-AS-GILDA%2C-DIMITIRI-PLATANIAS-AS-RIGOLETTO-ROH.-PHOTO-BY-MARK-DOUET_31B2293.jpg.jpg)
<figcaption>Sofia Fomina (Gilda) and Dimitri Platanias (Rigoletto) in *Rigoletto*, ROH, 2017. Photo: Mark Douet.</figcaption>
</figure>

Despite the misfortunes of his life, Rigoletto's suffering only intensifies. He unwittingly assists in the abduction of his own daughter, leading to her rape. Though determined to seek revenge against the Duke, Gilda begs her father not to. At the end Gilda sacrifices herself to save the Duke, dying in Rigoletto's arms. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513721967754/2017-12-20---SOFIA-FOMINA-AS-GILDA%2C-NADIA-KRASTEVA-AS-MADDALENDA%2C-MICHAEL-FABIANO-AS-DUKE-OF-MANTUA-ROH.-PHOTO-BY-MARK-DOUET_31B2738.jpg.jpg)
<figcaption>Sofia Fomina (Gilda) Nadia Krasteva (Maddalena), and Michael Fabiano (Duke) in *Rigoletto*, ROH, 2017. Photo: Mark Douet.</figcaption>
</figure>

Through their behaviour we see two radically different systems of morality clash. Rigoletto represents a machismo code of honour, seeking to avenge any insult and maintain his esteem, similar to the concepts of *time* (honour) and *aidos* (shame) in Classical Greek drama. In contrast Gilda represents traditional Christian morality, hence her costume of purest white. Despite being violated by him, she forgives the Duke, and when his life is imperilled she surrenders her own to protect his. Her actions parallel the Christian teaching that Jesus died for the humanity. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513722089318/MICHAEL-FABIANO-AS-DUKE-OF-MANTUA-ROH.-PHOTO-BY-MARK-DOUET_50A5615.jpg.jpg)
<figcaption>Michael Fabiano (Duke of Mantua) in *Rigoletto*, ROH, 2017. Photo: Mark Douet.</figcaption>
</figure>

The opera contrasts these two opposing schools of ethics, one based on honour and the other on mercy. But Verdi doesn't rush to any firm conclusions on which is preferential. Though Gilda is pitied as a victim of rape, her hunchbacked and ostracized father is equally moving. When Rigoletto plots revenge we eagerly support him. He is not an alpha male reinforcing his superiority but rather seeking justice for his only child. Rigoletto is the underdog, so of course we root for him.   

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513722099285/DIMITIRI-PLATANIAS-AS-RIGOLETTO-ROH.-PHOTO-BY-MARK-DOUET_50A4075.jpg.jpg)
<figcaption>Dimitri Platanias (Rigoletto) in *Rigoletto*, ROH, 2017. Photo: Mark Douet.</figcaption>
</figure>

It is only in the final scene that Verdi reveals his true colours, when Rigoletto discovers that the body before him isn't the Duke but his only daughter. Our hearts ache as he weeps over the loss of his only joy. But Verdi is clear in his message: no one can come out of vendetta unscathed. Those who seek vengeance will be paid back in full. Even those who appear justified in their actions, such as the outcast Rigoletto, cannot escape the consequences. If he had not sought revenge then his daughter would not have died. It is only through forgiveness that we can heal and move on. Vendetta is nothing but a whirlpool, growing and growing until it devours everything. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513722113276/ANDREA-MASTRONI-AS-SPARAFUCILE-ROH.-PHOTO-BY-MARK-DOUET_50A7551.jpg.jpg)
<figcaption>Andrea Mastroni as Sparafucile in *Rigoletto*, ROH, 2017. Photo: Mark Douet.</figcaption>
</figure>

The scenery was heavily sombre, a suitable reflection of the opera's moral themes: here we have a world of ugliness, dominated by violence and spite, abuse and tragedy. Gilda, garbed in piercing white, appears as the saviour to this wretched world. And while the courtiers and Duke might be magnificently arrayed in dazzling jewel tones, the sumptuousness merely disguises their inner barrenness. A patch of barbed wire symbolised Gilda's fragility in this ruthless world. Giovanna, Gilda's nurse, meets the Duke and the two converse through the fence. A slit in the middle of it, hinting at Gilda's sexuality, becomes the medium for the Duke to bribe Giovanna, and he punches his fist through it in boorish coarseness. Gilda is clearly too pure for this world. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513722130665/2017-12-20---RIGOLETTO-PRODUCTION-IMAGE-ROH.-PHOTO-BY-MARK-DOUET_80A1206.jpg.jpg)
<figcaption>Production image from *Rigoletto*, ROH, 2017. Photo: Mark Douet.</figcaption>
</figure>

[Covent Garden's *Rigoletto*](http://www.roh.org.uk/productions/rigoletto-by-david-mcvicar) emphasises the ethical complexities which pervade this opera. This is not a simple tale of good triumphing over bad. Rigoletto could easily be portrayed as a villain, inadvertently assisting in the abduction and killing of his own daughter and plotting the murder of the Duke. But instead he is a victim, further misled by his own warped morals. Clutching Gilda's corpse he cries "la maledizione!" (the curse). But was it really the curse which brought about his misfortune or his own actions? Just as in reality, the answer is far from straightforward.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513722141706/2017-12-20---RIGOLETTO-PRODUCTION-IMAGE--ROH.-PHOTO-BY-MARK-DOUET_80A1331.jpg.jpg)
<figcaption>Production image from *Rigoletto*, ROH, 2017. Photo: Mark Douet.</figcaption>
</figure>

>[Rigoletto](http://www.roh.org.uk/productions/rigoletto-by-david-mcvicar) continues at the Royal Opera House through January 16, 2018. For details and ticket information, follow our box office links below.
