+++
author = ["authors/michael-pecak.md"]
categories = "Review"
date = "2017-09-12T10:19:00-04:00"
lastmod = "2017-09-13T12:01:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505237921168/2017-09-12---square---Blu-Rhythm-Collective-CCP-Final-performance-1-c.-Michael-Brosilow.jpg.jpg"
primary_image_credit = "Blu Rhythm Collective, Community Created Performances, 2017. Photo: Michael Brosilow."
publishDate = "2017-09-12T13:48:00-04:00"
related_articles = ["articles/in-review-stars-of-lyric-opera.md","articles/in-review-obeah-opera.md","articles/he-saidshe-said-tapex-metallurgy.md","articles/orphee.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
short_description = "The stories they shared were uniquely told yet, sadly, all too familiar in today’s social and political climate. Drawn from the performers&#039; own lived experiences, messages of solidarity and discrimination, faith and dejection, success and failure were accented against that complex mosaic of a backdrop: Chicago."
slug = "the-positive-impact-of-community-created-performances"
title = "The &quot;positive impact&quot; of Community Created Performances"
+++

Maya Angelou once asserted that "there is no greater agony than bearing an untold story inside of you." The three groups that performed at the Harris Theater this past Sunday afternoon commanded a full house with the urgency and creativity of their respective stories. [Kuumba Lynx](http://www.kuumbalynx.com/), [YOLO Boomers](https://www.youtube.com/watch?v=5HhHc41UtB8), and [Blu Rhythm Collective](https://www.facebook.com/Blurhythmchicago/) – groups of Chicago artists from diverse neighborhoods and of varying ages – were the selected finalists of this year's [Community Created Performances](https://www.lyricopera.org/concertstickets/calendar/2017-2018-other/productions/lyricopera/community-created-performances), an outreach program part of the Chicago Voices initiative (spearheaded by Renée Fleming) and all under the aegis of the [Lyric Opera of Chicago](/scene/companies/lyric-opera-of-chicago/). With $10,000 and a Lyric-hired creative team, each group utilized their talents in dance, song, hip-hop, script- and lyrics-writing to develop their distinct narratives into fully staged music-theater productions.
 
The stories they shared were uniquely told yet, sadly, all too familiar in today’s social and political climate. Drawn from the performers' own lived experiences, messages of solidarity and discrimination, faith and dejection, success and failure were accented against that complex mosaic of a backdrop: Chicago.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505238139222/2017-09-12---Kuumba-Lynx-CCP-Final-performance-2-c.-Michael-Brosilow.jpg.jpg)
<figcaption>Kuumba Lynx, CCP final performance. Photo by Michael Brosilow.</figcaption>
</figure>
 
In *We Get Free*, [Kuumba Lynx](http://www.kuumbalynx.com/) suffers a setback when their star poet, Afeni, played superbly by Alexis Pettis, has to back out of the ensemble's important upcoming show due to a family crisis: her otherwise upstanding brother has been arrested and for no apparently clear reason beyond the tacitly understood one. In her solo number, Pettis sang expressively a sister's tender exasperation at the circumstances, but her words, "waiting and hoping," were as much outwardly aimed as they were inwardly roused. The group's message was driven home in a chorus blaring the question, "Where you at?" Punctuating the drama were several impressive ensemble and solo dance pieces, expertly choreographed and executed. A particular standout was the character 99, played by the charismatic Marshan "Shan the Mac" Hall, whose cool stage presence, smooth rhymes, and killer steps elicited many spontaneous cheers from the audience.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505238184564/2017-09-12---Kuumba-Lynx-CCP-Final-performance-6-c.-Michael-Brosilow.jpg.jpg)
<figcaption>Kuumba Lynx, CCP final performance. Photo: Michael Brosilow.</figcaption>
</figure>
 
[Blu Rhythm Collective](https://www.facebook.com/Blurhythmchicago/) offered a similarly heart-breaking glimpse of urban realities in their show *Out of the Blu*. A revered choreographer returns to the Windy City to work with the dance troupe. With only four spots available, the young dancers vie for her attention, showing off their latest moves and, more importantly, showing her "how Chicago does dance." Tempers flare and cries of joy soon fill the room as cuts are announced. Steph, an undeniably talented dancer played by JC Hopkins, is sorely peeved when he isn't called — his pronounced attitude problem and nonchalant tardiness clearly didn't jive with the no-nonsense choreographer. Steph's friend London Williams, however, is selected for the show and seems to have everything going his way: a supportive mother, a girlfriend, scholarship offers to college. Nadell Jackson, who played the role, impressed with his boundless energy and enthusiasm. Yet what begins as a story about attitude-being-a-little-thing-that-makes-a-big-difference quickly takes a turn toward the real when London is indiscriminately shot on the street in the presence of his dance-mates. As Steph clenches his friend's limp body and others grieve around them, we hear the poignant words, "when will my city awaken?," sung by the distraught choreographer. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505238212245/2017-09-12---Blu-Rhythm-Collective-CCP-Final-performance-4-c.-Michael-Brosilow.jpg.jpg)
<figcaption>Blu Rhythm Collective, CCP final performance. Photo: Michael Brosilow.</figcaption>
</figure>

In the face of such senseless violence and increasingly forbidding city streets, a place like the dance studio serves as a crucial sanctuary, a true safe space for people — especially the young — where they can focus, collaborate on something bigger than themselves, and move their lives forward in a positive direction. Like the group they portrayed, Blu Rhythm Collective featured some exceptional dancers noteworthy for their blazing footwork and tight choreography. Mikie Thomas (playing the part of Marcus) deserves special mention equally for his dancing as for his rapping.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505238222924/2017-09-12---Blu-Rhythm-Collective-CCP-Final-performance-5-c.-Michael-Brosilow.jpg.jpg)
<figcaption>Blu Rhythm Collective, CCP final performance. Photo: Michael Brosilow.</figcaption>
</figure>

Bisecting these two acts was *Off Our Rockers*, a refreshing, funny, though no less moving, show by [YOLO Boomers](https://www.youtube.com/watch?v=5HhHc41UtB8), which proved that age — and walkers — need not inhibit "carpe diem" as a truly lifelong pursuit. This group of sexa-, septua-, and octogenarians embrace change and newness at a time in life when convention dictates inertia, complacency, and routine. The show itself consisted of vignettes about the members of YOLO Boomers and the community they form at the Senior Center. Whether closing decades-old family businesses, signing up for 21st-century social causes, enrolling in dance classes, lamenting lost loves or finding new ones at Senior Speed Dating, why should they (and by extension, we) be put off by new adventures and challenges? Aren't we all just "looking for someone to cherish a while longer before we perish?" Chuckles aside, the real poignancy in YOLO Boomers' show rested not in the presumption of clear-cut, grandstanding answers to growing older, but rather in embracing the uncertainty and ultimately unanswerable questions themselves with humor, humility, and openness. I dare say there was hardly a dry eye in the house to the chorus refrain, "All the questions I should have asked."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505238250262/2016-09-12---YOLO-Boomers-CCP-Final-performance-8-c.-Michael-Brosilow.jpg.jpg)
<figcaption>YOLO Boomers, CCP final performance. Photo: Michae Brosilow.</figcaption>
</figure>
 
The standing ovation that concluded the performance was genuinely deserved for all three groups. And a special shout-out must go to the whole creative team that helped materialize the artistic visions, particularly Jess McLeod (Artistic Supervisor and Director), Derek Lee McPhatter (Scriptwriter), Mike Przygoda (Songwriter and Music Supervisor), and Collette Pollard (Scenic Designer) for her stunning L-track set.

This is just the second year of [Chicago Voices Community Created Performances](https://www.lyricopera.org/concertstickets/calendar/2017-2018-other/productions/lyricopera/community-created-performances), but its positive impact on the City of Chicago is already felt. Lyric Unlimited has shown that more than 80,000 people have participated in the Initiative in some way since its inception in 2016. If the enthusiastic reception of Sunday's crowd is any indication, Chicago Voices has a bright future ahead. This proud Chicagoan looks forward to hearing the stories yet to be told in the years ahead.

