+++
author = ["authors/andrew-schneider.md"]
categories = "Review"
date = "2019-04-30T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "_The Phoenix_ runs at Houston Grand Opera through May 10. For details and tickets, [click here](https://www.houstongrandopera.org/thephoenix)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1556668566/media/2019/04/sqHGOThePhoenixPhotographerLynnLane-110.jpg"
primary_image_credit = "Rihab Chaieb as Wolfgang Amadeus Mozart in The Phoenix, Houston Grand Opera, 2019. Photo: Lynn Lane."
related_articles = ["articles/talking-with-singers-luca-pisaroni.md", "articles/talking-with-singers-thomas-hampson.md"]
related_companies = ["scene/companies/houston-grand-opera.md"]
related_people = ["scene/people/elizabeth-sutphen.md", "scene/people/chad-shelton.md", "scene/people/lauren-snouffer.md", "scene/people/rihab-chaieb.md", "scene/people/luca-pisaroni.md", "scene/people/thomas-hampson.md"]
short_description = "In short, if this opera causes such a heady discussion about how best to fertilize our soil with culture, philosophy, and the pursuit of authentic enlightenment, it certainly deserves not only the reviews that will surely come up about it, but a whole book of Platonic dialogues as well!"
slug = "multifaceted-success-hgos-the-phoenix"
title = "Multifaceted success: HGO's The Phoenix"
youtube_url = ""

+++
Houston Grand Opera's world premiere of Tarik O'Regan's _The Phoenix_ effectively showcased how an opera's success can increase in direct proportion to the variety of messages it might impart. Finding one single way of looking at this thought-provoking work is extremely challenging, but then, a biographer's task often approaches this level of difficulty in the challenge of finding one single way of telling a figure's life story in a sufficiently all-encompassing manner to be compared with Chernow, Thayer, or McCullough.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1556669123/media/2019/05/HGOThePhoenixPhotographerLynnLane-28.jpg){{% /md %}}

<figcaption>(l-r) Luca Pisaroni (Lorenzo Da Ponte Jr./"Enzo"), Elizabeth Sutphan (Faustina), Thomas Hampson (Lorenzo Da Ponte), and Lauren Snouffer (Giulietta) in The Phoenix, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>

</figure>

The text of this work, by John Caird, presents an ingenious solution: a play-within-a-play version of the life of Lorenzo da Ponte, the Italian librettist who, it turns out, was active in so many different spheres besides writing the text to the operatic masterworks of the great Mozart. In this way, the great Venetian intends to establish New York's first opera house in 1832 by raising money with this theatrical performance. Here he is presented as a roguish intellectual with revolutionary, anti-monarchist tendencies who found himself fending off creditors and political repression at every opportunity.

>What he might have lacked in sheer force, he more than made up for in acting prowess and an energetic disposition which showcased his lust for life.

Although the bilingual English-Italian libretto (effortlessly switching between the two) has a way of being extremely detailed and pandering to American stereotypes of certain character archetypes (in the manner of many a Showtime television drama), nevertheless, it very ably probes the question of da Ponte's life as one of identity, which is constantly in flux, as he reinvents himself constantly (in the manner of _Così_'s "Arabian phoenix") throughout his odyssey of travel throughout the world.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1556669003/media/2019/05/HGOThePhoenixPhotographerLynnLane-69.jpg){{% /md %}}

<figcaption>Thomas Hampson (Lorenzo Da Ponte) in The Phoenix, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>

</figure>

Even his name turns out to not be his own, but rather that of the bishop of Ceneda who baptized him as a young 13-year old convert from Judaism, Emanuele Conegliano (Gabriel Magallón), and gave him an old copy of Virgil's Aeneid, which sparks in him a zest for adventure. All of this finally comes to a head as he, the free-thinker who is very interested in the new American Republic forming across the water finally comes to the New Frontier of Jeffersonian democracy, which he perceives as the perfect place to sow "the value of art for all my fellow men," to foster concord, under the bright and coveted aegis of press freedom. (Who knows if under President Adams's Alien and Sedition Acts, he might have been perceived as the exact foreign or revolutionary influence that the Federalists would seek to eject?)

>It is as if Tarik O'Regan thinks that all tenors are character tenors and that none are the heroic or lyric ones of old.

The magisterial [Thomas Hampson](/talking-with-singers-thomas-hampson/) plays the elderly and elegiac scholar looking back on life, and what he might have lacked in sheer force, he more than made up for in acting prowess and an energetic disposition which showcased his lust for life; he definitely portrayed someone who was always in the present moment, waiting for his next adventure. (My favorite moment was when this cantankerous man said something to the effect of, "But of course Americans need to learn Italian; the tongue of Petrarch, Boccaccio, Dante, all good persons should want to better themselves accordingly." Jefferson would be pleased at this "virtuous yeoman.")

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1556668976/media/2019/05/HGOThePhoenixPhotographerLynnLane-92.jpg){{% /md %}}

<figcaption>Luca Pisaroni (Young Lorenzo Da Ponte) and Elizabeth Sutphen (Annetta) in The Phoenix, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>

</figure>

The vibrant and [Luca Pisaroni](/talking-with-singers-luca-pisaroni/) played his son, Enzo, but also doubled as the younger, eager, brooding Da Ponte during the course of the first act, which takes on the form of a picaresque adventure during which he meets so many vibrant characters who provide the impetus of his journey. They frequently engage in dialogue across the generations, but in no moment quite as affecting as one time in the Susquehanna River Valley where Enzo and Da Ponte come across a newspaper clipping showing that _Don Giovanni_ was a success, but with no mention of Mozart, let alone him, and where these two engage in existentialist contemplation.

>Mezzo Rihab Chaieb, with great ability to sustain cantabile line, portrayed several roles of her own, including the caricaturishly foul-mouthed and fiery young Wolfgang Amadeus Mozart.

Many of the characters who represented the character of patron were played by tenor [Chad Shelton](/scene/people/chad-shelton/), who felt curiously out of his element in these character tenor roles, written in a very low register which sounded uncomfortable. Few, if any, were the sustained and declamatory high-note moments in which this tenor would be manifestly more comfortable. It is as if Tarik O'Regan thinks that all tenors are character tenors and that none are the heroic or lyric ones of old.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1556668941/media/2019/05/HGOThePhoenixPhotographerLynnLane-104.jpg){{% /md %}}

<figcaption>Luca Pisaroni (Young Lorenzo Da Ponte) and Rihab Chaieb (Wolfgang Amadeus Mozart) in The Phoenix, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>

</figure>

Shelton played the roles of the aforementioned Bishop of Ceneda who baptizes Lorenzo, the legendary roué Giacomo Casanova, the enlightened Emperor Joseph II who is wracked by illness during a war with the Ottomans while Europe is heady with revolutionary sentiment, the slimy impresario-politician "Opera" Taylor who continually delays payment to da Ponte in London, and Clement Clarke Moore, who eventually comes to give Da Ponte a great deal of financial support in the United States (the patter aria that Da Ponte sings to him listing all the important post-Renaissance Italian authors was a particular tour de force; it certainly gave me some ideas for Italian reading practice, particularly as I have heard several such names via the highly informative, and highly recommended YouTube channel Treccani Scuola), as well as Patrick Kelly, the colorfully disinterested singer tasked in the work of singing all these personae.

Mezzo [Rihab Chaieb](/scene/people/rihab-chaieb/), with great ability to sustain cantabile line, portrayed several roles of her own, including the caricaturishly foul-mouthed and fiery young Wolfgang Amadeus Mozart, though such a snapshot can inevitably only capture one side of this composer, notable for his ill-disguised envy of the success of Italians like Salieri on the stage. Chaieb also portrayed Da Ponte's wife, Nancy, during her motherhood of several of his children, in an affecting manner, focusing on their collaboration during the American years of hardship, as well as Maria Malibran, somehow involved in this quixotic meta-theatrical venture. The inevitable consequence, regrettably, of the focus on biography was the fact that the female characters were rather in the background much of the time, often playing the role of ciphers with names, though vocally very active.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1556668894/media/2019/05/HGOThePhoenixPhotographerLynnLane-123.jpg){{% /md %}}

<figcaption>(l-r) Rihab Chaieb (Nancy Da Ponte) and Luca Pisaroni (Young Lorenzo Da Ponte) with the Houston Grand Opera Chorus in The Phoenix, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>

</figure>

While [Lauren Snouffer](/scene/people/lauren-snouffer/) and Elizabeth Sutphen were extremely gifted at playing Da Ponte's nieces (as well as his mistresses in flashback moments), and had several coarse moments where they could poke the ribs of the current American political establishment to gratify liberal sentiment, they were otherwise just doing things backstage much of the time, but always with portamento and roulades, as well as the occasional affecting lullaby.

>I would generally say, ironically, that this composer shows himself to be considerably better at setting Italian than English.

The music was generally aroused much interest in terms of its varied characterization, pacing, and texture as well as fluency of forward movement. Though this opera has passages resembling arias, they are more in the form of dramatic monologues, with frequent interjections by other characters, and never losing their connection to the outside action. Indeed, O'Regan is very skilled at juxtaposing many different concurrent situations at once, in a manner which people love observing about Mozartian ensembles. One particular example was Da Ponte giving the male chorus an Italian lesson while his wife gave the women's chorus a French one. Though O'Regan's music in the concerted choral numbers had a tendency to sound generically Disney-like, it did show a certain brilliance in orchestration, though Maestro Patrick Summers did have some great difficulty reining in the ensemble in the most jubilant moments.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1556668816/media/2019/05/HGOThePhoenixPhotographerLynnLane-134.jpg){{% /md %}}

<figcaption>(l-r) Elizabeth Sutphen (Anna Morichilli), Luca Pisaroni (Young Lorenzo Da Ponte), and Lauren Snouffer (Brigida Banti) in The Phoenix, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>

</figure>

O'Regan's renowned command of _a cappella_ choral writing was very much in high relief in several moments in this production, particularly at the death of Joseph II and Mozart in quick succession, and at Da Ponte's naturalization ceremony, which sported an accurate 24-star United States flag. I would generally say, ironically, that this composer shows himself to be considerably better at setting Italian than English for some reason, though it cannot be denied that this could have been an intentional choice in regard to the characters being non-native English speakers.

>It certainly deserves not only the reviews that will surely come up about it, but a whole book of Platonic dialogues as well!

However, in arousing such an issue, he also makes the valid point: "What is the United States of America but a bunch of non-English speakers vying to assimilate alongside British colonists?" Iconic among these being President Van Buren, chief executive at the time of Da Ponte's death and a native Dutch speaker.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1556668828/media/2019/05/HGOThePhoenixPhotographerLynnLane-205.jpg){{% /md %}}

<figcaption>Luca Pisaroni, (Lorenzo da Ponte Jr./"Enzo") and Thomas Hampson (Lorenzo Da Ponte) in The Phoenix, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>

</figure>

Who knew that a librettist from one of the oldest republics in the world would end up in a land itself eventually enduring the divide between Jackson and Clay over just what the Founders' democratic ideal might imply? At least we might all agree with Da Ponte's thesis towards the end that "without art, America will die."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1556668840/media/2019/05/HGOThePhoenixPhotographerLynnLane-228.jpg){{% /md %}}

<figcaption>(l-r) Luca Pisaroni, (Lorenzo da Ponte Jr./"Enzo"), Thomas Hampson (Lorenzo Da Ponte), and Rihab Chaieb (Nancy Da Ponte) in The Phoenix, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>

</figure>

At any rate, as this review must end, so too, did this opera, but it ended three times! You will have to go to this opera to see what I refer to, but the process did cause the audience some confusion, even though they were happy to rapturously applaud each and every time. In short, if this opera causes such a heady discussion about how best to fertilize our soil with culture, philosophy, and the pursuit of authentic enlightenment, it certainly deserves not only the reviews that will surely come up about it, but a whole book of Platonic dialogues as well! (But I am sure that Da Ponte's ghost will be satisfied if we all practice our Latin and Italian reading in the meantime. _Avanti! Excelsior!_)