+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2016-04-13T16:35:00+01:00"
lastmod = "2016-04-14T16:08:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1460645134023/2016-04-14---Orchestra.jpg.jpg"
primary_image_credit = "Painting by Adolph Menzel, c. 1850. Photo: commons.wikimedia.org"
publishDate = "2016-04-14T16:03:00+01:00"
related_articles = ["articles/putting-on-show-instrumentalists.md"]
related_companies = ["scene/companies/city-of-london-sinfonia.md","scene/companies/toy-piano-composers.md","scene/companies/indie-opera-to.md"]
short_description = " The necessities of large-scale concerts like these are a reality; bodies need to be shuffled, chairs need to be added, and tuning needs to happen. But, why ignore the listeners during any of this? There&#039;s a difference between a relaxed environment, and one that ignores the fact that they&#039;re performers. Onstage housekeeping is the perfect opportunity for musicians to communicate with their listeners, and prove that they&#039;re human beings as well as talented artists. Talk to them, guys! "
slug = "the-orchestra-problem-should-they-smile-more"
title = "The orchestra problem: should they smile more?"
+++

There's an interesting contrast that happens on the stage during classical music concerts, the kind that feature large-scale orchestras, performing symphonies and tone poems in spacious, acoustically friendly concert halls. Between the thrilling and moving moments of music, there's are equally stunning moments of disconnect, where an invisible wall is put up around the players. Between pieces, and even movements, it's common to see the orchestra slip out of "performance mode", sharing a few words with their neighbours and picking at their clothes; we'll never forget hearing the sound of a soda can being opened by a brass player at the Met during a performance of *La bohème*. 

During these lulls, extra music stands are added or removed, new artists join the stage and others, done with their portion of the evening's music-making, shuffle off. All this is done unceremoniously; it's true that these concert halls don't offer the privacy of a curtain behind which to get all the housekeeping done; yet concerts of this scale seem to feel immune from something that's a priority in other music genres, and that's the fact that they're putting on a show.

It's a habit we see [over and over](/putting-on-show-instrumentalists/), from multiple orchestras in multiple countries. It almost appears as though it's "uncool", "naïve", or the sign of lesser orchestral musicians for them to smile, acknowledge their audience, and behave as the very visible performers that they are.

A parallel disconnect seems to be with the roles that singers have in these concerts, or more specifically, their text. Take opera, for example. We've been in orchestra rehearsals where the conductor is caught between a rock and a hard place. The conductor is often the only liaison between the orchestra players in the pit and what's happening onstage. Sometimes the best way to make sense of oddities in the players' scores is to explain *why* it's tragic, or even more importantly, funny. Yet when time is of the essence, there's a palpable roll of the eyes when these explanations begin, either from the players themselves, or the stressed out music staff trying to help the conductor by keeping an eye on the clock. 

To be fair, great orchestral players do their homework. They look at the full score, they read the libretto or any textual source that goes with what they're playing. But within the perfect storm of limited rehearsal time and expensive man power, it often results in a forced apathy on the part of the orchestra, towards what's going on onstage. It may seem as though we're putting double duty onto these players, to be responsible not only for the notes they play, but knowing why they're playing it; but the result of this kind of apathy is measurable.

Norman Lebrecht's recent article, ["London's Music has Gone Flat"](http://standpointmag.co.uk/music-april-2016-norman-lebrecht-london-orchestras-gone-flat), bemoans the dying imagination of major orchestras, and their decreasing presence in major concert halls. This is one result of orchestral players who don't, or aren't given the chance to, care about their roles as *entertainers* among the larger world of professional musicians.

A decent analogy lies in the behaviour of bloated, beastly companies like Comcast or Bell or Verizon. There's a purposeful disconnect between customers and their needs and wants, and the people who can do something to make those things happen. The employees who make up the infinite checkpoints between the dissatisfied public and the bosses with power each have their own tiny bubble of responsibility; when it comes to solving problems with customers, this system makes it impossible for the public to find out a) where the blame lies, and b) with whom they can have a human conversation to fix said problems.

In the age of a more even playing field, where individuals and corporations alike can open up Twitter accounts and speak in the same large arena, it's no wonder that the public is as quick to drop the impersonal as they are to try out the new.

The same principles apply to orchestras; when the public doesn't feel acknowledged, or critics pooh-pooh the orchestra's attempts to bridge the gap between dying audiences and potential ones (things like movie nights with live music, pops concerts, genre-blending programming), it should be no surprise that demand dips. Funding dips in proportion to the demand, and so on, and so on.

There are orchestras who listen to their audience, of course. The [City of London Sinfonia](https://cityoflondonsinfonia.co.uk/)'s concert season is in technicolour, crossing disciplines and musical genres at every turn. Gustavo Dudamel is now infamous for having fun onstage, and translating for the audience the excitement that orchestral musicians really do feel for their art. Toronto's [Toy Piano Composers](http://toypianocomposers.com/Toy_Piano_Composers/about.html) injects youth and nothing-to-lose ideas into their season, feeding the wants not only their listeners, but of the composers who are able to propel these ideas forward through new pieces of music.

It's yet another check in the pros column for the small and malleable. It takes more time than major orchestras ever have to decide on an aesthetic that responds to its listeners, and to disseminate that aesthetic throughout its 60, 80, 120 members or more. In the same way that it's hard to find out who keeps screwing up your cell phone billing information, it's hard to point the finger at a person or department heading large orchestras, and decry them as the source of classical music's problem of audience disconnection. Solutions can be found within a combination of checking egos, and by avoiding the conclusion of "tragedy" when orchestras face demands for change. 

Business and programming aside, it would be nice to begin with seeing an orchestra full of players who don't assume they're an invisible face in a crowd. The show goes on during their bars of rest, and it goes on between numbers. The necessities of large-scale concerts like these are a reality; bodies need to be shuffled, chairs need to be added, and tuning needs to happen. But, why ignore the listeners during any of this? There's a difference between a relaxed environment, and one that ignores the fact that they're performers. Onstage housekeeping is the perfect opportunity for musicians to communicate with their listeners, and prove that they're human beings as well as talented artists. *Talk* to them, guys! 

It's not unheard of by any stretch of the imagination, but it's still rare enough that it should be no surprise that orchestras maintain a reputation for stuffiness, and constantly face the need to tighten belts.

>Readers, what are your impressions of a traditional night out at the symphony? Does personality count? Let us know in the comments below!
