+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2014-11-04T06:06:00-07:00"
lastmod = "2016-06-17T00:13:00-06:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1466144002842/2016-06-18---Posse.jpg.jpg"
primary_image_credit = "Photo: Fox Photos/Getty Images"
publishDate = "2014-11-04T06:06:00-07:00"
related_articles = ["articles/the-opera-party-monologue.md","articles/musicians-sexual-harassment-blurred-lines.md","articles/money-manners-observations.md","articles/voice-type-social-life.md"]
short_description = "Opera singers are masters of multi-tasking: they juggle an important list of technical elements in order to sing a performance, and they have to do it in foreign languages, while following a conductor and negotiating weird costumes/lighting/staging. Singers&#039; to-do lists don&#039;t get simpler as they gain experience. "
slug = "the-opera-posse-phenomenon"
title = "The Opera Posse Phenomenon"
+++

Opera singers are masters of multi-tasking: they juggle an important list of technical elements in order to sing a performance, and they have to do it in foreign languages, while following a conductor and negotiating weird costumes/lighting/staging. Singers' to-do lists don't get simpler as they gain experience. Once there's a decent consensus amongst the opera industry that a singer is established, there's a weird phenomenon that occurs. The singer begins to pick up followers, hangers-on of a parasitic sort. These new companions are usually people who aren’t opera singers, but are really into opera for one reason or another. Voice teachers, coaches, audition consultants, agents, and even donors like to latch onto a successful singer (even better if they’re a young up-and-comer). They’re like really swanky groupies. So why do they cling to opera singers? Simply put: they want to vicariously live the perceived glam life.

In the case of donors (those sponsoring singers’ fees, in particular), I have realized that most of them do it because they really do love opera and the fascinating singers in the industry. But I would be remiss if I didn’t mention the guaranteed social scene that comes with it. Think about it: if you can afford to sponsor a singer like Gerald Finley or Ben Heppner, you inevitably buy face time with someone famous. And if you buy enough face time, you eventually get to know the famous opera singer better than most. This kind of stuff comes in handy when you go to other opera parties and someone brings up Finley or Heppner and you can say things like, “Oh yeah, he loves his eggs over-medium” or “Our dog simply adores him”. There’s something about it that rubs me the wrong way, because these donors simply aren’t usually there for the true part of an opera singer’s work. They’re not there with them in the practice room, or the first sing-through of a piece, or schlepping through an audition tour across Europe. They’re not there for the moments of non-glamour that grossly outweigh the onstage moments of high notes and taking bows. So when even well-meaning donors tag along for the icing portion of the opera singer’s job, the term "fair-weather friend" comes to mind.

A more puzzling culprit is the new presence of audition consultants in the young-artist circuits. The premise is great; someone who is well-connected and in touch with the current opera industry offers educated advice to young singers beginning their careers. I’ve [written before](/in-defence-of-singers/) about the mysterious psychology of audition etiquette. When a singer does well on an audition tour, winning decent roles at respectable houses, the audition consultant can often insinuate that his advice was what did the trick. As harmless as this reaction may be (as a coach, I understand the personal elation of being able to help a student succeed), it suggests that winning auditions is really about having added that last aria, or having one's hair a proper length. It ignores the defining factor of auditions in general: great singing. Like the donors, the audition guru simply isn't there for all the work.

Perhaps the most ubiquitous examples of self-elected singer sidekicks come from within the industry, and these are people who should know better. Voice teachers and coaches are intimately involved in a singer's progress, and they really do get to know the singers well. From my position the industry, I've seen it at more than one major institution: teachers and coaches who claim propriety of their star singers. It shows up in weird ways, mostly jealously when those teachers and coaches find out their star singer has worked with...wait for it..._someone else_. It usually is a testament to the singer's hard work and accomplishment that they have a mentor with attachment issues; and even if those teachers and coaches were large parts of the process, it's silly for them to assume there's nothing for a student to learn from another set of ears.

It may be naïve to imagine the industry without this phenomenon. It's one of the perks of being a pianist within in the opera world; you get to see the work a singer does, and you get to sit in on much of their instruction. Pianists and coaches often have the most context for a singer's process, and it's off-putting to hear them receive isolated pieces of advice from those who check in only occasionally. When you spend plenty of time around opera singers, you oddly start to imagine that you too are capable of doing what they do (you can't); I think that's the position from which a lot of singers' advice comes. So, if these singer sidekicks really just want to take a bow, they had better practice their scales.
