+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2016-05-08T13:31:00-06:00"
lastmod = "2017-06-23T23:19:00-06:00"
preamble = "Pianists, when you're playing an opera score, you're more than a master of your instrument; you are problem-solving machines. You solve problems with un-ergonomic orchestral reductions, with meeting someone else's tempo, and with turning 200-300 of your own pages. \n\nSimply put, playing opera scores is about keeping your priorities in check. We've zeroed in on three Big Priorities that seem to encompass the job of the opera pianist, and some solutions for getting through them without headaches (or ego)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498281544810/2017-06-23---Priorities.jpg.jpg"
publishDate = "2016-05-09T02:03:00-06:00"
related_articles = ["articles/star-repetiteur-there-is-such-a-thing.md","articles/pianists-3-tips-for-sounding-like-an-orchestra.md","articles/tips-for-pianists-how-to-tremolo-like-a-pro.md"]
short_description = "Firstly, they can get hung up in all the notes, and start to drag the tempo as a result; the bigger trap actually precedes this first one, and that&#039;s spending too much time on all the notes. We&#039;re not suggesting you trade in fluttering scales for mashing the keys like a gorilla, but it&#039;s about picking your battles."
slug = "the-opera-pianists-list-o-priorities"
title = "The opera pianist&#039;s list o&#039; priorities"
+++

## That tempo, though

Pianists, do your eyes twitch when you look at the score below?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462736083558/2016-05-09---Piano-tips---Mab.jpg.jpg)
</figure>

Yeah, ours too. Mercutio's aria from Gounod's *Roméo et Juliette* is one of those wicked fast numbers, and there are two big traps into which a pianist can fall. Firstly, they can get hung up in all the notes, and start to drag the tempo as a result; the bigger trap actually precedes this first one, and that's *spending too much time on all the notes*. We're not suggesting you trade in fluttering scales for mashing the keys like a gorilla, but it's about picking your battles. Basically, you need to be comfy at the singer's tempo, and it's wise to prioritize strong beats. The first notes of each group of six sixteenth notes can be checkpoints for the pianist; they coincide nicely with the left hand chords, and they keep you grounded rather than *stressed out*. And honestly, if vague (and light!) mashing happens in the filler sixteenths between each checkpoint, that's ok. Odds are, Mercutio will be too pleased with you for keeping a steady tempo to notice that you didn't catch that first A-sharp.

Another example is from act III of Bizet's *Carmen*:

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462737044817/2016-05-09---Piano-tips---Carmen-2.jpg.jpg)
</figure>

Like everything that Carmen and her gypsy girls do, this bit of music is a dance; not just a dance, but one that keeps getting faster. It's tons of fun in the context of the show, and it offers up a fair challenge to a pianist playing the score. This first excerpt isn't at the *fastissimo* section yet, but it's still not a great idea to try and play those rising triads in the right hand. They're picky, energy- and time-consuming, and they're not worth the risk of upsetting what needs to stay a steady tempo. Instead, you can get away with just playing the top notes of each triad; that way, your hand has to do less, and you can keep an eye on the maestro, who's about to pick up the pace for the next verse.

For some final proof, here's a section of the end of this same number, where we're at top speed:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462736993447/2016-05-09---Piano-tips---Carmen-tringles.jpg.jpg)
</figure>

You know what makes this page of music sound great? Two flutes. Not one tendonitis-ridden right hand. 

You can get the resonance of the thirds by playing just a few of them, like on strong beats. Depending on the tempo, you can likely manage the eighth note thirds; as soon as they start to mess with your metronome-like beats, it's completely legal (necessary, really) to simplify and stick to playing the top line only.

## Where's the tune?

Even if you physically can play all the notes, often it's wise to pare down an orchestral reduction and leave a few lines out. A piano can make a lot of different sounds, but an orchestra can make more; that means that when the violas are playing something, and an oboe is playing something different at the same time, both lines are independently audible because the timbre of the instruments is quite different.

On the piano, playing the viola line and the oboe line won't have the timbral difference that's built into the orchestra; even if both lines are clearly played at the piano, they can make the score more obscured, like two melodies that don't quite stand on their own. There's a great example of what we mean in the Armed Guards scene from Mozart's *Die Zauberflöte*:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462738659455/2016-05-09---Piano-tips---Armed-Guards.jpg.jpg)
</figure>

There's a fugue-like section that begins at the last bar of the first line. It's not always possible to play every voice all the time, and that's ok. What's more important is playing a line from start to finish, without interruption. So, as you get into the middle of the second line, it can be hard to keep three concurrent melodies clearly audible. It's not out of the realm of possibility for a pianist to play a three-voice fugue; thanks to Mr. Bach, we're trained in the art. But like any orchestra reduction, it's about recreating what will be heard, not about note accuracy. That's a long way of saying that for clarity, pianists should nix the middle voice and keep the bass and soprano voices clear.

Richard Strauss' operas are full of this need for problem-solving. Have a look at this section from the beginning of *Der Rosenkavalier*:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462741725059/2016-05-09---Piano-tips---Wie-du-warst.jpg.jpg)
</figure>

Strauss writes tons of counterpoint in his scores; instruments are criss-crossing, duetting with other instruments, each singing out their own soloistic lines. When all of that is condensed into a piano score, it can be hard to pick out where one note is heading next. Above, we've highlighted a few of these obscured melodies in red. These melodies are what singers will be listening for; it's so important to find these tunes, play them like they're a solo instrument, and *finish them*.

You can see in the first red tune, the final note of the melody is that C-natural, tucked into the left hand in the second bar. It doesn't *look* like it belongs with the B-natural at the end of the previous measure, but it does. It's a tune that keeps repeating, and pianists should make this very obvious. In the second system, the red tune highlighted in the right hand can get easily jumbled with the off-beat chords just underneath it, and it's the pianist's job to separate these elements aurally.

More from the same opera:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462742029971/2016-05-09---Piano-tips---Wie-du-warst-2.jpg.jpg)
</figure>

That dotted tripled figure kind of an ur-tune of *Der Rosenkavalier*, so spotting it can be an easy litmus test for a pianist who's trying to prioritize their Strauss counterpoint. This excerpt isn't impossible to play, but again, the priority is about clear and complete tunes; so if the extra stuff happening in the right hand at rehearsal 21 obscures the tune in red, get rid of it. No harm done.

## "Nice" is different than "good"

The final step to a pianist's list of priorities is finding an ultimately pleasant way of playing the score. Sometimes that means note-for-note accuracy, and sometimes that means smearing fakery; usually it's somewhere in between. Here's a great example, from the overture to *Don Giovanni*:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462742195849/2016-05-09---Piano-tips---DG-overture.jpg.jpg)
</figure>

The bit starting at the last measure of the first line is super fun! So exciting to play, it makes a pianist dance on the bench. But those sixths in the middle of the second line? Come on, now. Sure, it's what the strings do, but that's because they're splitting the work between violins I and II. Like it always is, tempo is key with this music, and heroically aiming to play all those sixths will absolutely slow you down. It will be effortful in a way that won't capture the spirit of the music, and it'll sound clunky (not to mention a little bit egotistic). Like the *Carmen* example above, you can find a few sixths to include so that there's more colour, but we suggest limiting those to strong beats. It'll just sound better, and everyone will be reminded of how great this freaking score is.

One last example, this time in a more epic scale:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462742579606/2016-05-09---Piano-tips---Ride-of-the-Valkyries.jpg.jpg)
</figure>

That's right, it's the "Ride of the Valkyries" from *Die Walküre*. So great. It's easy to spot the important bits, and they're all in the left hand. Pianists, you want plenty of sound here, since you're recreating that bloated brass section who get to wail away at the top of act III. But you don't need to play it *all* in octaves. It's too much work, and you'll play wrong notes. This bit is too famous for wrong notes. An easy solution is to take the notes that aren't accented, and condense them into a single note; this will help make it more comfortable to play, and you won't have to work as hard for the accents, since they'll stand out a bit more by default by being heard in octaves.

The big thing is the right hand, though. These string figures are about texture, not notes; all the times in history that people hummed the "Ride of the Valkyries", not one person hummed that right hand. So, spot the chord that Wagner is using for each figure of five sixteenth notes, and let your right hand tinkle away lightly, and obediently following your left. It's arguably *more* accurate to "fake" the right hand, since the resulting sound on the piano will be balanced; the left hand melody will be clear and rhythmic, and the shimmering strings in the right hand will be an effect rather than cyrstal clear, Mozart-like arpeggios. 

>Readers, leave your tips in the comments below!
