+++
author = ["authors/john-beckett.md"]
categories = "Review"
date = "2017-11-21T12:07:00-05:00"
lastmod = "2017-11-21T13:16:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511284013827/2017-11-21---square---BC20171116_SEMIRAMIDE_0510-JOYCE-DIDONATO-AS-SEMIRAMIDE-C-ROH.-PHOTO-BILL-COOPER.jpg.jpg"
primary_image_credit = "Joyce DiDonato in the title role of Semiramide, ROH, 2017. Photo: Bill Cooper."
publishDate = "2017-11-21T12:07:00-05:00"
related_articles = ["articles/watch-learn-maestros-at-work.md","articles/playing-bel-canto-4-tips-for-pianists.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/joyce-didonato.md","scene/people/lawrence-brownlee.md","scene/people/daniela-barcellona.md","scene/people/michele-pertusi.md","scene/people/mirco-palazzi.md","scene/people/jacquelyn-stucker.md"]
short_description = "Remarkably, despite all the difficulties of this work, the cast took it all in stride, making it seem effortless as they thrilled with truly pristine singing. The singers also had the difficult job of filling a massive stage, sparse with sets or props. This was achieved by real presence and unteachable charisma, which the ensemble possessed in spades."
slug = "the-olympics-of-singing-semiramide-at-roh"
title = "The Olympics of Singing: Semiramide at ROH"
+++

The Olympics of Singing returned to the Royal Opera yesterday afternoon, as Rossini's *Semiramide* was staged in Covent Garden for the first time since the 19th century. Vocal fireworks flew through the house, showing the audience what true *bel canto* singing is all about. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511283679757/2017-11-21---BC20171116_SEMIRAMIDE_0734-SEMIRAMIDE-PRODUCTION-IMAGE-C-ROH.-PHOTO-BILL-COOPER.jpg.jpg)
<figcaption>A scene from *Semiramide*, ROH, 2017. Photo: Bill Cooper.</figcaption>
</figure>

It was a bit of a shock to come to this production by David Alden - not because of the white-washed cast in stereotypical Middle-Eastern garb - but because of the lack of movement happening on stage. I was hoping that opera was going in the direction of realness and convincing drama, but of the four hour long opera, most of the singers were just standing and singing: "park and bark," as they say. The music, no matter how interesting or how well sung, unfortunately just tends to go on, and it is arguably too much of the same material for a contemporary audience. More cuts would have been welcome, as would have more stage action. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511283687840/2017-11-21---BC20171116_SEMIRAMIDE_0293-JOYCE-DIDONATO-AS-SEMIRAMIDE%2C-ACTOR-JOHN-O'TOOLE-AS-GHOST-OF-NINO-C-ROH.-PHOTO-BILL-COOPER.jpg.jpg)
<figcaption>Joyce DiDonato (Semiramide) and John O'Toole as the Ghost of Nino in *Semiramide*, ROH, 2017. Photo: Bill Cooper.</figcaption>
</figure>

[Joyce DiDonato](/scene/people/joyce-didonato/) led the performance as the title role, and was as stunning as ever. DiDonato continues to prove that her voice is made for this repertory, with chromatic scales and ornaments that made this opera-goer gasp. It is something of a miracle that she is able to make this treacherous queen likeable, I was rooting for her even after it was revealed how murderous of a traitor she is. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511283735620/2017-11-21---BC20171116_SEMIRAMIDE_0901-JOYCE-DIDONATO-AS-SEMIRAMIDE%2C-MICHELE-PERTUSI-AS-ASSUR-C-ROH.-PHOTO-BILL-COOPER.jpg.jpg)
<figcaption>Joyce DiDonato (Semiramide) and Michele Pertusi (Assur) in *Semiramide*, ROH, 2017. Photo: Bill Cooper.</figcaption>
</figure>

[Mirco Palazzi](/scene/people/mirco-palazzi/), although playing a villain, became the hero of the evening, stepping in very last minute as Michele Pertusi had to withdraw during the interval due to illness. Palazzi's voice was strong and confident, matching that of [Daniela Barcellona](/scene/people/daniela-barcellona/), whose stamina was inspiring to watch. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511283745670/2017-11-21---BC20171116_SEMIRAMIDE_0348-JOYCE-DIDONATO-AS-SEMIRAMIDE%2C-LAWRENCE-BROWNLEE-C-ROH.-PHOTO-BILL-COOPER.jpg.jpg)
<figcaption>Joyce DiDonato (Semiramide) and Lawrence Brownlee (Idreno) in *Semiramide*, ROH, 2017. Photo: Bill Cooper.</figcaption>
</figure>

It was [Lawrence Brownlee](/scene/people/lawrence-brownlee/) who left me wanting more, whose bright tenor sound tackled feats of impossible proportion as the role of Idreno. Brownlee is truly a unique artist, displaying an element of showmanship that Rossini operas desperately need. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511283796928/2017-11-21---BC20171116_SEMIRAMIDE_0300-MICHELE-PERTUSI-AS-ASSUR%2C-JOYCE-DIDONATO-AS-SEMIRAMIDE%2C-DANIELA-BARCELONA-AS-ARSACE-C-ROH.-PHOTO-BILL-COOPER.jpg.jpg)
<figcaption>(l-r) Michele Pertusi (Assur), Joyce DiDonato (Semiramide), and Daniela Barcellona (Arsace) in *Semiramide*, ROH, 2017. Photo: Bill Cooper.</figcaption>
</figure>

Remarkably, despite all the difficulties of this work, the cast took it all in stride, making it seem effortless as they thrilled with truly pristine singing. The singers also had the difficult job of filling a massive stage, sparse with sets or props. This was achieved by real presence and unteachable charisma, which the ensemble possessed in spades. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511283810451/2017-11-21---CBC20171116_SEMIRAMIDE_0967-JACQUELYN-STUCKER-AS-AZEMA-C-ROH.-PHOTO-BILL-COOPER.jpg.jpg)
<figcaption>Jacquelyn Stucker as Azema in *Semiramide*, ROH, 2017. Photo: Bill Cooper.</figcaption>
</figure>

Intense musicianship was drawn from the orchestra by the maestro Antonio Pappano. Rossini does not always give the performers explicit instruction in his scoring, but Pappano is so sensitive to Italian text that he colours the relentless vamping with exquisite storytelling. A special mention should be given to the horn section, whose crystal clear sound seemed to float into the balcony. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511283820492/2017-11-21---CBC20171116_SEMIRAMIDE_1490-SEMIRAMIDE-PRODUCTION-IMAGE-C-ROH.-PHOTO-BILL-COOPER.jpg.jpg)
<figcaption>A scene from *Semiramide*, ROH, 2017. Photo: Bill Cooper.</figcaption>
</figure>

How often does one get to listen to an opera of this magnitude? If you're lucky enough to be a Londoner, get to Covent Garden and see *Semiramide* - it might be another hundred years before you can see it again.

>[Semiramide](http://www.roh.org.uk/productions/semiramide-by-david-alden) is onstage at Covent Garden through December 16. For details and ticket information, follow our box office links below.
