+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2014-10-07T09:00:00-04:00"
lastmod = "2015-04-15T17:10:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429132237310/Screen%20Shot%202015-04-15%20at%205.10.07%20PM.png"
publishDate = "2014-10-07T09:00:00-04:00"
short_description = "The other day I was presented with one of those artistic conundrums that&#039;s so simple it rarely occurs to me: the question of using microphones in live opera. If you&#039;re an opera lover, your nose probably just scrunched up a little bit at the thought of Violetta sporting a headset mic."
slug = "the-microphone-question"
title = "The Microphone Question"
+++

The other day I was presented with one of those artistic conundrums that's so simple it rarely occurs to me: the question of using microphones in live opera. If you're an opera lover, your nose probably just scrunched up a little bit at the thought of Violetta sporting a headset mic. I'll make it known right away that I'm not for using microphones in a performance, and I think suggesting it is reflective of having missed the point of opera. And now I'll tell you how this all came about.

I had just finished a promotional gig in a public venue, which had indeed used a sound system, both for the singers and for me at the piano. One of the listeners came up afterwards and mentioned that he was a frequent COC-goer. He had loved the use of microphones in our performance because it had made everything so easy to hear (he's right; it would have been tricky to hear acoustic singing over the noise of downtown Toronto at lunchtime). He made his case for the COC and other opera houses to start using microphones, saying that it not only would "even out" the balance between the singers and orchestra, but a mic-friendly opera industry might encourage more aspiring singers to try it out as a career (I know).

Defensive questions kept popping into my head: "Don't you find it thrilling enough that all that sound_ can_ happen acoustically?" "Why would you want it to be 'even'?" "Do you mean you wish live performance sounded like a studio recording?" But the mic-friendly listener was making fair points, from the point of view of someone who obviously enjoys opera and wants to hear it more clearly. And his points are the product of a couple of unfair misconceptions about opera, the first being that opera is simply a "way of singing", and going to see an opera is about hearing beautiful sounds (I'll cede that the voice is opera's primary tool, but that tool isn't for its own sake; the voice is used to _tell a story_). To neutralize the balance between singers and orchestra would certainly be handy (and if it were as easy as pressing a button, I'd certainly become a bit more disposable), but operas are written for this balance to fluctuate. This fluctuation is done _on purpose _by the composer to help tell the story (think of the dramatic difference between a recit and an aria, for example). Frankly, there are some places in opera where the collective sound of voice and orchestra say even more than the singer's text. I consulted a reliable opera newbie to see if he had ever wished for better sound balance: "I'm not listening to the singers to hear what they're saying; I'm listening to the sounds they're making in correlation to what the orchestra is playing."

So there's that. The second major point is regarding the idea that microphones could "allow" more singers to pursue opera. I fear that my argument will most likely appear as snobbery masked in technicalities, but stick with me. Simply put, if microphones had been around when opera began, its style of singing would have evolved entirely differently. The easy proof? Operetta and musical theatre. One led into the other, at the same time that the microphone was becoming a staple of live performance. The music for _The Pirates of Penzance_, _Crazy for You _and _The Last Five Years _have pretty varied singing styles, and it's not just because it's these examples come from three different centuries. It's because without microphones, the voice has to sit higher, be well-supported and stretch the boundaries of vocal resonance. With a mic, you can do a whole new list of things to tell stories (whisper, croon, speak "naturally", etc.), and so you can write music that more closely resembles speech (i.e. lower, shorter phrases) without balance issues. The big, resonant, almost exaggerated voice that singers use to sing opera isn't like icing on top of a musical cake. That sound is a product of using the voice efficiently in order to have the stamina to make it through the show. Loudness is not what singers strive for, and that's why giving a microphone to any eager yet unready singer won't help them sing in an opera.

I imagine that trying out microphones onstage at the Four Seasons Centre might freak some people out; there may be riots and tears and there would definitely be angry opera fans shrieking about artistic blasphemy. It would be an operatic equivalent to [this experiment gone wrong](https://www.youtube.com/watch?v=grOttsHuuzE). And maybe all the TV talent shows and BBC broadcasts and the Three Tenors give the public the wrong idea about how easy it is to "do opera" with a microphone. "But that's different!", you shout. And it is; we're talking about concerts in humongous venues in a non-acoustic context, versus live performances in an opera house. I personally am always a little disappointed when I'm hearing any singer through a microphone. It obscures the real sound of their voice; I want to really hear it, not to expose it to criticism, but because the various human voice timbres are something I love about opera.

Frankly, the purely acoustic experience of the opera is one of the few cards we have left to play where we're not in competition with other forms of entertainment. You can hear "loud" all over the place. But "loud" doesn't hold a candle to "human". We get excited over acoustic covers of our favourite songs, and a show at a hole-in-the-wall bar tends to hold an energy about it that just can't be matched at a massive stadium concert. So it makes sense that an unfiltered, imperfect, superhuman (yet simply human!) performance packs a punch. Of course, we choose our battles; if singers perform in a space that's not pulling its acoustic weight, I doubt it's worth the battle to stay microphone-free. And when the acoustic stars align, we get to be ambassadors of sorts, reminding the public that there are still real, live people creating music. I think it's something in our nurture, our response to the human voice, and opera offers it up, unfiltered, at the peak of its potential. Let's not throw the technology out with the bathwater, but let's absolutely not let lose that most special tenet of opera, the voice.
