+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = 2022-07-11T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1657549194/media/2022/07/SqMETorchestra_CH11216986_quqrmx.jpg"
primary_image_credit = "Maestro Yannick Nézet-Séguin and the MET Orchestra playing to a full house at Carnegie Hall. Photo: Chris Lee."
related_articles = []
related_companies = []
related_people = ["scene/people/missy-mazzoli.md", "scene/people/yannick-nezet-seguin.md", "scene/people/brandon-jovanovich.md", "scene/people/ryan-speedo-green.md", "scene/people/nadine-sierra.md", "scene/people/christine-goerke.md"]
short_description = "The blazing orchestra doesn't so much compensate for the lack of the sword and tree but more accurately supplants the need for such paraphernalia."
slug = "the-met-orchestra-reigns-and-goerke-sings-sieglinde"
title = "The MET Orchestra reigns and Goerke sings Sieglinde"
youtube_url = ""

+++
As the erotic energy of Strauss' _Don Juan_ gave way to its fateful conclusion, an audible gasp was heard in the audience. It diffused what was otherwise a profound and breathtaking moment of silence. The mighty MET Orchestra, reigning on stage for the second of its three concerts at Carnegie Hall, performed this complexly orchestrated tone poem with consummate power and precision that is arguably unmatched in the higher echelons of opera orchestras or symphony orchestras for that matter.

The evening was headlined by Wagner's _Die Walküre_, Act I with soprano [Christine Goerke](/talking-with-singers-christine-goerke/), the MET's current Brünnhilde, singing Sieglinde for the first time. But is was the Strauss and [Yannick Nézet-Séguin](/scene/people/yannick-nezet-seguin/)'s conducting, thoughtful and gyroscopically nimble, that immediately captivated the full house.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1657550872/media/2022/07/METorchestra_DonJuan-25798_haqcxj.jpg){{% /md %}}

<figcaption>The opening of the complexly orchestrated violin I score for the Richard Strauss tone poem Don Juan. Image courtesy of violinist.com.</figcaption>  
</figure>

_Don Juan_ challenges a conductor to search beyond the spectacle of its requisite revelry and corrupted romance. Nézet-Séguin, while sacrificing none of the fireworks, infused it with beautifully rendered substance and emotion, most evident during the final moments but surfacing throughout. Recognizing individual musicians or even sections of this group is like asking parents which of their children they favor most but the superb solo work by concertmaster David Chen, principal oboist Nathan Hughes and the triumphant horns cannot go without mention.

Prone to understatement and with congenial informality Nézet-Séguin described [Missy Mazzoli](/scene/people/missy-mazzoli/)'s _Sinfonia (for Orbiting Spheres)_ as a considerably calmer piece than its concert predecessor. It shimmered with undulating repetitions leading this writer to contemplate beautifully enigmatic spheres of unknowable breadth, spheres that interacted in ways that defy definition. It appeared that all spheres may not be created equal. Even in a kaleidoscopic world there was, as in _Don Juan_, a sense of foreboding as if some sort of reckoning might await.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1657550923/media/2022/07/METorchestra_MissyMazzoli_MaryleneMay_waay2r.jpg){{% /md %}}

<figcaption>Composer Missy Mazzoli, whose Sinfonia (for Orbiting Spheres) followed Strauss' Don Juan with the MET Orchestra at Carnegie Hall. Photo: Marylene May.</figcaption></figure>

Mazzoli's relationship with the MET extends beyond the concert stage to an opera commission in progress based on George Saunders's novel _Lincoln In The Bardo_. Nézet-Séguin reminded us that in the 2021-22 season the MET produced three new operas, _Eurydice_, _Fire Shut Up In My Bones_ and _Hamlet_, with more to come.

Before Nézet-Séguin began _Die Walküre_, Act I he commented that Wagner would disapprove of a concert performance. Adding he didn’t care the maestro posited that a _Ring Cycle_ in concert might be an interesting idea. How true, especially if it served as a segue from the Robert Lepage cycle with that lamentable 45-ton machine.

Wagner's wishes notwithstanding, Act I is a natural for the concert stage. No need for scenery since Wagner does the scene painting, and what a job the MET Orchestra does in manipulating the paint. The stage action is confined to Siegmund and Sieglinde meeting, realizing their incestuous love and running away together after Sieglinde drugs Hunding, her hostile and suspicious husband. Of course there's the moment when Siegmund pulls the mystical sword from an ash tree. But the blazing orchestra doesn't so much compensate for the lack of the sword and tree but more accurately supplants the need for such paraphernalia.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1657550998/media/2022/07/METorchestra_GoerkeJovanovichNezetSeguinOwens_CH11216994_pjiut6.jpg){{% /md %}}

<figcaption>Soprano Christine Goerke, tenor Brandon Jovanovich, conductor Yannick Nézet-Séguin and bass-baritone Eric Owens in Die Walküre, Act I on stage with the MET Orchestra at Carnegie Hall. Photo: Chris Lee.</figcaption></figure>

The singers established character with finesse. Montana-born tenor [Brandon Jovanovich](/scene/people/brandon-jovanovich/) projected a forlorn and exhausted Siegmund as he wandered on stage during the opening orchestral thunderstorm. Goerke entered, momentarily unnoticed with a sadly defeated air and endearing timidity. And bass-baritone [Eric Owens](/scene/people/eric-owens/), the MET's man for all seasons, was unflinchingly ominous, his presence hovering like a threatening cloud.

Goerke began tentatively as Sieglinde should, but soon impressed with soaring top notes, especially during her set piece "Du bist der Lenz" and with a resonant chest voice that demonstrated endless reserves. Jovanovich was another matter. Initially producing a handsome and virile sound he moved confidently, indeed heroically, in his upper range but collapsed when going for lower notes, often swallowing or dropping them altogether. Owens, to no ones surprise, was as mellifluous as he was sinister, quite an extraordinary feat. Like Goerke, he appears to know no bounds.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1657551023/media/2022/07/METorchestra_GoerkeJovanovich_CH11216996_dmxuyw.jpg){{% /md %}}

<figcaption>Soprano Christine Goerke and tenor Brandon Jovanovich as Sieglinde and Siegmund in Die Walküre, Act I. Photo: Chris Lee.</figcaption></figure>

The MET Orchestra will play [three concerts at Carnegie Hall](https://www.carnegiehall.org/Subscribe/Subscriptions/2022-2023/The-MET-Orchestra) during the 2022-23 season, featuring Nézet-Séguin and such artists as [Ryan Speedo Green](/scene/people/ryan-speedo-green/), [Nadine Sierra](/scene/people/nadine-sierra/), and [Rénee Fleming](/scene/people/renee-fleming/). Works will include Stravinsky's _Firebird Suite_, the Brahms _Requiem_ and Verdi's _Otello_, Act IV and others, yet other opportunity for this orchestra to reign supreme.