+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = "2018-06-30T12:31:00-04:00"
lastmod = "2018-07-02T20:23:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1530376184706/sqVAIMediumimage1.jpg.jpg"
primary_image_credit = "Marie Powers as Madame Flora in The Medium. Photo: Courtesy of Video Artists International, Inc./vaimusic.com."
publishDate = "2018-06-30T12:31:00-04:00"
related_articles = ["articles/persona-and-the-sounds-of-silence.md","articles/erik-ochsner-on-conducting-star-trek-goose-bumps-and-tears-are-not-optional.md"]
short_description = "The film deserves broader exposure. Seven decades after Menotti composed the score and wrote the libretto, both still sound ever so inventive and contemporary. As a film director Menotti nurtured a naturalistic atmosphere in which it appears inevitable that his characters sing and in the process he has created a finely honed example of operatic film noir. "
slug = "the-medium-opera-as-film-noir"
title = "The Medium: opera as film noir"
+++

Madame Flora, or Baba as her daughter refers to her with fearful affection, is a blousy, boozy, and conniving crook at heart. When we meet her at the beginning of Gian Carlo Menotti's 1951 film adaptation of his opera, *The Medium*, she is sitting on the stairs outside an apartment door.  A hand emerges offering a few forints (we are in Budapest) that she reluctantly accepts; yet she continues to wait. The door opens wider, revealing a woman holding a small child. When offered a locket, she gives it a cursory inspection, takes it, and heads straight to a pawnshop. There, when offered a meager sum, she casts a wearily suspicious glance at the proprietor, and coaxes him into a better deal.

We have yet to learn that with the assistance of her daughter, Monica and a mute Romani servant boy named Toby, Madame Flora is in the business of conducting fraudulent séances. But we do know that she is an effective bill collector who displays an outward bravura while steadily decaying internally. We also learn that Marie Powers, the Pennsylvania-born contralto inhabiting this character, who built a career with Wagnerian roles in Italy, was a singing actress of the highest order.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1530376070870/VAIMediumCOVERIMAGE.jpg.jpg)
<figcaption>Reproduction of a 1951 film poster for the DVD release of *The Medium*. Photo: Courtesy of Video Artists International, Inc. / vaimusic.com.</figcaption>
</figure>

These realizations availed themselves last week to a group of fortunate New Yorkers as a result of a members-only screening at Anthology Film Archives, a film society housed in a former courthouse in New York's East Village. AFA borrowed the rarely seen print that resides with the British Film Archives for the occasion. Though available on DVD from Video Artists International (VAI) its theatrical presentation provides a most welcomed point of reference for this modern opera. *The Medium* has gained public acceptance of such proportion that is was even a Broadway hit as half of a double bill with Menotti's *The Telephone*, in 1947. 

The film deserves broader exposure. Seven decades after Menotti composed the score and wrote the libretto, both still sound ever so inventive and contemporary. As a film director Menotti nurtured a naturalistic atmosphere in which it appears inevitable that his characters sing and in the process he has created a finely honed example of operatic film noir. 

Think of the sustained claustrophobia and creeping delusion in Billy Wilder's *Sunset Boulevard*, and the relentless tension that reeks from almost every frame of Ida Lupino's *The Hitch-Hiker*. Menotti packs a wallop with this 84-minute film. He has skillfully opened it up beyond Madame Flora's shabbily florid apartment by inserting outdoor locales and adding an additional chorus. Instrumental extensions composed for the film contribute to an evocative film noir score. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1530376062995/VAIMediumimage3.jpg.jpg)
<figcaption>Anna Maria Alberghetti as Monica and Marie Powers as Madame Flora in *The Medium*. Photo: Courtesy of Video Artists International, Inc. / vaimusic.com.</figcaption>
</figure>

During the séance with two repeat and one new client, Flora feels a cold touch on her throat. Convinced that an actual ghost has touched her, she abruptly ends the session and falls into a guilt-ridden stupor leading to madness. 

Thomas Schippers, who was a frequent conductor of Menotti's work, *The Council* and *Amahl and the Night Visitors* among them, here leads the Symphony Orchestra of Rome Radio Italiana in a passionate reading that captures the essence of Madame Flora and her retinue. In a sense the film soundtrack supplants Schippers' audio recording because the otherwise jarring sounds of the séance, likely far noisier then a legitimate one, are visually justified.

The print has its flaws; scratches take some getting used to and a couple of abrupt jumps momentarily break the spell, fake or otherwise. There is no such thing as a minor film restoration but, whatever it takes, *The Medium* deserves its spa moment in order to fully appreciate its sustained flow and atmospheric film noir photography. When VAI transferred the film from VHS to DVD, the soundtrack was derived from a newly discovered reel-to-reel audio recording, much improved from that on the film print, and the labor-intensive syncing benefitted from technology that did not exist in 1951.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1530376052464/Medium-2.jpg.jpg)
<figcaption>Leopoldo Savona (billed as Leo Coleman) as Toby in *The Medium*. Photo: Courtesy of Video Artists International, Inc. / vaimusic.com.</figcaption>
</figure>

Anna Maria Alberghetti is lovely as Monica, but her light soprano quickly becomes shrill. Singing in English with a heavy Italian accent, her diction suffers but is compensated for by sweet and earnest acting. A quick reading of the libretto, or at least Monica's arias, would reward with a more complete understanding of Menotti's pungent and poetic dialog.

The other members of the cast are effectively and clearly sung. Mr. and Mrs. Gobineau, sung by baritone, Donald Morgan and soprano, Beverly Dame think they have been hearing the laughter of their small child who drowned before he learned to talk. Belva Kibler, whose melancholy mezzo blankets the proceedings in sadness as she attempts to communicate with her dead sixteen-year-old daughter, sings Mrs. Nolan. Together these characters form a chorus that is by turns naive, strident and all too anxious to believe.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1530376081725/VAIMediumimage2.jpg.jpg)
<figcaption>Marie Powers as Madam Flora in *The Medium*. Photo: Courtesy of Video Artists International, Inc. / vaimusic.com.</figcaption>
</figure>

Powers finds a glint of humor in a role that grows steadily dark, tormented, and sadistic. She brings chilling understanding and complete vocal credibility to a character that is at once a pathetic hag, a cunning charlatan and a mother whose meager gestures of love are thwarted by a life of deception that overtakes her. 

Finally there is Toby, played by Leo Coleman with intense facial expressions and physical grace that verge on the surreal. He reaches us with heart-rending fervor and deflects the cruelty around him with an innocence that is abruptly and tragically violated. If irony is a defining element in film noir, then this silent operatic character affirms *The Medium*'s place in the genre.
