+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = 2020-01-17T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Odyssey Opera's recording of [_The Importance of Being Earnest_](https://www.odysseyopera.org/recordings/) is available for [online purchase](https://www.amazon.com/Mario-Castelnuovo-Tedesco-Importance-Being-Earnest/dp/B0833WXCHH), or by calling 617-826-1626."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1579204273/media/2020/01/OdysseyOpera-AlbumCover_ly1rps.png"
primary_image_credit = ""
related_articles = ["articles/in-review-baby-kintyre.md", "articles/8-contemporary-roles-to-covet.md", "articles/in-review-earnest-the-importance-of-being.md"]
related_companies = ["scene/companies/odyssey-opera.md"]
related_people = ["scene/people/neal-ferreira.md", "scene/people/claudia-waite.md", "scene/people/rachele-schmiege.md", "scene/people/stefan-barner.md", "scene/people/jeni-houser.md"]
short_description = "And ultimately, it's indicative of Castelnuovo-Tedesco's approach: he chooses to supplement the wordplay already present in the source, and when it works the result is delightfully cheeky in the best way. One need look no further than the way the music swells with the punchlines, the subversively domestic sounds he gets from his orchestra of two pianos and percussion, and the text setting that remains declamatory almost to a fault. "
slug = "the-importance-of-being-well-recorded"
title = "The Importance of Being Well-Recorded"
youtube_url = ""

+++
Oscar Wilde was known in life for a few things: searing poetry, and witty wordplay. The latter in particular is what most people tend to focus on, as his wit in works such as _The Importance of Being Earnest_ proves. Unfortunately, this provides a rather difficult conundrum for anyone who decides to set Oscar Wilde's text to music: retaining the witticism which is integral to the success of his comedies would require one to keep the text as it is, and how much can the music really add when it is caged in such a way by the text?

Mario Castelnuovo-Tedesco attempted to answer this question in 1961 with his operatic treatment of [_The Importance of Being Earnest_](https://www.odysseyopera.org/recordings/), set in English with a bit of a less modern edge. It is this treatment which Odyssey Opera has elected to use for its latest album release, in yet another of its series tackling opera written within the last century or so. As with everything they have done, it is certainly an interesting experiment, and in this case it has struck somewhere between silver and copper, in a sense.

> Altogether, the cast was very strong, and each singer was perfectly chosen for their roles.

Castelnuovo-Tedesco's approach to Wilde’' text is to throw as many musical quotations at the wall as possible and hope that one or two stick. Invariably, there are some quotations which don't work, and when they don't they feel rather painfully on the nose. An instance in which main character Jack Worthing "kills" off his fictional brother Earnest almost feels kitschy when it's set to the tune of Chopin's _Funeral March_, throwing Dvořák’s _New World Symphony_ at a reference to someone being sent to Australia seemed inappropriate and misguided, and a quotation of the Marsellaise to a fleeting mention of the French Revolution feels quite out of place in the context of the scene surrounding it.

However, these quotations were one-off quotations: many more of them are peppered across the work as a whole, and in particular contexts the more frequently-used quotations actually do help amplify the characterization. Associating the Dutchman's motif from Wagner's _Der fliegende Höllander_ with the overly proper Lady Bracknell is a stroke of genius that uses ultra-serious music to highlight just how ridiculous her idea of a perfect marriage really is; the use of _Flight of the Bumblebee_ is perfect to illustrate the flighty nature of Algernon's constant bunburying even when he's just describing it, and the orchestral motif from the cabaletta of "Una voce poco fa" from _The Barber of Seville_ actually makes Gwendolyn and Cecily's passive-aggressive tea party that little bit cattier.

> It is a rather curious approach to an operatic text, and when it works it amplifies what was already great about the text.

And ultimately, it's indicative of Castelnuovo-Tedesco's approach: he chooses to supplement the wordplay already present in the source, and when it works the result is delightfully cheeky in the best way. One need look no further than the way the music swells with the punchlines, the subversively domestic sounds he gets from his orchestra of two pianos and percussion, and the text setting that remains declamatory almost to a fault.

There are a few bursts of sweetness that adorn the score (particularly in Act II, Scene 10, in the flirtatious back and forth between Cecily and Algernon about their proposal), but generally speaking the music never takes itself too seriously, even when it is not busy quoting something. It is a rather curious approach to an operatic text, and when it works it amplifies what was already great about the text. I suspect this is the reason why I think Gil Rose chose it for an album recording, and I am glad for this since it highlights an interesting way of going about setting the text of an opera.

> There are certainly segments of the opera that are not quite all there, but in the end it reveals Castelnuovo-Tedesco's opera as the preservation of Oscar Wilde's wit as it is.

For this purpose, Gil Rose has tapped into his usual stock of quality singers, who all provide really lovely voices into the mix. The whole cast is quite strong, with all of the singers bringing their best talents to the fore. [Jeni Houser](/scene/people/jeni-houser/)'s crystalline voice embedded Cecily Cardew with an innocence that alternately rings true to the character's innocence and disarms anybody that brings out her cattier side, something that [Stefan Barner](/scene/people/stefan-barner/) reciprocated in kind when his Algernon flirted with her. [Neal Ferreira](/scene/people/neal-ferreira/) also brought a lyrical edge that made his Jack Worthing just so likable, but was careful not to overindulge, especially when it came to his more lyrical moments with [Rachele Schmiege](/scene/people/rachele-schmiege/)'s Gwendolyn. [Claudia Waite](/scene/people/claudia-waite/)'s Lady Bracknell was also delightfully uptight, and while her voice may have lacked agility in some parts she more than made up for it with vocal character.

Altogether, the cast was very strong, and each singer was perfectly chosen for their roles. They were all supported by a wonderfully cheeky read of the score from pianists Linda Osborn and Ether Ning Yau as well as percussionists Robert Schulz and Nicholas Tolle, with Rose’s direction being as detail-oriented as always.

Overall, Odyssey Opera's latest album release is a delight to listen to. There are certainly segments of the opera that are not quite all there, but in the end it reveals Castelnuovo-Tedesco's opera as the preservation of Oscar Wilde's wit as it is. And truly, when one is thinking of operatic treatments of Oscar Wilde's wittier work that he is best known for, what more could you want? It is an interesting opera, and it is good to see that it has made its way to record.