+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2014-07-16T10:10:00-04:00"
lastmod = "2017-05-04T12:25:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1493915142995/2017-05-04---Travel.jpg.jpg"
publishDate = "2014-07-16T10:10:00-04:00"
related_articles = ["articles/shes-leaving-home.md","articles/music-the-musicians-therapy-except-when-its-not.md","articles/helpful-singers-opera-does-house-calls.md","articles/childfree-opera-singers-happiness.md","articles/how-was-it-and-other-dangerous-questions.md","articles/networking-for-introverted-performers.md","articles/redefining-the-goal.md","articles/singers-its-time-to-expand-your-dating-pool.md","articles/opera-other-trysts-a-love-story.md"]
related_people = ["scene/people/alice-coote.md"]
short_description = "Some people really do thrive on this kind of life; others find themselves at a crux, in which they seriously weigh all the things they love against each other. Some people take matters into their own hands by starting their own opera company in whatever city they damn well please. They open a teaching studio, or even admirably straddle the worlds of day-jobs and opera gigs. But some of us are simply stubborn, and we want to do what we want to do; our homesickness and loneliness can, in some cases, be outweighed by the true love of our art."
slug = "the-heart-and-the-art"
title = "The heart and the art"
+++

Our jobs must seem quite surreal to the average person. The opera industry is full of professional travellers; singers, conductors, directors, coaches, stage managers and designers are often in a constant state of transit. It's not uncommon for an opera-type's calendar to feature three weeks in Toronto, two in Montreal, a four-week audition tour throughout Europe, and three nights in New York, all back-to-back. We tell our less artsy friends about our work, and the consensus is that our lifestyle sounds "glamourous". And there are certainly parts of it that are indeed glamourous. Opera folk are well-traveled, often multi-lingual, with a huge circle of friends and colleagues from around the world. They work in theatres and concert halls, which is a cool idea in itself. They seem to jet-set from gig to gig, and I suppose the average person imagines an opera singer's travel experience is a slightly tamer version of the [Beatles' arrival in America](https://www.youtube.com/watch?v=1Df-LvrRcEo), touching down on a runway and rushing off to the concert stage to accept their applause. For those who choose to make a career out of making opera, travel is a necessity; but at what cost?

If we go right to the source and ask opera folk about said "glamour" in their career, the first response might be closer to a deep sigh and a loaded "Yeah, it is." Because the price of all this fabulousness is time, time that could be spent with family and loved ones. I've spoken to many colleagues and friends-in-the-biz about this, often when we're both away from home at a gig. They tell me about the massive highs and lows that can come in one night from singing on the stage at the Met, and then leaving the theatre to go back to a lonely hotel room. Friends of mine speak about the life they have at home, with family and dog, and the injustice of never being in town to actually live it. I've experienced some of the more breathtaking moments in my life while traveling for work, and it's often hard to shake the feeling that I've spent those moments with the wrong people.

So we often envy the "boring" life. How refreshing would it be to have a nine-to-five job, with steady hours and pay, seeing our friends and families every day? Upon more thought, it occurred to me that the person with the "normal job" might spend their time trying to turn said job into a career, or at least something they love to do. Conversely, we artists spend years working on our craft, schlep through North America and Europe to audition for gigs away from home, all so that we can later pick and choose them more judiciously. At the very least we can hope to get paid enough money to fly our families around the globe with us. The traveling artist wants stability and they want to _unpack_, for Chrissake. The nine-to-fiver wants something new and exciting to happen to them, and they perhaps want to leave the country for the first time in their lives.

It's a case of the grass being greener, absolutely. And what to do? Are we too hard to please? Is a fulfilling and interesting career not enough? Must we also have all of our favourite people around too? The thought of trading it all in for a "mundane" life with Netflix and family dinners sounds delightful at times; but how long would it last before we craved our craft once more?

Some people really do thrive on this kind of life; others find themselves at a crux, in which they seriously weigh all the things they love against each other. Some people take matters into their own hands by [starting their own opera company](http://againstthegraintheatre.com/) in whatever city they damn well please. They open a teaching studio, or even admirably straddle the worlds of day-jobs and opera gigs. But some of us are simply stubborn, and we want to do what we want to do; our homesickness and loneliness can, in some cases, be outweighed by the true love of our art. The joy and drive I feel at work make my head swim with inspiration.

In an interview she gave earlier this year, mezzo-soprano [Alice Coote](/talking-with-singers-alice-coote-mezzo-soprano/) said, "The life has done terrible things to me, I'm not joking, this life on the road. But not to sing? I can't imagine...I just couldn't do anything else." At least we have an outlet in opera, one whose size matches our emotional peaks and valleys. When we miss our important people, and feel lonely or incomplete or depressed or in limbo, we can always find a way to throw it into our art.
