+++
author = ["authors/john-hohmann.md"]
categories = "Op-Ed"
date = 2020-03-19T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1584665767/media/2020/03/sqMetInterior_qqf5vx.jpg"
primary_image_credit = "Photo by Jonathan Tichler/Metropolitan Opera."
related_articles = ["articles/levines-ugly-exit-the-disposable-met.md", "articles/some-uncomfortable-questions-about-the-levine-business.md", "articles/when-opera-companies-protect-abusers.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md"]
related_people = []
short_description = "How sad that in announcing the Met’s 2020-21 season and the addition of the first European tour by the Met Orchestra in 20 years, it has taken this course. 26 opera companies in North America have waived Force Majeure and many have adopted plans to pay their soloists at least 50% of their fees."
slug = "the-global-pandemic-strikes-the-metropolitan-opera"
title = "The global pandemic strikes The Metropolitan Opera"
youtube_url = ""

+++
The Metropolitan Opera has gone dark, as have so many other organizations around the world to do its part in mitigating the coronavirus pandemic. The protection of human life takes precedence over art even as we acknowledge how vital and nourishing art is to life. It is unfortunate then that as General Manager Peter Gelb adheres to Center for Disease Control recommendations to control the spread of COVID-19 he has opted to abandon his soloists by evoking the Force Majeure provision in the AGMA collective bargaining agreement to avoid payment to Met soloists during the cancellation period.

> Of course, the stakes are higher for the major companies - but so are the resources.

When I reviewed the Met Orchestra at Carnegie Hall in May, 2018 it was at the height of the James Levine crisis and morale within the orchestra was reported to be understandably low. Their three-concert series opened under the baton of the music director of the City of Birmingham Symphony Orchestra, Mirga Gražinyte-Tyla. As I reported, the orchestra appeared to embrace her generous manner on the podium. In retrospect it was as if they were ushering in the beginning of a new era.

That new era is here. Yannick Nézet-Séguin has entered his first full season as the music director at the Met. How sad that in announcing the Met's 2020-21 season and the addition of the first European tour by the Met Orchestra in 20 years, it has taken this course. 26 opera companies in North America have waived Force Majeure and many have adopted plans to pay their soloists at least 50% of their fees.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1584666257/media/2020/03/PARS_3407a_qfl8fv.jpg){{% /md %}}

<figcaption>Yannick Nézet-Séguin, Parsifal rehearsals, 2018. Photo: Ken Howard / Met Opera</figcaption>

</figure>

Artists understand that in a time of a global pandemic sacrifices must be made. But these sacrifices must also be shared across the companies. One wonders where, with the exception of the Houston Grand Opera, major opera companies rest on this issue. Certainly the Met could be leading the way. Instead it has chosen to notify its artists of its decision via an impersonal and officious email that appears to hides behind  the health crisis.

> Perhaps the Guild can play a role in helping to mitigate the financial impact of the health crisis or at least in the remuneration of the singers.

Of course, the stakes are higher for the major companies - but so are the resources. If Gelb has explored options such as establishing a fund raising campaign to offset cancellation costs or postponing and/or reverting to in-concert rather than full productions for some of the remaining season, he should share his process.

The Met is my local opera company. It is also one of the largest performing arts organizations in the world. I would like to believe it is also a community, of which as an audience member I am a part, and not merely a machine that cranks out opera. The Met is a large corporation but it shouldn’t respond to this health crisis by eating its own.

The article originally intended for this space discussed the upcoming 2020-21 season, provided perspective on the urban environment in which the Met works and its plans beyond the season itself. Now doesn't feel like a prudent time to tout the new season, especially with so much uncertainty in the air, but I would like to share some encouraging facts at this disheartening moment and save the new season for later. Perhaps in the ensuing time the Met will see that what might appear to be a shrewd financial decision is actually selling its entire community short.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1584665908/media/2020/03/Flute_Thur_0957_C_pabahe.jpg){{% /md %}}

<figcaption>Joshua Hopkins as Papageno and Joélle Harvey as Pamina in Mozart's "The Magic Flute." Photo: Karen Almond / Met Opera.</figcaption>

</figure>

## Outreach and Commissions

There is plenty of outreach news to report at this time like the opera _Intimate Apparel_  playing in conjunction with the Lincoln Center Theater and a new English language production of _The Magic Flute_ being developed with the Public Theater for its outdoor Delacort Theater in Central Park. Imagine the Met Orchestra playing under the stars at the Delacort. Also a chamber opera by Missy Mazzoli in conjunction with the Brooklyn Academy of Music is planned for performance at BAM.

The Met visited Brooklyn last November for an event celebrating the production of Philip Glass’s _Akhnaten_. The Brooklyn Museum, which houses one of the world’s great collections of Egyptian art, teamed with the company to present a newly created performance piece based on the opera in the museum’s Beaux Art Court. Met singers Anthony Roth Costanzo who sang the title role and Zachary James singing Amenhotep III joined the Brooklyn Youth Chorus, the Mannes School of Music Orchestra and the Gandini Juggling troupe led by _Akhnaten_ choreographer Sean Gandini in this extraordinary community event.

> New York is pulsating with opera in various shapes and sizes from companies small and refreshingly, smaller yet. They don’t need to be steam-rolled by a gigantic institution.

One of the oldest and most successful of the Met’s outreach programs is the Metropolitan Opera Guild. It was founded in 1935 when the Met was 50 years old by philanthropist Eleanor Robson Belmont, a Met board member. Her aim was to democratize opera by seeking support form the general public and to initiate education programs. The Guild’s activities remain unparalleled in the performing arts. Rather than attempting to summarize all that the organization does I refer readers to [its website](https://www.metguild.org/index.aspx). Perhaps the Guild can play a role in helping to mitigate the financial impact of the health crisis or at least in the remuneration of the singers. Has the Guild been asked?

The news on commissions verges on the historic. A full scale opera by Mazzoli drawn from George Saunders’s otherworldly novel _Lincoln in the Bardo_ is underway. The Met will also stage Jeanine Tesori’s opera _Grounded_ based on the George Brant play about a female fighter pilot who is sidelined by pregnancy and turns to drone warfare. These commissions, unique unto themselves, are major events since the Met has performed only two operas by women in its entire history, Ethel M. Smyth’s _Der Wald_ in 1903 and the exquisite _L’Amour de Loin_ by Kaija Saariaho in 2016. The company is in talks with Mason Bates to compose an opera based on the Michael Chabon novel _The Amazing Adventures of Kavalier & Clay_. There is a pattern developing here when you include Nicho Muhly’s two recent Met commissions, _Two Boys_ and _Marnie_. It has taken some time but the Met champions young American composers.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1584666011/media/2020/03/AkhPiano_0908_B_xljsbj.jpg){{% /md %}}

<figcaption>A scene from Glass's "Akhnaten." Photo: Karen Almond / Met Opera.</figcaption>

</figure>

## Chamber Operas

In the past the Met has been chided for not producing chamber operas. To even contemplate them in a house so large is unrealistic. But as mentioned the Met will indeed collaborate on one for performance at BAM.

That the company has avoided producing chamber operas is to this writer something of a blessing. Certainly, we would like to see a broad spectrum of opera from the grand to the intimate and dare I say the _avant garde_, but the opera house on the Lincoln Center campus isn’t the place to do them. If the Met attempted to be all things, or rather all sizes, to all people I wonder if charges of institutional genocide might follow. New York is pulsating with opera in various shapes and sizes from companies small and refreshingly, smaller yet. They don’t need to be steam-rolled by a gigantic institution.

> Have supporters of this program been contacted about the cancellation policy?

Within a span of just a few weeks there was a production of Britten’s _The Turn of the Screw_ presented by On-Site Opera indoors and on the grounds at Wave Hill, a lovely public garden and estate in the Bronx. That other Met, the Metropolitan Museum of Art across town, housed the Virgil Thomson/Gertrude Stein opera _The Mother Of Us All_ in its American Wing. It was an organic setting for this piece about suffragette Susan B. Anthony that is unwisely tamed when presented in a traditional venue. Quite the collaboration, it was presented by the Juilliard School, the New York Philharmonic and the museum’s MetLiveArts series. Spring brings new offering from Encompass New Opera Theater presenting scenes from Thomson’s Lord Byron and Evan Mack’s _Angel of the Amazon_ while Mannes School of Music is presenting as mash up of Puccini’s _Suor Angelica_ and da Gagilano’s _La Dafne_. This is just a few of the offerings.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1584666412/media/2020/03/PBNC_1540a_o3sdq1.jpg){{% /md %}}

<figcaption>Denyce Graves as Maria and Janai Brugger as Clara in The Gershwins' "Porgy and Bess." Photo: Ken Howard / Met Opera.</figcaption>

</figure>

## Ticket Prices

They range from $445 for a seat in the Central Premium Parterre (but hurry, there are only a few of them) for a weeknight performance of a repertory production to just $35 for a Premium Family Circle seat. And in between are a house full of seats for each performance at prices making a night at the opera a better buy than a jukebox revue on Broadway. Prices become even more affordable for students if they register with the Met to receive discounts.

Offering $25 rush tickets is by far one of the best things that the Met has ever done, off stage, that is. The Rush Ticket program was initiated in 2006 by Dr. Agnes Varis and her husband, Karl Leichtman and receives broad support from scores of the Met’s most prominent donors. Savvy opera goers can purchase same day $25 seats online while the daily allotment lasts to all performances except special events. Seats are usually located in the visually and aurally excellent Orchestra Balance. This is arguably the most significant accessibility and audience development program ever initiated in the performing arts. Have supporters of this program been contacted about the cancellation policy?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1584666456/media/2020/03/WOZ_0717a_yylnut.jpg){{% /md %}}

<figcaption>Christopher Ventris as the Drum Major and Elza van den Heever as Marie in William Kentridge's new production of Berg's "Wozzeck." Photo: Ken Howard / Met Opera.</figcaption>

</figure>

## The Tessitura Network

Another significant development took place in 1995. And today it benefits performing arts and cultural organizations on three continents. $5,000,000 was allocated by the Met’s board of directors enabling the company to create an entirely new software system that would integrate all of its activities in ticketing, fund raising, customer relationship management and marketing. In 1999 Tessitura (first called Impresario) was activated. It evolved into the Tessitura Network when six other organizations including the San Francisco Opera and the Lyric Opera of Chicago began using it.

> Tessitura reminds us that the Met has options beyond Force Majeure

Today Tessitura Network exists as a not-for-profit corporation, the Met retaining rights to its intellectual property, that is governed by its membership which currently consists of 650 performing arts organizations in ten countries. Along with administrative efficiencies and information gathering it continues to launch innovations like the Tessitura Roving Box Office, a hand held instrument that provides full box office functions whether roving a line or at off-site locations. The unsung technology staffs from member organizations meet annually for a comprehensive conference to explore new ways to utilize the system, maintain and evolve best practices standards and explore new technology.

As organizations worldwide grapple with the disorienting impact of the coronavirus it is reassuring to know that Tessitura Network is helping member organizations and customers alike through this unforeseen period of confusion. How grateful we are for technology when it actually meets human needs. Tessitura reminds us that the Met has options beyond Force Majeure

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1584666566/media/2020/03/LACOMBE_10100_X3Z5912_B2_fgacrh.jpg){{% /md %}}

<figcaption>Peter Gelb, General Manager of the Metropolitan Opera in New York City. Photo: Brigitte Lacombe.</figcaption>

</figure>

Because non-for-profit organizations hope to turn ticket buyers into donors, the ability to integrate fundraising, ticket sales and marketing can provide data to guide internal programs that will meet this fundamental goal. Tracking purchasing habits by opera genre, for instance, and by subscription or frequency of single ticket purchase plus responses to special promotions by type can produce data that is enormously helpful in creating communication programs suited to individual customers at current or potentially increased levels—in short, creating the kind of communication that is positively received and ultimately effective.

> We want to hear them sing with joy and commitment, not in spite of their disrupted lives.

Gelb and Nézet-Séguin have both expressed welcomed plans to bring in exciting theatrical directors and to develop new collaborations and innovative programming. They are well on their ways to making good on these goals. As Nézet-Séguin balances his workload he tells us that we can look forward to collaborations with the Philadelphia Orchestra of which he is also music director. Let’s hope that the Met reverses itself and decides to lead the way on the Force Majeure issue and that it will not squander the good will or energy that Nézet-Séguin brings with his arrival as Music Director.

We appreciate the Met’s streaming of its HD broadcasts without charge during the period that the house is dark. But we would rather know that it supports its artists. We want to hear them sing with joy and commitment, not in spite of their disrupted lives.