+++
author = ["authors/rich-coburn.md"]
categories = "Op-ed"
date = "2015-12-26T10:48:00-05:00"
lastmod = "2015-12-26T10:58:00-05:00"
preamble = "For more by guest contributor Rich Coburn, be sure to [check out his blog](http://www.richcoburn.com/blog/)!"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1451145196554/2015-12-26---Partridge.jpg.jpg"
publishDate = "2015-12-26T10:58:00-05:00"
related_articles = ["articles/bach-was-all-about-that-bass.md","articles/seriously-sung-christmas-carols.md"]
short_description = "People listen to substantially different music at Christmas than during the rest of the year. How different? Consider the information I found in this article in Time, listing the 19 most recorded holiday songs since 1978 (the earliest data they had). Those songs were, on average, around 164 years old, and the newest was 65 years old. They were basically a bunch of older religious songs, and a few secular ones composed around the 1940’s."
slug = "the-ghost-of-christmas-carols-past"
title = "The Ghost of Christmas Carols Past"
+++

As I’ve been coming to terms with the inevitability of my first green Christmas in a long time, as well as the first Christmas ever that I won’t spend with my family, I’ve been putting some extra effort into getting into the Christmas spirit. I’ve watched a couple Christmas movies and had some festive evenings with friends. 

But the thing that’s always done it for me the most is Christmas music. And this year it hit me just how traditional my taste in Christmas music is. For me Christmas is *Nutcracker* (1892) and *Messiah* (1741) and a lot of old carols, both religious and secular. Sure, I like some more unusual things too, but most of them are arrangements of older songs rather than actually new material. Since my career focuses largely on old music, a preference for older music at Christmas is hardly surprising. But I also realized that I think a lot of people have pretty traditional tastes at this time of year. So because the majority of my holiday-related gigs were over,

## I Got Down to Researching.

It turns out I was right. People listen to substantially different music at Christmas than during the rest of the year. How different? Consider the information I found in [this article](http://time.com/3613551/christmas-song) in *Time*, listing the 19 most recorded holiday songs since 1978 (the earliest data they had). Those songs were, on average, around 164 years old, and the newest was 65 years old. They were basically a bunch of older religious songs, and a few secular ones composed around the 1940’s.

The really cool thing about these older songs is that, despite being written mostly in the 19th century, they're treated exactly like jazz standards. They're adopted by people across every genre of Western music I can think of, and people freely take liberties with the melody, rhythm, text, etc., to make the songs their own. I can't think of any other sub-genre of classical music that has been adopted by so many other musical cultures. That's an interesting idea to explore, but it's unfortunately a little off-topic.

Back to the data. I realize that a list of most recorded titles privileges older songs. So I decided to take a different approach and see what that yielded; after a little poking around I settled on:

## The Billboard Hot 100

I looked up the top 25 holiday songs this week, and what year they were all written in. Turns out the average age of a song in that top 25 is 51 years old. But the oldest song on that list is only 81 years old, so you can tell that there are a lot of songs clumped at the old end of that chart.

For comparison, the top 25 songs this week, holiday-related or no, are on average about two years old. For the record, that's 21 songs from this year, 2 from last year, and 2 Christmas songs from the 90's. Because I’m a nerd, I’ve put this data into a graph:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1451144814821/graph.jpg.jpg)
</figure>

Clearly, these two lines are not close to the same shape, which demonstrates that the music we consume at Christmas is wildly different than the music we normally consume. I was left with two questions.

Firstly, why is our taste in Christmas music so wildly different from our taste in everyday music? And why is it focused so specifically on couple of decades when a substantial part of our population wasn’t even born? (The graph above seems to indicate a drop in songwriting in the 50’s but if you actually look up the year of composition of a bunch of popular secular Christmas songs, you’ll see that the 50’s are almost as well represented as the 40’s.)

Secondly, why, with the possible exception of Mariah Carey’s 1994 *All I Want For Christmas Is You* (which appears on both the above Billboard charts), have there been so few holiday classics in the past decades? 

I would love to go on and answer these questions for you, but the truth is that I really don’t know. I know that there was a concerted effort to write spirit-lifting Christmas music as a result of the Great Depression and World War II. Also, families separated by the war experienced a sense of nostalgia around Christmas, which is central to many of the songs of the era. That accounts for the sudden burst of holiday music in the second half of the 30's that continued into the 50's.

Why these songs were written is relatively straightforward. But setting my personal love of their style aside, I couldn’t say why they have dominated the Christmas season for more than half a century.
