+++
author = ["authors/blanche-isral.md"]
categories = "Editorial"
date = "2015-06-07T19:07:00-04:00"
lastmod = "2015-12-04T15:47:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433718612620/IndieFeature.jpg.jpg"
primary_image_credit = "Krisztina Szabó in Against the Grain Theatre's Death & Desire"
publishDate = "2015-06-09T08:45:00-04:00"
related_articles = ["articles/tim-vernon-artistic-director.md","articles/does-new-opera-raise-the-bar-for-performers.md","articles/are-the-good-old-days-of-opera-really-gone.md","articles/cosi-a-day-in-the-life.md","articles/back-to-school-opera-a-practical-glossary.md","articles/new-opera-more-singer-input-needed.md","articles/the-5-best-worst-states-for-finding-an-opera-house.md","articles/meet-the-friends-their-seven-deadly-sins.md","articles/in-review-the-seven-deadly-sins.md","articles/look-at-all-the-new-operas.md","articles/opera-lyra-and-the-five-stages-of-grief.md","articles/a-tale-of-two-audiences.md","articles/opera-for-voyeurs-opera-peep-show.md","articles/liederwolfe-stuns-in-operapeepshow.md","articles/great-ideas-devoted-disgruntled.md","articles/is-it-time-for-the-met-to-move.md","articles/aria-umezawa-opera-5s-die-fledermaus-with-surprises.md","articles/updating-operas-why-stop-at-the-libretto.md","articles/canadians-abroad-the-quarterly-report.md","articles/a-diction-lesson-french-canadian-swearing.md","articles/dont-miss-the-2nd-annual-new-york-opera-fest.md","articles/in-review-the-italian-girl-in-algiers-at-myopera.md","articles/success-hype-the-first-season-of-opera-pubs-in-toronto.md","articles/fine-mess-composer-new-opera.md","articles/celebrating-10-years-of-opera-by-request.md","articles/the-value-of-creating-new-work-for-singers.md","articles/a-dreamy-psychological-thriller-vanessa-at-oper-frankfurt.md","articles/4-reasons-to-get-excited-about-opera-in-2018.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/indie-opera-to.md","scene/companies/liederwolfe-opera-collective.md","scene/companies/the-industry.md","scene/companies/beth-morrison-projects.md","scene/companies/american-opera-projects.md"]
related_people = ["scene/people/francesca-perez.md","scene/people/lindsay-michael.md"]
short_description = "What we call ‘indie’ opera is not necessarily any more ‘independent’ than Big Opera – ‘grass-roots opera’ might be a better definition. Whatever you call them, what these organizations do have is a license to artistic freedom and experimentation that big-budget opera has had to renounce in order to maintain an outdated model of funding: subscriptions, high-profile donors, and swanky corporate sponsors. "
slug = "the-future-of-opera-is-indie"
title = "The Future of Opera is Indie"
+++

> All art is independent; the mere act of labelling any art form as 'independent' is redundant. Independence is the only true state of art.” – Elliot Grove, Founder, Raindance Film Festival

You’ve heard the term ‘Indie Opera’ tossed around in the last couple of years. [Indie Opera T.O.](https://www.facebook.com/indieoperapotluck?fref=ts), a group of twelve opera companies, recently received OPERA America’s Building Opera Audiences grant. But what does ‘indie’ actually mean in opera? The term is borrowed from indie music and indie film, which are both for-profit industries where the money flows quite differently. In the arts, freedom starts with no-strings-attached, cold, hard cash, which is hard to come by in any industry. What we call ‘indie’ opera is not necessarily any more ‘independent’ than Big Opera – ‘grass-roots opera’ might be a better definition. Whatever you call them, what these organizations do have is a license to artistic freedom and experimentation that big-budget opera has had to renounce in order to maintain an outdated model of funding: subscriptions, high-profile donors, and swanky corporate sponsors. 

While working for the [Canadian Opera Company](/scene/companies/canadian-opera-company/) and closely following the indie opera scene, I have noticed a major grass-is-always-greener phenomenon:

- Indie opera companies wish they had the resources and recognition that big-budget companies enjoy. 
- Big-budget companies wish they had the freedom and flexibility of indie opera.

There are important parallels to be made here between opera and film. Elliot Grove, founder of the Raindance Film Festival, makes a great point in distinguishing independent film from Hollywood movies: 

> “It is only the corporate nature of filmmaking in America that has made independence seem unusual. Hollywood has created this crazy situation where businessmen basically create the majority of films as a way to realize their multi-million dollar business deals - so much so that any film made outside of this nutty-dizzy factory has to call itself an "independent" film in order to be distinguished from the suits. So we create this special category of art called “independent film”. […] How ludicrous! Let's never forget, the independent artists are not the oddballs in the history of art -- the businessmen are.” 

For big-budget opera, the equivalent is pleasing the big donor. Not that indie opera doesn’t have donors, but the more experimental companies are doing a better job of attracting and cultivating audiences and donors who expect creativity and adventurousness in the artistic product, without expecting their dollars to give them a direct say in what ends up on the stage.

We don’t expect all movies to be art, because film is largely a for-profit industry. Opera doesn’t have this excuse, since it’s a non-profit industry. There are three basic ways for an arts organization to get money: ticket sales, fundraising (corporate and individual), and grants. The latter two mean asking people for money without giving them access to your product (an opera ticket). When done right, this is the company impressing audiences with its offering and its contribution to their lives, enough to make them want to materially be a part of it. When done wrong, this is the company panhandling and guilt-tripping audiences to support a bygone era. 

I have no patience for arts organizations playing the pity card. This is because I truly believe that opera is a living, breathing artform, not just a museum curiosity. Storytelling through song and staging is pretty much the oldest form of art there is. Creation and performance are fundamental to the human experience, directly following the need for food and shelter in our evolution. I stopped feeling sorry for opera when I realized this. And you can’t have high expectations of something until you stop pitying it. I started turning my attention toward companies that are, in my opinion, celebrating opera as a living artform: telling important and transformative stories, exploring contemporary staging and visuals, translating libretti, and trying out novel venues.

Big Opera’s dependence on, and allegiance to, subscribers and private donors is nothing short of devout. The COC’s subscriber base – over 65% of COC audiences – is made up of less than half of a percent of Torontonians. For the COC, trying new or different things that aren’t proven subscriber- and donor-pleasers is the equivalent of putting tens of millions of dollars on the line. It’s no wonder, then, that Big Opera rarely sticks its neck out to support new works or to present works that speak to an audience other than its long-time followers.

In doing so, though, Big Opera is digging itself into the very small slot of historical museum. Does opera have a place in the not-so-near future? Absolutely. You can see it on the stages of indie companies all over the city. And if they continue to be as fearless as they are nowadays, opera will properly tap into this city’s pulse and speak to Torontonians.
