+++
author = ["authors/samuel-loetscher.md"]
categories = "Review"
date = 2023-09-27T00:00:00Z
disclaimer = ""
image_gallery = []
postamble = "For additional information and ticket purchases, please visit [lyricopera.org/dutchman](https://www.lyricopera.org/shows/upcoming/2023-24/the-flying-dutchman/)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1695823709/sqLOC_Dutchman_4.jpg"
primary_image_credit = "Tomasz Konieczny in the title role of The Flying Dutchman, Lyric Opera of Chicago, 2023. Photo: Todd Rosenberg."
related_articles = ["articles/talking-with-conductors-enrique-mazzola.md", "articles/vancouver-opera-sails-away-in-the-flying-dutchman.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["/scene/people/tomasz-konieczny.md", "scene/people/tamara-wilson.md"]
short_description = "It remains essential to engage in a nuanced conversation about the intricate legacy of the man behind the music. The Flying Dutchman, with its timeless themes of love, redemption, and eternal yearning continues to captivate audiences, even as we grapple with the enduring shadows of Wagner's beliefs."
slug = "the-flying-dutchman-sets-sail-at-lyric-opera-of-chicago"
title = "The Flying Dutchman sets sail at Lyric Opera of Chicago"
youtube_url = ""

+++
Making a grand return to Chicago, Wagner's masterpiece, [_The Flying Dutchman_](https://www.lyricopera.org/shows/upcoming/2023-24/the-flying-dutchman/), will grace the [Lyric Opera of Chicago](/scene/companies/lyric-opera-of-chicago/)'s stage from September 23 to October 7, 2023. Recognized as composer Richard Wagner's first masterpiece, _The Flying Dutchman_ is renowned for its haunting narrative and soaring melodies. Over 160 musical and dramatic talents, including some of the world's most sought-after soloists, breathe life into this captivating odyssey onstage in Chicago.

Wagner's works like _The Flying Dutchman_ have frequently been eclipsed by the contentious shadow of his well-documented anti-Semitic beliefs. Despite the enduring popularity of his compositions, from the iconic "here comes the bride" wedding march to references in mainstream culture, such as SpongeBob Squarepants, and even in recent news, with the notorious Russian mercenary Wagner Group, it remains imperative to acknowledge the problematic aspects of the composer's personal life and convictions.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1695823710/LOC_Dutchman_1.jpg){{% /md %}}

<figcaption>The company of Lyric Opera of Chicago's production of The Flying Dutchman, 2023. Photo: Todd Rosenberg.</figcaption>  
</figure>

The Lyric Opera of Chicago addressed this matter during their pre-opera discussion, led by speaker Elinor Olin. In this engaging dialogue, Olin alluded to Claire Dederer's book, "Monsters: A Fan's Dilemma," which ponders the question, "Can we appreciate the creations of artists, both classic and contemporary, even when we disagree with their beliefs?"

While his musical compositions are celebrated for their sheer brilliance, it remains essential to engage in a nuanced conversation about the intricate legacy of the man behind the music. _The Flying Dutchman_, with its timeless themes of love, redemption, and eternal yearning continues to captivate audiences, even as we grapple with the enduring shadows of Wagner's beliefs.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1695823844/LOC_Dutchman_27.jpg){{% /md %}}

<figcaption>Tomasz Konieczny as the Dutchman in Lyric Opera of Chicago's production of The Flying Dutchman, 2023. Photo: Todd Rosenberg.</figcaption>  
</figure>

The opera, often described as one of Wagner's most haunting, unfolds a tempestuous tale of the Dutchman, a sailor condemned to eternally roam the seas. Through recurring musical motifs, known as leitmotifs and rich orchestration, Wagner keeps the audience on the edge of their seats, eager to discover the fate of the cursed Dutchman.

[Enrique Mazzola](/scene/people/enrique-mazzola/), in his third season as Lyric's Music Director, takes the helm of the esteemed Lyric Opera Orchestra in a series of momentous firsts. This season opener, backed by a 72-piece orchestra marks Mazzola's debut conducting Wagner at Lyric. His season culminates with his inaugural production of _Aida_ marking his 100th opera conducted.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1695823709/LOC_Dutchman_25.jpg){{% /md %}}

<figcaption>Tamara Wilson as Senta and Robert Watson as Erik in Lyric Opera of Chicago's production of The Flying Dutchman, 2023. Photo: Todd Rosenberg.</figcaption>  
</figure>

Wagner's score for _The Flying Dutchman_ spotlights the extraordinary Lyric Opera Chorus, featuring contrasting men's and women's choruses throughout the opera. Under the direction of Michael Black, Lyric's Chorus Director and Head of Music, the powerful 85-member Chorus exerts a profound influence on the production.

Bass-baritone [Tomasz Konieczny](/scene/people/tomasz-konieczny/) and soprano [Tamara Wilson](/scene/people/tamara-wilson/) deliver captivating portrayals of the Dutchman and Senta. Konieczny, hailed as "The Breakout Star of the Met Opera's Ring" by _The New York Times_, returns to Lyric following his acclaimed role as Wozzeck in the 2015-16 Season. Wilson, known for her outstanding Verdi performances at Lyric, returns after her recent role as Elvira in _Ernani_ in the 2022-23 Season. Wilson's rendition of "Traft ihr das Schiff" was a spellbinding showcase of her vocal prowess and emotional depth.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1695823709/LOC_Dutchman_10.jpg){{% /md %}}

<figcaption>Tamara Wilson as Senta and Melody Wilson as Mary in Lyric Opera of Chicago's production of The Flying Dutchman, 2023. Photo: Todd Rosenberg.</figcaption>  
</figure>

Renowned bass Mika Kares reprises his role as Senta's father, Daland. The cast also introduces tenor Robert Watson as Erik and mezzo-soprano Melody Wilson as Mary, both making their Lyric debuts. Ryan Capozzo, a third-year member of Lyric's Ryan Opera Center Ensemble, returns to the mainstage as the Steersman.

Director Christopher Alden's production masterfully conjures the illusion of a haunted galleon battling tumultuous waters. It boldly blends modern elements while preserving the essence of the original story. (Interestingly, a flair for Wagnerian spectacle seems to run in the family, as Christopher Alden's twin brother and fellow opera director, David Alden, recently directed a new production of _The Flying Dutchman_ at Santa Fe Opera this past summer.) Allen Moyer's imaginative sets and costumes combine to create an eerie atmosphere, and Anne Militello's shadowy lighting design adds the finishing touches to this eerie production, marking her Lyric debut.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1695823709/LOC_Dutchman_5.jpg){{% /md %}}

<figcaption>Ryan Capozzo as the Steersman, Mika Kares as Daland, and Tomasz Konieczny as the Dutchman in Lyric Opera of Chicago's production of The Flying Dutchman, 2023. Photo: Todd Rosenberg.</figcaption>  
</figure>

In a captivating return to Lyric, Wagner's inaugural famous opera achieves what all Wagnerian operas do: it ensnares the audience with a compelling narrative, complex musical compositions, and soaring vocal lines crafted for richly developed characters. (Remarkably, it accomplishes all this in just 2 hours and 20 minutes, half the typical duration of a Wagner opera.)

For those eager to embark on this Wagnerian voyage, there are [five opportunities](https://www.lyricopera.org/shows/upcoming/2023-24/the-flying-dutchman/) to experience _The Flying Dutchman_ on September 23, 27, October 1 (matinee), 4 (matinee), and 7, 2023. With a runtime of 2 hours and 20 minutes, performed without intermission and featuring easy-to-follow English translations projected above the stage, this production promises to be a memorable and thought-provoking theatrical experience. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1695823709/LOC_Dutchman_21.jpg){{% /md %}}

<figcaption>The company of Lyric Opera of Chicago's production of The Flying Dutchman, 2023. Photo: Todd Rosenberg.</figcaption>  
</figure>