+++
author = ["authors/jeremy-hirsch.md"]
categories = "Review"
date = 2019-11-12T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Oper Frankfurt's production of [_Lady Macbeth of Mtsensk_](https://oper-frankfurt.de/de/spielplan/lady-macbeth-von-mzensk/) is onstage through December 12."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1573603398/media/2019/11/sq4138_ladymacbethvonmzensk12_gross_xsddnt.jpg"
primary_image_credit = "Anja Kampe (Katerina Ismailowa) in Lady Macbeth of Mtsensk, Oper Frankfurt, 2019. Photo: Barbara Aumüller."
related_articles = ["articles/a-visceral-nightmarish-tourdeforce-der-mieter.md", "articles/a-star-soprano-and-a-stellar-debut-in-oper-frankfurt-s-manon-lescaut.md"]
related_companies = ["scene/companies/oper-frankfurt.md"]
related_people = []
short_description = "Both Kampe and Golovnin are extraordinary in terms of vocal technique and stamina. Neither voice diminished noticeably by the end of what is an enormously challenging sing. But neither voice translates the overwhelming circumstances of the opera into music that matches its stakes. Points for consistency, but where was the drama?"
slug = "the-evil-banality-of-lady-macbeth-of-mtsensk-at-oper-frankfurt"
title = "The evil banality of Lady Macbeth of Mtsensk at Oper Frankfurt"
youtube_url = ""

+++
Paradoxically the most authoritarian rulers are usually the pettiest. After Joseph Stalin and his cronies attended a performance of Dmitri Shostakovich's wildly popular opera [_Lady Macbeth of Mtsensk_](https://oper-frankfurt.de/de/spielplan/lady-macbeth-von-mzensk/) (currently at [Oper Frankfurt](/scene/companies/oper-frankfurt/) in a new production by Anselm Weber), the dictator directed the creation of a now infamous critique in a 1936 issue of the Soviet magazine _Pravda_ that lambasted, and implicitly threatened, Shostakovich and his two-year old work.

The [bad-faith argument](https://sutalkmusic.files.wordpress.com/2012/11/muddle-instead-of-music.pdf) went that by rejecting clear, simple melodies in favor of cacophonous musical chaos, the composer distorted opera and "ignored the demand of Soviet Culture that all coarseness and savagery be abolished from every corner of Soviet life." The opera was banned by the Soviets for nearly three decades.

Of course, this was a ruse. What could be more out of proportion than a government labeling an avant-garde opera dangerous while it purged its own citizens?

Yet, the critic was right that Shostakovich's score is shocking. Even today, the satirically grotesque dances, the brutal brass outbursts, and the wailing dissonances are jarring in their iconoclasm. To hear this score in the 1930s would be brain bending. No wonder the Russian public went crazy for it.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1573603450/media/2019/11/4137_ladymacbethvonmzensk03_gross_qakkyu.jpg){{% /md %}}

<figcaption>Anja Kampe (Katerina Ismailowa) and Dmitry Belosselskiy (Boris Ismailow) in Lady Macbeth of Mtsensk, Oper Frankfurt, 2019. Photo: Barbara Aumüller.</figcaption>  
</figure>

The opera's plot, adapted from Nikolai Leskov's short story of the same name, is itself brutal. Katerina Lvovna (Anja Kampe), of humble origins, is married to a wealthy merchant in the provincial Mtsensk district. Her husband, Zinovy (Evgeny Akimov), and her father-in-law, Boris Izmailov (Dmitry Belosselskiy), all but lock her away in their estate where she is wasting away from the tedium of a heavily restricted life.

One day, with her husband away on business, Katerina ventures down to the worker's quarters. She comes upon a group of male workers who have thrown Katerina's cook, Aksinya (Julia Dawson), into a barrel and are gleefully groping her for sport. The cook's shrieks ricochet off pounding horn blasts. The gang of men laughs menacingly in rhythm, thrusting choreographically like a grotesque male burlesque rape fantasy.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1573603462/media/2019/11/4124_ladymacbethvonmzensk05_gross_pqzsfg.jpg){{% /md %}}

<figcaption>Alfred Reiter (Pope, top center), including Anja Kampe (Katerina Ismailova) and Dmitry Golovnin (Sergei) and ensemble in Lady Macbeth of Mtsensk, Oper Frankfurt, 2019. Photo: Barbara Aumüller.</figcaption>  
</figure>

When Katerina intervenes, the leader of the crew, Sergei (Dmitry Golovnin), a recent hire who lost a string of jobs by sleeping with his bosses' wives, talks her down with aggressive negging. When he grabs her, she asks him to relent. He's gripping her hand so tightly that her ring is digging into her finger. Sergei persists. The scene breaks up, but shortly thereafter Sergei appears in Katerina's room and continues his pursuit. Relentless, he drags her into bed – a gruesome start to an affair that leads to the murder of both Boris and Zinovy at the hands of the couple.

But what of Katerina's loneliness? Her sole escape is a VR headset with which she views low-fi images of the outdoors. It hardly seems immersive, but she plays like she's relaxed. A computer with an internet connection or a smart phone might be a more reasonable escape.

Banal cruelty dominates the domestic scenes. Sergey, Boris, and Zinovy all repeatedly abuse Katerina to different degrees but she seems more oblivious than hollowed out or disturbed. Kampe, who sings well, plays Katerina with a vague naturalism that evokes a dull inner life.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1573603560/media/2019/11/4129_ladymacbethvonmzensk13_gross_l2yizt.jpg){{% /md %}}

<figcaption>Dmitry Belosselskiy (Boris Ismailow) and Anja Kampe (Katerina Ismailowa) in Lady Macbeth of Mtsensk, Oper Frankfurt, 2019. Photo: Barbara Aumüller.</figcaption>  
</figure>

The score takes a lead role in the storytelling. Only Katerina's (and later, the old laborer's) music is largely sincere. Sergey's duplicitous come-ons are expressed with Verdian schmaltz. When desperation sets in, his melodies go sour. Boris, the ghastly stepfather, gets the Scarpia treatment with a massive, crashing entrance theme. His melodies lack finesse and are to be brayed not sung.

The contrabassoon grounds the men's actions in buffoonery. An extremely low, pumping ostinato that underlies much of their scenes can only be played crudely. Its repetitive peasant dance marks the men, regardless of their social status, as bumpkins. Yet, I couldn't help relating the burps to the march before the tenor aria in Beethoven's 9th symphony. Joy here may be dubious.

What's disturbing, and Shostakovich reflects this in his music, is not just the characters' cruelty towards Katerina (and Aksinya) but the pleasure they take in the cruelty itself. The gleeful dancing as the men assault Aksinya, the surrealist jig that a high priest (Alfred Reiter) dances at Boris' funeral, the terrifying, ecstatic wedding march, and the chorus of biker gangsters, led by clarion-voiced baritone Iain MacNeil, who complain about not having enough crime to pursue like the sailors in _South Pacific_ beg for a dame, all point to a patriarchy drunk with violence.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1573603587/media/2019/11/4132_ladymacbethvonmzensk09_gross_hhlldd.jpg){{% /md %}}

<figcaption>Anja Kampe (Katerina Ismailova, left sitting) and Zanda Švēde (Sonjetka) and ensemble in Lady Macbeth of Mtsensk, Oper Frankfurt, 2019. Photo: Barbara Aumüller.</figcaption>  
</figure>

Both Kampe and Golovnin are extraordinary in terms of vocal technique and stamina. Neither voice diminished noticeably by the end of what is an enormously challenging sing. But neither voice translates the overwhelming circumstances of the opera into music that matches its stakes. Points for consistency, but where was the drama?

Belosselskiy's singing was earthier. As Boris, he forcefully bellowed straight-toned arcs that, in their inelegance, matched the character's brutality. Later, as the blind, old, forced laborer, who is a sort of a guardian angel to Katerina, he indulges in sumptuous legato singing, channeling the comforting voice of death.

The supporting cast, filled out largely by the Oper Frankfurt ensemble, sang admirably. Bass Anthony Schneider had a rich, even tone. Peter Marsh, who has keen comic instincts, was well-cast as the drunk who discovers Zinovy's corpse, breaking Katerina and Sergey's scheme wide open.

The orchestra, led by Oper Frankfurt Music Director Sebastian Weigle, found it's stride late in the evening with the wedding march. A few intriguing moments in the score went by deemphasized or not quite coordinated. Some screws can be tightened and should be throughout the nine show run.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1573603617/media/2019/11/4139_ladymacbethvonmzensk22_gross_s4kzua.jpg){{% /md %}}

<figcaption>Dmitry Belosselskiy (Old Forced Laborer) and ensemble in Lady Macbeth of Mtsensk, Oper Frankfurt, 2019. Photo: Barbara Aumüller.</figcaption>  
</figure>

The _Pravda_ review describes _Lady Macbeth_ as "a game of clever ingenuity that may end very badly," presumably for the young Shostakovich. But the composer managed to tactfully appease the oppressive Soviet regime while penning a remarkable oeuvre widely performed today. For Shostakovich, irony goes beyond the page.