+++
author = ["authors/john-hohmann.md"]
categories = "Op-Ed"
date = 2020-08-03T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1596480300/media/2020/08/sqBernsteinWestSideStory4_kcvkgj.jpg"
primary_image_credit = "Leonard Bernstein at the podium with the pick-up orchestra he assembled for the 1984 recording of “West Side Story” featuring a cast of internationally acclaimed opera singers including Jose Carreras, Kiri Ti Kanawa, Tatiana Troyanos and Marilyn Horne.\nPhoto: Courtesy Deutsche Grammophon © Unitel."
related_articles = ["articles/la-nilsson-celebrating-birgit-nilsson-at-100.md", "articles/west-side-story.md"]
related_companies = []
related_people = []
short_description = "Through the years the original Broadway cast recording, abridged as it is to fit the time limitations of a single “long-playing” vinyl disk, has remained the pinnacle of its major recordings. The soundtrack of the hugely successful film recruited legions of fans plus a few detractors, Bernstein among them, who found it overblown. "
slug = "the-emphatically-present-west-side-story"
title = "The Emphatically Present “West Side Story”"
youtube_url = ""

+++
_West Side Story_ is back. The current Broadway revival of the 1957 Leonard Bernstein/Stephen Sondheim musical is slated for a spring resumption with the projected lifting of the pandemic shutdown, and we await the holiday arrival of Steven Spielberg’s remake of the 1961 film. But _West Side Story_ never really left. It is always and emphatically with us.

This Broadway classic with a book by Arthur Laurents, inspired as we all know by Shakespeare’s _Romeo and Juliet_, has been a cultural benchmark since its inception and more than six decades later its cultural vibrancy and social relevance remain acutely present. Secure in its place with Bernstein's trail-blazing score and Sondheim's timeless lyrics, it speaks to us as much about class inequities and racial injustice as it does tragic romance.

Through the years the original Broadway cast recording, abridged as it is to fit the time limitations of a single "long-playing" vinyl disk, has remained the pinnacle of its major recordings. The soundtrack of the hugely successful film recruited legions of fans plus a few detractors, Bernstein among them, who found it overblown.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1596480539/media/2020/08/WestSideStory-castrecordingLEROY_Ken_fubcnn.jpg){{% /md %}}

<figcaption>Ken LeRoy (Bernardo) Chita Rivera (Anita) Larry Kert (Tony) and Carol Lawrence (Maria) take a break during the recording session of the original Broadway cast of "West Side Story" at the CBS 30th Street Studio in New York City, October, 1957 three days after the show opened. Photo: Don Hunstein © Sony Music Entertainment.</figcaption>

</figure>

In 1984 Bernstein himself, having never conducted the work, did so in a manner that wasn’t completely operatic, despite his casting of opera singers, nor was it traditional musical theater. Orchestrally the recording was the definitive statement by the composer. But its hybrid nature was the subject of debate, especially among those who felt that Deutsche Grammophon might have exerted undue influence on the project. Then in 2014 the score was brilliantly realized in a lean yet opulent manner by Bernstein protégée Michael Tilson Thomas with the recording of a concert version by his San Francisco Symphony and a team of top flight musical theater voices.

Bernstein's composition has remained impressively adaptable over the years. Tracks from a 1996 compilation, "The Songs of West Side Story," show the versatility and resilience of a score that retains its veracity when interpreted in diverse musical styles. "Somewhere" is conjured as a gospel anthem by Aretha Franklin. Selena's sultry new jack turn on "A Boy Like That" and Trisha Yearwood's luscious rendering of its companion piece, "I Have A Love" replete with steel guitar, offer an urban vs. country encounter that paraphrases the show's storyline. Even the often maligned "I Feel Pretty" is bent by Little Richard to fit his raucous brand of rhythm and blues.

Back when musicians mined Broadway shows for themed albums, jazz greats like Oscar Peterson, Andre Previn and Dave Brubeck looked to _West Side Story_. Those stirring standards "Maria", and "Tonight" along with the edgy numbers like "Something's Coming" and "Cool" showed their straightforward adaptability to the jazz idiom. Jazz vocalists tuned in when Anne Ross audaciously ditched the lilt and found the attitude in "I Feel Pretty" backed by the Jerry Mulligan Trio and Lea DeLaria turned up the heat on "Cool" with pianist Brad Mehldau.

### Sidelining Sondheim and Shakespeare

But it wasn't until 2017 that conductor and drummer Bobby Sanabria and his New York based Multiverse Big Band developed _West Side Story—Reimagined_. Delving into the work's Latin origins and compositional undercurrents, this primarily instrumental interpretation directly addresses the social ills that continue to grip society. In the process Sondheim and Shakespeare are sidelined.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1596483985/media/2020/08/WSSR-AS-1_mwzzb1.jpg){{% /md %}}

<figcaption>Bobby Sanabria and the Multiverse Big Band performing "West Side Story—Reimagined" to a capacity audience in Damrosch Park on the Lincoln Center campus in New York City on August 10, 2018 backed by photographs of the South Bronx. Photo: Alan Spatz Photography.</figcaption>

</figure>

With Sondheim's lyrics out of the way Sanabria offers commentary that at first appears to get in its own way because the new orchestrations speak so powerfully on their own though it soon coalesces with the score’s streetwise soundscape. Leading the band from the drum set Sanabria reminisces, cajoles, even preaches a little and emerges as a rhythmic humanist who reaches us with his good intentions and the project’s wholly inclusive vibe.

As for Shakespeare, while the songs appear in their original sequence, star-crossed storytelling is eclipsed by the infectious energy of the music. Sanabria and his team of arrangers bring the score's Latin influences including an abundance of dances with evocative names like Bomba Yuba and Joropo and even more evocative rhythms to the surface. These are some of the sounds that influenced Bernstein when he heard them over Cuban radio while visiting Key West in the 1940's. They provide fresh insight into the composer.

As an introduction to "Cool" Sanabria intones "You get pulled over by a New York City police officer, what do you do?" He and the band respond "You be cool!" Point taken.

Jazzheads, a term roughly equivalent to opera buffs but not to be confused with Jazzheads, the label upon which _West Side Story—Reimagined_ is released, will be impressed by its jazz bonafides. The pulsating array of Latin drums beating is at once enigmatic and welcoming. Sharp and decisive brass playing abounds throughout, especially on “Cool,” in which one can almost discern the voices of the Jets despite the absence of lyrics. The influence of the late Descarga master and double bass player Cachao is felt on the insinuating syncopation of “Gym Scene-Cha Cha Cha” which subtly picks up the “Maria” theme and ends in a big-band flourish. “Maria” opens with a layer of ritualistic chant and rhythmic percussion that remains constant as the melody is settled into with muted brass. Strong trumpet and saxophone interplay evokes the gritty character of “Cool” that is otherwise swept up in a swing arrangement.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1596484058/media/2020/08/WSS-SanabriaSottomayor_kafkqj.jpg){{% /md %}}

<figcaption>U.S. Supreme Court Justice Sonia Sotomayor joins Bobby Sanabria following his performance of "West Side Story—Reimagined" with the Multiverse Big Band the at the Kennedy Center in Washington D.C. on January 18, 2019. Photo: courtesy: Bobby Sanabria.</figcaption>

</figure>

Sanabria and Bernstein both require a little stretch from the listener. In casting Jose Carreras, the renowned Spanish tenor as Tony, Bernstein asks us to believe in him as a former Jet despite his noble Catalan accent that remains undiminished when he sings in English. And Sanabria doesn’t veer from the Latin sound when the orchestra portrays the Jets. Traditionally we think of the Jets in terms of rock ’n roll or the blues while the Sharks are exclusively Latin. So we have to listen intently to make distinctions. That little stretch is part of what society should be doing right now.

## "It's not an opera"

"It's not an opera," Bernstein told _The New York Times_ on the eve of his recording project. "It's a work on its way towards being one." Bernstein moved it along that path with the casting of Carreras, Kiri Te Kanawa as Maria and most effectively Tatiana Troyanos as Anita, lover of the Sharks' leader, Bernardo. Te Kanawa settled on a mature yet convincingly girlish sound and maintained a credible accent throughout. Troyanos reveling in a mezzo middle range incorporated infectious rhythm and lavishly articulated speech bringing Anita to vivid life. Marilyn Horne came in for a rueful "Somewhere" that inhabited its own island of vocal serenity.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1596481216/media/2020/08/tumblr_pe2p36A9ui1rclfzho5_640_gfj9ku.jpg){{% /md %}}

<figcaption>Tatiana Troyanos, Kiri Ti Kanawa and Jose Carreras relax with Leonard Bernstein (second from left) after the recording of “West Side Story” conducted by Bernstein in 1984. Marilyn Horne also appeared in the cast. Photo: Courtesy Deutsche Grammophon © Unitel.</figcaption>

</figure>

There was more than a hint _West Side Story_ was operatically inclined when Carol Lawrence and Larry Kert were cast as Maria and Tony in the original Broadway production. With her light and refined soprano Lawrence displayed the purity of sound and vocal agility that elevated the stature of her performance. Kert sang "Something's Coming" and “Maria” with a handsomely refined tenor and boundless vocal drive that has yet to be matched by any singer tackling the role. Their duets, "Tonight" and "One Hand, One Heart" possess such romantic richness that the couple could have waltzed, albeit incongruously, out of New York's West side and into Vienna.

The production launched a Broadway legend and an acclaimed coloratura as it claimed some diversity in casting. Prior to her Broadway status, Chita Rivera, who is of Puerto Rican, Scottish and Italian heritage, brought her spectacular dancing, singing and acting skills to the stage as Broadway’s first Anita. Reri Grist cast as Consuelo a Sharks woman, was tapped to sing "Somewhere" during the ballet sequence and broke ground as well. A pioneering African-American coloratura, Grist went on to an impressive international operatic and concert career with credits including twelve seasons at the Salzburg Festival singing Strauss and Mozart under Böhm, Mehta and Karajan.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1596481314/media/2020/08/GRIST_Reri_phA_scyp4h.jpg){{% /md %}}

<figcaption>Reri Grist preparing to record “Somewhere” which she was tapped to sing in the ballet sequence of West Side Story. Grist was cast in the role of Consuelo, one of the Sharks women. Photo: Don Hunstein © Sony Music Entertainment.</figcaption>

</figure>

The recording of this terrific cast was in the extraordinarily capable hands of conductor Max Goberman and record producer Goddard Lieberson. Goberman, who previously conducted Bernstein's "On the Town," studied conducting with Fritz Reiner while at the Curtis Institute of Music and was in the midst of recording the complete symphonies of Hayden with the Vienna State Opera Orchestra when he died at age 52. Lieberson, a pioneer in the recording of Broadway shows, produced the session with an ear to the forthcoming stereophonic technology by equipping the studio so that the recording could be released in both monaural and later stereo pressings. The compact disk, remastered to celebrate the show’s 50th anniversary, includes bonus tracks consisting of Bernstein's "Symphonic Dances" derived from the show with the New York Philharmonic.

But vinyl still takes a turn. The recording is now available from Analog Spark, an audiophile imprint, on two 180-gram vinyl disks that provides twice as much room, meaning wider grooves producing more dynamic range, to meet audiophile level listening standards. Sourced from the original three-track analog tapes, the process provides greater transparency plus enhanced soundstage width and depth, a sonic feat for which Lieberson was ready decades earlier. This is a Broadway show that is worth the couture treatment and it comes packaged with extensive photos from the recording session heightening the you-are-there experience.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1596481568/media/2020/08/WSS_MOCK_2_large_lcjmwf.jpg){{% /md %}}

<figcaption>The 1957 cast recording of "West Side Story" has been released as an audiophile pressing by Analog Spark on two 180-bit vinyl disks with greatly enhanced sound dynamics. Sourced from the original three-track analog tapes, the edition features cover art work as it first appeared reproduced on a gatefold package with photos from the recording session. Photo: Courtesy Analog Spar</figcaption>

</figure>

## Avoiding global snickers at the movies

Robert Wise, co-director of the 1961 film, was tasked with introducing into the cultural mainstream the balletic choreography of Jerome Robbins danced by the Jets and Sharks, hopefully without causing global snickers. As acclaimed as Robbins' choreography was, the idea of rival gangs performing balletic moves in city slums would be radically new, especially to the film's youthful target audience. Wise employed steadily intensifying music and opened with a screen filled by an abstraction that morphs into an aerial view of Manhattan. The "Prologue" and "Jet Song" gradually build as the Jets and Sharks balletically stalk each others. Audiences have been in thrall ever since. Score one for the soundtrack.

Dubbing prevailed on the vocals, however. The esteemed Marni Nixon sang Maria's songs for Natalie Wood while a chap named Jimmy Bryant provided a fresh if generic sound for Richard Beymer's Tony. Portions of Anita's singing parts were dubbed by Betty Wand but the dancing and fiery portrayal belonged to Rita Moreno, the only actress of Puerto Rican decent with a featured role in the film.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1596481700/media/2020/08/WSS_Cool_ivg10b.jpg){{% /md %}}

<figcaption>Tucker Smith (front row, second from left) leads the Jets and Jets women in an intense rendition of "Cool" in the 1961 film version of "West Side Story." The song was repositioned to appear after the rumble in which Riff and Bernardo, leaders of the Jets and Sharks were both killed. Photo: clipstill@mgm.com.</figcaption>

</figure>

In a boldly original move the soundtrack peaks when "Cool" is repositioned as something more than a pre-rumble pep talk by Riff, leader of the Jets, as it had been on stage. Placing it after the rumble, during which Riff is killed by Bernardo, "Cool" exposes gang style grief and anger management. Tucker Smith, playing Ice, Riff's lieutenant, takes over the Jets and the number. Smith spews the lyrics with calculated potency to a straight-ahead jazzy arrangement, amplified finger snapping and audible expressions of subdued rage. "Cool" drives home the societal ills that propel the Jets. We also pick up some moody impressions of the Jets women who otherwise have little to do after the dance at the gym. The song works overtime.

## Leonard Bernstein and Michael Tilson Thomas Dive In

To fully understand why the soundtrack, though still a crowd-pleaser, has its detractors, listen to it in close proximity to the Bernstein and Thomas recordings. The soundtrack is shallow by comparison and lacks detail. Likened to an Olympics diving competition the degree of difficulty for its splashy orchestrations might rate 3.2 with Bernstein and Thomas slicing the water with a 3.8, maybe higher. Listen for the multiple layers of percussion in their orchestras and resonating pianos that suggest more intimate dimensions. Bernstein fulfills the promise of his work with a pick-up orchestra. There is the sense that if he were to have returned to it 20 years later, we might hear unforeseen musical growth. Thomas, with a keen understanding of Bernstein's music, nimbly creates a musical theater atmosphere and encourages the orchestra that he had led for two decades at the time of the recording to literally dance.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1596481813/media/2020/08/SFSWestSideStoryStefanCohen_kj9te8.jpg){{% /md %}}

<figcaption>Michael Tilson Thomas conducting the San Francisco Symphony and cast members of "West Side Story" in "America", featuring Jessica Vosk as Anita (front row, second from left,) in a concert performance of the musical by Leonard Bernstein and Stephen Sondheim at Louise M. Davies Symphony Hall, June 2013. Photo: Courtesy of San Francisco Symphony/Stefan Cohen.</figcaption>

</figure>

Thomas cast Alexandra Silber and Cheyenne Jackson, both accomplished theater singers, meaning that they are singing actors. Silber sounds operatic in ways that suit Maria's gentle yet formidable character. Jackson projects an ecstatic energy with a crisp sound full of subtle shading. With their pronounced and traditionally placed harmonies they embody the spirit of youthful romance. Jessica Vosk's Anita is an assured firecracker. Her staccato presence and articulation to match compliment the biting delicacy of the chorus of Sharks women in the show-stopping "America".

Bernstein had already negotiated the operatic skirmish. Thomas didn’t need to deal with the status of _West Side Story_. Nor do we. It's beside the point. Consider the intricate construction and dramatically conflicting points of view in "Quintet" as they inexorably converge with intense musical consonance on the word "tonight." Join the musicologists who have likened "Quintet" to the Act Three quartet from _Rigoletto_ and feel at ease about its musical pedigree.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1596481939/media/2020/08/SFS-WSS-MTTetal_rygful.jpg){{% /md %}}

<figcaption>Michael Tilson Thomas (far right) is joined by husband, Joshua Robison (far left), Alexandra Silber (Maria) then State Senator Mark Leno and Cheyenne Jackson (Tony) backstage at Louise M. Davies Symphony Hall following a concert performance of "West Side Story" conducted by Thomas. Photo: Courtesy of San Francisco Symphony/Stefan Cohen.</figcaption>

</figure>

Perhaps the most operatic thing about _West Side Story_ is that owning just one recording of it won't suffice. Opera buffs, with our many versions of _Tosca_, _Der Rosenkavalier_, entire _Ring Cycles_ and so many other multiple must-haves, understand that musical fact of life.

Even if your preference is limited to stalking the perfect "Cool" you will find that Tucker Smith single-handedly makes the soundtrack worth owning. He dubs Riff's "Jet Song" for Russ Tamblyn as well. The polished Riffs of Bernstein's Kurt Ollmann and Thomas' Kevin Vortmann share, possibly by virtue of their vocal training, a disconcerting whiff of prep school dropout suggesting an unexplored backstory. But Michael Callan, an actor not preternaturally disposed to song, as Broadway’s original Riff is the quintessential wise guy. His "Cool" brands him a street gang sage. With just enough range and vocal flint he works his way around Bernstein's wily tune and the crafty Sondheim lyric.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1596482060/media/2020/08/WSS-SondheimCallan_io80de.jpg){{% /md %}}

<figcaption>Lyricist, Stephen Sondheim confers with Michael Callan who played Riff, leader of the Jets, in the original Broadway cast before recording the song "Cool". Callan also sang lead on "Jet Song" and participated in "Quintet". Photo: Don Hunstein © Sony Music Entertainment.</figcaption>

</figure>

Ivo van Hove's revival and Spielberg's film anticipate some contrasting approaches that may influence their recordings. For starters "I Feel Pretty" is jettisoned from the revival while Tony Kushner states his new screenplay will leave all musical numbers intact. Jonathan Tunick, a Sondheim compatriot, participates in the revival's orchestrations. Film music composer David Newman will adapt and orchestrate Bernstein's score for the film with Gustavao Dudamel conducting the recording session. Kushner's screenplay reportedly hearkens back to the 1950's while van Hove delivers a _West Side Story_ for today, an assertion reinforced by his replacement of Jerome Robbins' choreography with that of the revolutionary Anna Teresa De Keersmaeker. New York City Ballet's Resident Choreographer, Justin Peck choreographs for Spielberg.

As Sanabria's project shows, such new approaches are welcome. Hopefully these recordings will find ways to expand the musical possibilities of _West Side Story_ while creating incisive context for the songs. At the very least they will serve to introduce new generations to this durable, enduring and emphatically present musical masterpiece.