+++
author = ["authors/david-todd.md"]
categories = "How-To"
date = 2023-04-09T20:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = "This is the final article of a series called [\"The Elton John Act\"](/the-elton-john-act/), which aim to demystify the process of becoming an operatic répétiteur and assist anyone wishing to audition as one in the German-speaking operatic system. In this article we focus on sight-reading, and how it can be worked on like any other skill."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1681080668/media/2023/04/sqPianistseries_sightreading_ysrs5x.jpg"
primary_image_credit = "There’s nothing like an unfamiliar sheet of music to strike fear into even experienced répétiteurs."
related_articles = ["articles/the-elton-john-act-v-riding-the-rollercoaster-the-act-ii-finale-from-le-nozze-di-figaro.md", "articles/the-elton-john-act-iv-fiddly-for-the-fingers-the-smugglers-quintet-from-carmen.md", "articles/pianist-s-progress-iii-violent-sadistic-utterly-engaging-the-maid-scene-from-elektra.md", "articles/pianist-s-progress-ii-trampolines-tongue-twisters-the-set-audition-excerptsexcerpts.md", "articles/the-elton-john-act-vi-between-the-sheets-the-opening-of-der-rosenkavalier.md"]
related_companies = []
related_people = []
short_description = "The good news is that sight-reading can be worked upon and improved, though sadly too many people get bogged down in thorny nests of notes, and are unable to clear them away in order to find the music that lies beyond. "
slug = "the-elton-john-act-vii-dont-stop-playing-and-never-look-back-the-dreaded-sight-reading"
title = "The Elton John Act VII: Don't stop playing & never look back! The dreaded sight-reading"
youtube_url = ""

+++
For British people like me, the phrase "sight-reading" more often than not evokes panicked memories of entering dusty church halls as a child in order to strut your stuff in a graded music exam. It was only when I started working with musicians outside the UK that I realised what a fantastic education this was, as many other countries do not insist on sight reading from a young age. For the hopeful répétiteur, sight-reading is one of the key pillars that we must rely on in our musical lives. While ideally we should never be asked to sight read in the context of an opera production, when accompanying for auditions we often receive the music only half an hour before, and will get around fifteen minutes or so to put it together with the singer. No early-career répétiteur can be expected to know all of the "standard" opera repertoire, so we must be able to read quickly, and present a confident accompaniment that supports the singer.

> The panel don’t expect you to get every note right, and will be forgiving if a fair few go by the wayside, as long as the general harmony is clear. 

## Try and see the wood despite the trees

The good news is that sight-reading can be worked upon and improved, though sadly too many people get bogged down in thorny nests of notes, and are unable to clear them away in order to find the music that lies beyond. In an audition, this is the key; the panel don't expect you to get every note right, and will be forgiving if a fair few go by the wayside, as long as the general harmony is clear. What is more difficult to forgive is a lack of musicality in the sight-reading. If your right-hand articulation in a Handel aria is unable to conjure up the frenzied bow movements of an entire first violin section, or your playing in a Strauss aria is devoid of all the rich bass that purrs throughout the orchestra, then it is unlikely you will make a good impression. 

The basics of sight-reading are no different from the advice I was given before entering the church halls all those years ago: check the key signature, check the tempo (you can always ask for this if it is unclear), and get a rough idea of the whole excerpt before you begin to play, including any changes of time or difficult harmonic passages. A technique I learnt only recently was to actively make my eyes focus on the upcoming bars, so that by scanning ahead, I always have a heads up of any pitfalls or nasty surprises on the horizon. It’s not always easy to do this consistently, but if you can practise it regularly it will become easier. You shouldn't usually have to sing along when sight-reading for an audition.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1681080680/media/2023/04/PIanistseries_violinist_whe5rv.jpg){{% /md %}}

<figcaption>It's important to never forget that you are representing the sound of an orchestra when sight-reading.</figcaption>  
</figure>

## Thinking like an orchestra

To these universal skills the repetiteur's brain must analyse how the orchestra will sound and have a good feel for the style. Is there a moment where you can recreate a certain orchestral sound or articulation, or where the sound should progress more heavily? Many repetiteurs who are accused of playing too pianistically are so criticised because their playing flows more like a weak gravy than a rich custard of heavily scored orchestral moments. Any technically tricky moments that would usually involve more than twenty seconds of practice to sort out can be ignored or "sketched". You should not waste time trying to play intricate lines as it will always be at the expense of something else more important, but there is no harm in confidently acknowledging their existence as much as you can. 

The golden rule is of course: don’t stop playing! No matter what happens, keep going. As with most things, any mistakes that you do make will probably seem much worse to you anyway. They often say that goalkeepers love penalty shoot-outs because they are not expected to save the goals, and if they do, they become heroes. If we can try and approach sight-reading more in this vein, then the whole thing becomes much more positive.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1681080698/media/2023/04/Pianistseries_goalie_c8lqrp.jpg){{% /md %}}

<figcaption>Try and approach sight-reading more like the goalkeeper in a penalty shoot out – it will help the whole experience to become more positive!</figcaption>  
</figure>

## Accompanying singers

When it comes to sight-reading while accompanying singers, be careful! Many are unable to judge how hard something really is, which is completely fair enough, since it's not their instrument. Many a time a singer has said to me "I'll just bring the music on the day, it's not difficult", and then there have been surprisingly difficult moments to get my fingers around. Luckily, the opposite has also happened! When you're in the situation, you have the extra aspect of listening to the singer and being absolutely with them. While this may seem more daunting, I've often actually found it easy to sight-read with a singer, as I feel less exposed, and if they know the piece well, they can often guide me through in a way that is not possible if I’m alone. 

## Using your superpower

To be able to have a dependable and solid sight-reading ability is a big asset, making life much easier for you and enabling you to stand out from the crowd. I think we should never overlook that it's an area that can be improved upon and practised like all other musical skills, and the result is a superpower that will never cease to be helpful in a moment of need!