+++
author = ["authors/david-todd.md"]
categories = "How-To"
date = 2023-04-09T11:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = "This article is one of a series called [\"The Elton John Act\"](/the-elton-john-act/), which aim to demystify the process of becoming an operatic répétiteur and assist anyone wishing to audition as one in the German-speaking operatic system. Here we explore the passionate opening of Richard Strauss’ opera _Der Rosenkavalier_."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1681081664/media/2023/04/sqPianistseries_Rosenkav_kj03ff.jpg"
primary_image_credit = "The Marschallin and Octavian recover after their intense night of passion. Photo: Robert\nWorkman."
related_articles = ["articles/the-elton-john-act-vii-don-t-stop-playing-never-look-back-the-dreaded-sight-reading.md", "articles/the-elton-john-act-v-riding-the-rollercoaster-the-act-ii-finale-from-le-nozze-di-figaro.md", "articles/the-elton-john-act-iv-fiddly-for-the-fingers-the-smugglers-quintet-from-carmen.md", "articles/pianist-s-progress-iii-violent-sadistic-utterly-engaging-the-maid-scene-from-elektra.md", "articles/pianist-s-progress-ii-trampolines-tongue-twisters-the-set-audition-excerptsexcerpts.md", "articles/pianist-s-progress-i-the-elton-john-act.md"]
related_companies = []
related_people = []
short_description = "There is no getting around what this stirring scene that opens Richard Strauss' opera Der Rosenkavalier is all about. Everything in the music depicts a morning of frantic and illicit rumpy-pumpy between the Marschallin and her younger lover Count Octavian."
slug = "the-elton-john-act-vi-between-the-sheets-the-opening-of-der-rosenkavalier"
title = "The Elton John Act VI: Between the Sheets – The Opening of Der Rosenkavalier"
youtube_url = ""

+++
* Opera: _Der Rosenkavalier_
* Composer: Richard Strauss
* Length of scene to learn: Beginning of the opera until at least Figure 14 (sometimes further to Figure 27).
* Edition used:  1943 Boosey and Hawkes, Vocal Score by Carl Besl. Recordings I listened to:
* Thielemann 2009, with Renée Fleming, Sophie Koch and Diana Damrau, Karajan 1957 with Elisabeth Schwarzkopf and Christa Ludwig, André Previn 1993 (Vienna Philharmonic).

There is no getting around what this stirring scene that opens Richard Strauss' opera _Der Rosenkavalier_ is all about. Everything in the music depicts a morning of frantic and illicit rumpy-pumpy between the Marschallin and her younger lover Count Octavian. The music is full of passionate swing and, well, everything that goes with such an occasion. Since Richard Strauss orchestrates the opening here so richly, it is crucial to constantly reference the score as you are preparing it, and listen as widely as you can to various versions. Whenever I have encountered this scene in an audition context, I have usually only had to play as far as the first vocal entry of the opera "Wie du warst" (Octavian basically saying ‘sex with you is great’, though in my version the English is rather prudishly translated, which I suppose fits the stereotypes of our national character.) This usually makes it the only scene where you don’t have to sing as you play, unless you are asked to go further (usually until Figure 27 at the latest).

> The richness of this string section is immense and thick, perfectly placed to conjure the thrilling world of swirling passions

Before anything else I would take a look at the orchestral score. What must leap out at you is how rich the string section is here; Strauss demands sixteen first violins, sixteen second violins, twelve violas, ten cellos and a whopping eight double basses. The richness of this string section is immense and thick, perfectly placed to conjure the thrilling world of swirling passions, though a world away from our noble piano, with its rather paltry three strings per note.

Strauss' marking "Stürmisch bewegt" can be translated to English in many ways, meaning moving either stormily, tumultuously, boisterously, or my favourite, rapturously. However you play this opening, it must capture this fervent passion in character, and you must try and find how to move as this immense string section would while also channelling the characters of the other instruments.

The opening horn call gives you the perfect chance to do this, and you can double the first note in the bass to represent the pizzicato of the cellos and double basses if you like. One of my colleagues recently told me how a teacher of his once demonstrated how the entire first seven bars could be played just with the left hand, though I tend to play it safe and use both to find the sound I need. The horn’s accented notes are usually a little held back whenever they come, and you must work hard to find the sound in the second bar. Though in the piano score we simply see "forte" in bar one, changing to fortissimo in bar two, the full sound of the orchestral entry shown in the orchestral score means this moment will have a very strong impact.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1681082799/media/2023/04/Pianistseries_clocks_i80zdx.jpg){{% /md %}}

<figcaption>Thinking about how a pendulum sustains its momentum is useful when studying this scene.</figcaption>  
</figure>

## Finding your swing

I usually take Strauss specific metronome markings to be quite accurate, but even if you don't, it is important to note their relation to each other. At Figure 1, you must pick up the tempo by a fraction in order to fully realise the "überschwänglich" (exuberant or ebullient) character that he calls for. By this time, if you haven’t already, you should have found the "Schwung" (swing) character which will propel this scene forward. I like to think of a pendulum when I play this and how the momentum keeps it in constant motion, swinging to just the moment where it has to turn back each time.

You must have the feeling that you are being carried along by an internal sense of propulsion as you play. Though this may feel slightly erratic, Strauss actually measures the increases of tempo through this scene quite precisely, leading us to the musical and sexual climax just before Figure 5. Keep this point in mind as your arrival because everything before should swell to this moment; as Strauss writes just before Figure 3, everything from here on out should flow with strongly parodied expression.

I usually like to slightly separate the phrase that begins just before Figure 2, as this not only anticipates the first accent of the three, but also demarcates the return to tempo after the accelerando in the previous bar. Don't neglect the weight of the chords in the left hand here that counterbalance the melody – they are after all, played by all four horns, the bassoons, cellos and basses. 3 bars after Figure 2 there is a wonderful moment where the musical figure is wound up in a tight coil and released again, making a sound like an engine repeatedly revving up. The small crescendos are written in my vocal score to show this, as they are in the strings of the orchestral score, so make sure that they are not lost, as they are an exciting part of the musical momentum.

> If this section works successfully, it is the epitome of nervous excitement, always building but never quite getting there.

## Building to the climax

The bassethorn needs to call clearly in the left hand 2 bars before Figure 3 and as you lead to Figure 4, so make sure you have a full understanding of how the phrases build. If this section works successfully, it is the epitome of nervous excitement, always building but never quite getting there. When the real climax comes just before Figure 5 it is therefore even more rewarding and must have been carefully measured dynamically as you reveal your full range from the piano at Figure 4 to the _fff_ at the climax. Here you must use the piano's full resonance as you can’t risk it sounding hard – I often use generous pedal to create this, though always ensure that this does not disguise any of the individual lines.

A delirious fall happens from Figure 5 onwards as the upper and lower lines collapse in on each other in a delicious swirl of colour. Strauss' instruction to stay in strict time is very helpful here as it can be difficult at first to keep the hands in sync. At Figure 6 I usually ignore the written piano chord and emphasise the first entry of the timpani in a low rumbling bass. As you lead into the slargando it is important that the chords retain an inner legato which pre-empt the horn entry four before Figure 8. One thing to watch out for here is that you know where all the themes are. Often piano reductions spread themes between the two staves and it can become quite difficult to see where they lead. A quick look at the score will solve this and help you to join together this relaxed, post-coital music.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1681082814/media/2023/04/Pianistseries_birds_qoqvsh.jpg){{% /md %}}

<figcaption>Strauss writes that birds can be heard outside the window, so their song must be clear in your playing.</figcaption>  
</figure>

## Channelling the bird calls

As you move towards Figure 10, make sure you have calibrated your tempi so that you are not too tranquillo too soon. Strauss makes it clear through his metronome marks that Figure 10 (tranquillo) is even slower than "molto più tranqullio" at Figure 8, so you must save something up in reserve for this moment of complete bliss. Getting used to the flow of these tempi is one of the hardest things about learning this excerpt, but it will become easier the more you work on it, and all of the markings make complete musical sense. Don't indulge this moment too long as you must soon pick up the tempo again at Figure 11, which will carry you through to the moment the curtain rises. Here (four after Figure 12) there is a perfect opportunity to channel the sound of birds, which Strauss writes can be heard from the garden outside the window. These obviously need to be light and breezy, even though they are notated very specifically.

There are few scenes in opera that are so gorgeously descriptive as this, and once you have found your inner swing and exuberance, it won’t be hard to channel it into this ecstatic musical drama.