+++
author = ["authors/david-todd.md"]
categories = "How-To"
date = 2023-04-08T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = "This article is one of a series called [\"The Elton John Act\"](/the-elton-john-act/), which aims to de-mystify the process of becoming an operatic répétiteur and assist anyone wishing to audition as one in the German-speaking operatic system. Here we continue with the \"Smugglers’ Quintet\" from Bizet’s opera Carmen."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1680468173/media/2023/04/sqPianistseries_Carmen_ctc3ho.jpg"
primary_image_credit = "There is an inbuilt feeling of illicit excitement that runs throughout this fun-filled excerpt, and a wonderful sense of camaraderie between the characters is developed throughout. Photo: Robert Workman."
related_articles = ["articles/the-elton-john-act-vii-don-t-stop-playing-never-look-back-the-dreaded-sight-reading.md", "articles/the-elton-john-act-vi-between-the-sheets-the-opening-of-der-rosenkavalier.md", "articles/the-elton-john-act-v-riding-the-rollercoaster-the-act-ii-finale-from-le-nozze-di-figaro.md", "articles/pianist-s-progress-i-the-elton-john-act.md", "articles/pianist-s-progress-iii-violent-sadistic-utterly-engaging-the-maid-scene-from-elektra.md", "articles/pianist-s-progress-ii-trampolines-tongue-twisters-the-set-audition-excerptsexcerpts.md"]
related_companies = []
related_people = []
short_description = "Though this excerpt can be frustrating at times due to its technical challenges, I promise it gets easier. Nevertheless, if I can, I always avoid starting with it in an audition, as it works best for me when my fingers are a little warmed up and I'm feeling a little more comfortable with my surroundings."
slug = "the-elton-john-act-iv-fiddly-for-the-fingers-the-smugglers-quintet-from-carmen"
title = "The Elton John Act IV: Fiddly for the Fingers – The \"Smugglers’ Quintet\" from Carmen"
youtube_url = ""

+++
* Opera: _Carmen_
* Composer: Georges Bizet
* Length of Scene to learn: Beginning of Quintet Scene No. 15 to the end of the scene ("avec soi") before the next recitative.
* Edition Used: First Public Domain Version from ISMLP.com, French Text alone
* Recordings I listened to: Prétre 1964 with Maria Callas, Ozawa 1986 with Jessye Norman, Seguin 2010 with Elina Garanca (DVD)

While you may not personally have smuggled anything important in your life to be able to draw from your own experiences for this fun-filled excerpt, there is an inbuilt feeling of illicit excitement that runs throughout, and a wonderful sense of camaraderie between the characters that is developed. If I had to choose to spend an evening with this group or the dour maids of _Elektra_, I know which one I'd choose.

One of the strengths of the set excerpts is that they do test the three main operatic languages, and this scene from _Carmen_ is the perfect way to show off your acquaintance with the language of love. As with all the excerpts, it is crucial to show that your pronunciation is as close to perfect as it can be. We all have at least one language that is weaker than the others, and for me it's French. I found that by the end of the process of learning, reading the text to a friend who was a native speaker wasn't enough; I had to sing it to them for them while playing in order for them to really judge me well. I then found that luckily, since the scene is fast, it was easier to be criticised less harshly when I sang and played together, than when I simply read the text alone!

> This opening section must find the Goldilocks zone; too slow and the energy and excitement is immediately lost; too fast and the whole thing becomes a crumpled, panicky mess.

## Being clear with the fingers

The nature of most piano reductions of Carmen is that they can be very fiddly for the fingers, and you must be very clear with all the different musical lines you play. There is no hiding under-developed technique in the richness of the sound like one may be tempted to in parts of the Strauss. Instead, like the Mozart we will look at next, one must be technically agile and precise, though as always, this shouldn’t be at the expense of the drama. As a result, my method for learning the Smugglers' Quintet was slightly different from _Elektra_, as this time it wasn’t really helpful for me to construct a sketch version to practise singing to. The nature of the singing here is also different to _Elektra_; instead of longer phrases sung by characters, there are many short interjections, often of only two notes or so. I therefore began by separating both parts completely, studying the French with my friend away from the notes (though gradually incorporating rhythm), and then studying the orchestra and developing the instrumental part at the piano.

The piano part is particularly cruel because it starts with a tricky chromatic run, which is prone to collapsing in on itself under pressure. While this should be clear and musically phrased and articulated (don’t forget that staccato note at the top!), it also has to establish your tempo immediately. The whole excerpt is like a finely-oiled steam engine, and this opening section must find the Goldilocks zone; too slow and the energy and excitement is immediately lost; too fast and the whole thing becomes a crumpled, panicky mess. (You will also probably become a crumpled, panicky mess if this happens. Trust me, I’ve been there).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1680468239/media/2023/04/Pianistseries_train_wpkynf.jpg){{% /md %}}

<figcaption>The whole excerpt should run like a finely-oiled steam engine.</figcaption>  
</figure>

As a result, with this excerpt more than the others, I ensure I always have at least two bars of the tempo in my head before I start. As with conducting, it is often easier to find a place later on in the section that gives the tempo very clearly, and then to fix that tempo in your head before you begin the first bars. For me this is often one of the sections where everyone is singing together, maybe "Quoi vous avec besoin de nous". I find this helpful, because we all know how our personal perception of tempo can become less reliable when our heart is beating twice as fast in the pressure of an audition, particularly if what we are performing is relatively new for us.

## What do you want to show?

From then on, think about what you want to demonstrate with this excerpt, in comparison to what you may already have shown, or will show, with the others. I like to use it as an opportunity to demonstrate how I can phrase long legato lines, in comparison to the spiky jabs that appear in between. It is also a good opportunity to show how you can keep a pulse. This excerpt is notorious for speeding up, which is only natural since it can be very stressful, even at the best of times. The only way round this for me was slow practice with a metronome during the learning process, and once again evaluating myself by listening back to recordings of myself when I could play and sing the whole thing.

Make sure you are also differentiating between dynamics. Can you really show that the pianissimo flute of the opening is different from the piano clarinet that enters later? How is your tutti orchestra forte different from your solo horn forte? Since the instruments are often playing quite soloistically, it also gives you a chance to show that you understand their timbres. Make sure you give enough weight and depth to the horn entrance for example, in comparison to the light touch of the chromatically rising flute voice. Often considerations such as these are the first things to fly out of the window when someone begins to become stressed by a technical line or some wayward French.

> If I would rather hang out with these characters in reality, then when singing, it is my responsibility to bring them vibrantly to life.

## Adding the voice

Once the piano/orchestral part is secure at a slow tempo, I began to sing the vocal parts in. You must try and sing every line, though when there is an ensemble moment, I usually sing the uppermost line, unless there is something particularly interesting going on with another character. Just make sure not to forget that as soon as there is a solo line or phrase again, you must be there to sing it! When I started to learn these, I used to draw arrows showing where my eyes should go for the next line, which sometimes helped in the heat of an audition. In this excerpt particularly, don't forget to make the upbeats clear – all of those "De nous" must be clear every time they come.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1680468227/media/2023/04/PIanistseries_Carmen_1_bfhpg4.jpg){{% /md %}}

<figcaption>At the beginning the smugglers Dancaïre and Remendado are cunningly revealing their plans, in the hope of enlisting Frasquita and Mercédès. The teasing that ensues can only be achieved with a hearty sense of fun and panache. Photo: Robert Workman </figcaption></figure>

At the start of my excerpt I have written "CHARACTER". If I would rather hang out with these characters in reality, then when singing, it is my responsibility to bring them vibrantly to life. Again, make sure you know the context, so that you understand who the characters are and where this comes in the opera. At the beginning the smugglers Dancaïre and Remendado are cunningly revealing their plans, in the hope of enlisting Frasquita and Mercédès. Though the latter are keen, Carmen isn't, and the moment she reveals why not is the heart of the whole scene. The teasing that ensues can only be achieved with a hearty sense of fun and panache. Hopefully that slow practise will finally pay off when you get to a quicker tempo, as the flowing triplets (when they are working) make it almost impossible not to feel excited.

## The frenzied finale

Once you get to the D-Flat major ending it’s easy to feel a big sense of relief that you are out of the woods, but watch out! It is a perfect opportunity to relax and speed up, so make sure you stay focussed here so that the tempo still relates to everything that has come before. Even the last few bars don't have any kind of accelerando written through them, so keep them lively but controlled, and don't be tempted to speed up. Bizet's wonderful writing will illuminate the music enough without help from a frenzied race to the finish. Though this excerpt can be frustrating at times due to its technical challenges, I promise it gets easier. Nevertheless, if I can, I always avoid starting with it in an audition, as it works best for me when my fingers are a little warmed up and I'm feeling a little more comfortable with my surroundings. Bonne chance!