+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2014-06-11T07:45:00-04:00"
lastmod = "2015-04-23T16:16:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429819824849/IMG_0118_resized.jpg.jpg"
publishDate = "2014-06-11T07:45:00-04:00"
related_articles = ["articles/turning-opera-insideout-upsidedown-at-summer-opera-camp.md","articles/canadian-childrens-opera-companys-lullabies-from-kids-for-kids.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
short_description = "Each summer, the Canadian Opera Company presents the Summer Youth Intensive program, which is designed for young opera lovers, from grades 9 to 12. At the SYI, the participants bring their existing interests and skills, and refine them with the help of professionals in the operatic industry."
slug = "the-cocs-summer-youth-intensive-opera-really-is-fun"
title = "The COC&#039;s Summer Youth Intensive: Opera really is fun!"
+++

Each summer, the Canadian Opera Company presents the [Summer Youth Intensive](http://www.coc.ca/ExploreAndLearn/YoungAdults/SummerYouthIntensive.aspx) program, which is designed for young opera lovers, from grades 9 to 12. At the SYI, the participants bring their existing interests and skills, and refine them with the help of professionals in the operatic industry. They get masterclasses in vocal technique with voice instructors Mark Daboll and Karine St. Pierre, and in dramatic technique with dramaturge and director Markus Howard. They'll take a dramatic workshop with opera and theatre director Liza Balkan. Set designer Camellia Koo will teach them the ins and outs of production design, and Casey Hudecki will give a workshop in stage combat (how fun is that?). At the end of the program, music director Kyra Millan and director Lianne Seykora will lead a performance of operatic proportions for the participants' family and friends. For more details, check out the SYI's [complete faculty list and daily schedule](http://www.coc.ca/ExploreAndLearn/YoungAdults/SummerYouthIntensive/SYIPrograms.aspx).
This year, the SYI will be performing _Brundibár_, written in 1938 by Czech composer Hans Krása. The piece has a [fascinating history](http://holocaustmusic.ort.org/places/theresienstadt/brundibar/): it was first performed in 1943 by children who had been interred at Terezín concentration camp during the Holocaust. This summer's SYI participants will perform the English adaptation of _Brudibár_ by American writer Tony Kushner (_Angels in America_, _Lincoln_).

I had the opportunity to work with the Summer Youth Intensive program in the summer of 2013, and it really is a special chance for young people, already catching the opera and theatre bugs, to get even more inspired with the help of the fantastic faculty and resources provided by the Canadian Opera Company. This year the program has expanded to two weeks (July 7-12th and July 14-19th), and participants can attend one or both sessions. The application deadline is June 22nd, so [click here](http://www.coc.ca/ExploreAndLearn/YoungAdults/SummerYouthIntensive.aspx) to find out more details. I still get warm fuzzies thinking about the sense of accomplishment and _fun_ to be had at the Summer Youth Intensive program. Tell the young artists in your life!

Need more convincing?  I had the opportunity to chat about the program with Katherine Semcesen, Associate Director, Education and Outreach at the Canadian Opera Company:

### What is the SYI?

Summer Youth Intensive provides young people in Grades 9 to 12 an opportunity to develop their performing arts or visual design skills, and gain access to artists and administrators working in the opera field. Mornings are dedicated to the exploration of opera chorus pieces and ensemble work, while the afternoons are programmed more for the individual. Participants can choose two electives per week which include masterclasses in vocal technique, dramatic interpretation in opera, production (stage management, theatre make-up application and techniques, prop building), stage combat, smaller ensembles and solo work for singers, drama and design. The program concludes with an informal presentation for family and friends at the end of each week. No audition is required.

### Isn’t opera for adults?

Not in the least. Opera can be enjoyed by all ages. But there are different methods of being introduced to opera. SYI’s method is a hands-on and interactive approach. Many of the individuals who participate have had some experience in the performing arts, either performing in musicals at school or with community theatres, in choirs, and some have had voice, instrumental music, acting and/or dance lessons. Not everyone has had extensive training in opera, nor should they, as the participants range from ages 13 to 18\. Despite all of the young “opera” singers emerging from TV shows like “[name the country]’s Got Talent,” it takes time and patience and years of hard work (not a quick three-minute spot on TV!) to become an opera singer or a member of an opera chorus, a musician in the orchestra pit, a designer, etc…you get my drift. Your body needs to grow into it. It’s in this spirit that we program SYI. Our artists approach each young voice, each budding designer, each musician and each emerging director with care and diligence and from their current level of experience and ability. The artists engage, excite, inspire and challenge. That is how you open the doors to the professional world of opera to the young artist, regardless of their chosen discipline.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429820036880/IMG_0177lightened_resized.jpg.jpg)
</figure>

### What do the participants learn at the SYI?

There is so much learning in one week that it’s hard to condense into one short paragraph. The program focuses on the development of the individual’s performing arts skills and general life skills, like creativity, collaboration, responsibility and self-confidence. Specific learning includes: singing operatic repertoire that is safe and appropriate for their young developing voices, how to prepare for auditions, how to approach text and music in opera from the perspective of a singer, director and designer, how to deliver a punch or an upper cut safely on stage, the skills and methods needed in designing an opera, and learning about the many careers in the industry.

### What do you enjoy about your work with this program?

I see all of the COC programs as my children, so I probably shouldn’t play favourites, but SYI is one of my top three programs that we run. I love witnessing the courageousness of the participants and how they apply themselves over the course of a week. For some it's overcoming shyness, reaching that high or low note that they’ve struggled with for months, trusting that their vulnerability will enhance and deepen the expression of a piece, or coming up with a brilliant design. They inspire me and the artists to work harder in providing these types of experiences for young people.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429819974790/IMG_0079lightened_resized.jpg.jpg)
</figure>

### What kind of feedback have you gotten from past participants?

Feedback from last year’s participants included: · “You will learn more about opera, you will have fun, and you will feel safe, comfortable and welcomed.” · The aspect of SYI that appealed to me most: “Expanding my musical horizons and getting better/polishing the things I am already good at. I had never sung opera before this program and it was cool to learn how to change my sound.” · “The diversity. Even though it’s an “opera camp” everything you learn can be applied to all fields of performing.” Overall, the participants valued working with professional artists who encouraged them to develop their artistic abilities, while providing a nurturing and safe environment for the young people to take risks. Many commented on an increase in their confidence, increased enthusiasm for the art form, and a commitment to keep learning about and honing their craft.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429819890710/IMG_0077lightened_resized.jpg.jpg)
</figure>

### How do opera programs directed towards youth help the opera industry?

Opera programs for youth help the industry in two ways: they nurture talent and support young artists who might choose to pursue a career path in opera in the future, and secondly, and for me most importantly, they demonstrate that there is a place for youth in opera and that the art form is not just for an older generations. The introductions that youth receive through hands-on and active explorations and interactions with professionals in the field cultivate their appreciation for the art form. Many return to the COC in some capacity – as volunteers, as program assistants for programs and workshops for children, as audience members, and one participant has even returned as a member of the Ensemble Studio! Mezzo-soprano [Danielle MacMillan](http://www.coc.ca/ExploreAndLearn/NewToOpera/OnlineLearningCentre/ParlandoTheCOCBlog.aspx?EntryID=24212) participated in the COC’s Opera Jam for youth in 2005 (a program in which youth created their own opera). Danielle had a great voice and her teacher encouraged her to sign-up for Opera Jam. After years of voice lessons and training, Danielle was accepted into the COC’s [Ensemble Studio](http://www.coc.ca/aboutthecoc/companymembers/EnsembleStudio.aspx).
<div class="intro">The Summer Youth Intensive program is seriously great stuff. Apply by June 22nd for this fantastically fun opportunity. [Click here for all the info you'll need.](http://www.coc.ca/ExploreAndLearn/YoungAdults/SummerYouthIntensive.aspx)</div>
