+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = 2023-02-01T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1675133178/media/2023/01/ClevelandOrchestra_RogerMastroianni_aljfjb.jpg"
primary_image_credit = "Franz Walser-Most, Music Director of the Cleveland Orchestra on the podium at Carnegie Hall. Photo: Roger Mastroianni."
related_articles = []
related_companies = []
related_people = ["scene/people/daryl-freedman.md", "scene/people/julian-pregardien.md"]
short_description = "With the first Berg-to-Schubert transition, virtually seamless though that was hardly the primary intent, Welser-Möst made clear that these works, written just over a century apart, were part of a musical continuum."
slug = "the-cleveland-orchesta-brings-radical-refinement-to-carnegie-hall"
title = "The Cleveland Orchestra brings radical refinement to Carnegie Hall"
youtube_url = ""

+++
The talk of the town, at least in classical music circles, has been the rehabilitated acoustics of the newly minted David Geffen Hall. But the constant is the sublime experience of hearing a world-class ensemble in the acoustic sanctuary that is Carnegie Hall.

Such was the case recently when long-time maestro Franz Welser-Möst and the Cleveland Orchestra performed Schubert's Symphony No. 8 "Unfinished" and Mass No. 6, paired with three pieces from Berg’s Lyric Suite. The orchestra, its chorus and five soloists catered to and basked in the hall's warm and crisp (let's call it toasty) sound in a program that was quite simply one of radical refinement.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1675132802/media/2023/01/ClevelandOrchestra_FranzWalserMost_ChrisLee_qmafqz.jpg){{% /md %}}

<figcaption>Franz Welser-Möst leading the Cleveland Orchestra. Photo: Carnegie Hall, Chris Lee.</figcaption>  
</figure>

Radical is a term not often applied to symphony orchestras but when the two movements of the Schubert symphony and Berg's three pieces from his Lyric Suite were performed _in tandem_, the effect was exactly that. With the first Berg-to-Schubert transition, virtually seamless though that was hardly the primary intent, Welser-Möst made clear that these works, written just over a century apart, were part of a musical continuum.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1675132978/media/2023/01/ClevelandOrchestra_SchubertBerg_uosnwy.jpg){{% /md %}}

<figcaption>(l-2) Portrait of Franz Schubert by Carl Jager; photograph of Alban Berg by Madame d'Ora.</figcaption>  
</figure>

Challenged with pivoting between the late Classical/early Romantic periods and the Second Viennese School, Welser-Möst demonstrated with technical and emotional assurance that the orchestra could harness and shape the music in surprising ways. In the end the Berg felt reverent while Schubert possessed a modern air.

But it was Schubert's seldom-performed Mass No. 6 that brought this reviewer to the concert. After everything it was a spectacular undertaking, dominated by the orchestra and chorus with only intermittent participation of the soloists. The Cleveland Orchestra Chorus, an all-volunteer group now in its 71st season, can lay claim to its fair share of the orchestra's esteemed pedigree. They sang with precise and fervent consistency, unhindered by COVID-conscious masks, reveling in Schubert's glorious melodies and showing dramatic reverence when the sacred sections took hold. The "all-volunteer" moniker of the chorus might be flanked by wreaths of laurel for they perform like the most dedicated and skilled of professionals.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1675132877/media/2023/01/ClevelandOrchestra_FranzWelser-Most_LisaWong_DashonBurton_MartinMitterrutzner_JulianPr%C3%A9gardien_Jo%C3%A9lleHarvey_DarylFreedman_ChrisLee_x8q188.jpg){{% /md %}}

<figcaption>(l-r) Music Director Franz Welser-Möst, Choral Director Lisa Wong, bass-baritone Dashon Burton, tenors Martin Mitterrutzner and Julian Prégardien, soprano Joélle Harvey and mezzo-soprano Daryl Freedman. Photo: Carnegie Hall, Chris Lee.</figcaption>  
</figure>

Welser-Möst, who as a frequent opera conductor at the [Salzburg Festival](/scene/companies/salzburg-festival/), knows a thing or two about voices, brought along a luxurious platoon of singers. Tenors [Julian Prégardien](/scene/people/julian-pregardien/) and [Martin Mitterrutzner](https://www.martinmitterrutzner.com/), soprano [Joélle Harvey](/scene/people/joelle-harvey/), mezzo-soprano [Daryl Freedman](/scene/people/daryl-freedman/) and bass baritone [Dashon Burton](/scene/people/dashon-burton/) were all consistently excellent, largely because the acted more as an ensemble than soloists. With so little to do they emerged as a unified force. One could only wish that Schubert had created more opportunity for the soloists, especially since the Mass lacks lines from the Catholic liturgical mass that usually appear in the Gloria and Credo sections.

An awkward logistical moment, and a minor one to be sure, occurred when Freeman, seated to one side of the podium while her fellow singers were on the other, traded places with Mitterrutzner for vocal effect. Even on Carnegie's vast stage space was tight but when filled with such radically refined music-making, a little maneuvering is easily forgotten.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1675133120/media/2023/01/ClevelandOrchestra_DarylFreedman_FranzWelser-Most_ChrisLee_ebhqo2.jpg){{% /md %}}

<figcaption>The Cleveland Orchestra and the all-volunteer Chorus of the Cleveland Orchestra with mezzo-soprano Daryl Freedman (seated) and Music Director Franz Welser-Möst. Photo: Carnegie Hall, Chris Lee.</figcaption>  
</figure>