+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-04-10T21:13:00-04:00"
lastmod = "2015-04-10T21:13:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428714696371/UncleJohn-Audience.jpg.jpg"
publishDate = "2015-03-27T09:13:00-04:00"
related_articles = ["articles/chatting-with-the-bicycle-opera-project.md","articles/concert-etiquette-or-put-down-your-phone.md","articles/operas-survival-tightened-belts-callous-questions.md","articles/is-it-time-for-the-met-to-move.md"]
related_companies = ["scene/companies/opera-5.md","scene/companies/the-bicycle-opera-project.md","scene/companies/against-the-grain-theatre.md","scene/companies/canadian-opera-company.md","scene/companies/tapestry-opera.md","scene/companies/lopra-de-montral.md"]
short_description = "I&#039;m always an advocate of up-close theatre, but the need for large-scale, overwhelming productions of Verdi, Wagner, and the likes, is legitimate. But what would happen if Canada&#039;s larger opera companies took a portion of their productions out of their main stage?"
slug = "the-case-for-nomadic-opera"
title = "The Case for Nomadic Opera"
+++

<p>
	The opera scene in Canada can be divided into two broad groups: those with real estate, and those without. Companies like the <a href="http://www.coc.ca/" target="_blank" data-mce-href="http://www.coc.ca/">Canadian Opera Company</a> own the Four Seasons Centre, which they use for their whole season. Other companies, like <a href="http://www.operafive.com/" target="_blank" data-mce-href="http://www.operafive.com/">Opera 5</a>, move between various venues for their shows. There is indeed a blurry line between a company owning its primary performance space, and a company's having a history of regular use in a specific venue, the way <a href="http://www.operademontreal.com/en" target="_blank" data-mce-href="http://www.operademontreal.com/en">l'Opéra de Montréal</a> uses space at Place des Arts. Generally speaking, though, larger opera companies have a fixed performance venue, and smaller, independent companies are more nomadic.
</p>
<p>
	Why? The obvious reason is that real estate is expensive; even renting a theatre big enough to house the size of productions synonymous with the COC or l'O. de M. can be prohibitively costly for a small company with less revenue. There's also a case to be made for grandeur. I'm always an advocate of up-close theatre, but the need for large-scale, overwhelming productions of Verdi, Wagner, and the likes, is legitimate. But what would happen if Canada's larger opera companies took a portion of their productions out of their main stage?
</p>
<p>
	Companies like Against the Grain Theatre have already made use of black box theatres, courtyards, and pubs that house compact productions. The repertoire is arguably standard for an opera company (<em>La bohème</em>, <em>The Turn of the Screw</em>, <em>Pelléas et Mélisande</em>), the singers are some of the same voices heard on Canada's largest stages, and the productions are designed to be seen and heard up close. Compare this to a company like the COC, which has a much larger annual budget, and a long history as a major Canadian arts establishment. They too put up arguably standard repertoire with a few unexpected treats, and audiences can count on hearing great singing. The draw for large-scale productions like these is in the famous singers, visually arresting productions, and a general grandeur that comes from sitting in a full-on opera house.
</p>
<p>
	But what of the audiences that don't yet have a frame of reference, a context for the different between opera in the Four Seasons Centre and opera in a pub? Since we're always a little bit talking about getting new, younger audiences, I think it may be time to discuss The Opera House. To opera newcomers, the impressive theatres and huge sets may not pack the punch we expect; after all, they have Netflix. I'm not saying these Netflix-loving newbies wouldn't enjoy themselves at the opera, but perhaps the theatres and sets aren't what will seal the deal. What would happen if the artistic calibre, and the larger audiences, of Canada's large companies were combined with the venues of indie opera? Audiences could hear the likes of Jane Archibald and Adrianne Pieczonka, up close, maybe even with a beer in hand.
</p>
<p>
	Sure, not every opera translates well outside of a traditional stage; that goes for different singers, too. Wagner's <em>Ring Cycle</em> would be tricky to do with limited space and orchestra, but I think it falls into the same category as a lot of Romantic opera, which demands plenty of room and plenty of people on and under the stage. That said, perhaps smaller, informal venues for large companies could help the cause for new opera in Canada. So much of Canada's opera is being written on a small scale, in part because it's still in a workshop stage, but often the story simply calls for a more intimate setting. I wonder if projects like<a href="http://schmopera.com/in-review-tapestry-briefs-booster-shots/" target="_blank" data-mce-href="/in-review-tapestry-briefs-booster-shots/"> the short scenes I saw at Tapestry Opera</a> would have an easier time bridging the gap between the workshop stage and a finished production; something like Benton Roark's <em>The Whisky Opera</em> could benefit from getting picked up by a large company with a more flexible budget, without the catch of having to fill a huge theatre. Here's the final icing on the cake: with a smaller venue, companies could hire singers from an entirely different pool. The size of a singer's voice wouldn't matter nearly as much, and the focus would zero right in on finding singers who can act and communicate.
</p>
<p>
	How would my utopian concept play out in reality, I wonder? How much money would be freed up in the budgets of Canada's major opera houses if they weren't spending as much on a large theatre? Would the pool of grant money available to opera companies be spread out a little more evenly? Or would lowering their expenses disqualify these companies from receiving as much grant money, cancelling out any savings? Would the <a href="http://www.iatse58.org/" target="_blank" data-mce-href="http://www.iatse58.org/">International Alliance of Theatrical Stage Employees</a> take issue with an opera company outsourcing a production or two to a smaller theatre that requires less crew members? What happens to these large theatres when they're not being used by the opera?
</p>
<p>
	When companies are asking questions about new audiences and the relevance of opera, and when the scope and scale of even the most stunning productions are easily outmatched by the visual possibilities of film and television, it seems obvious that opera should take another look at what it's always had to offer: live theatre, and real-deal singers. What if the prospective audiences of today simply aren't as taken with the opera houses as we think? The grandness of it all may be outweighed by the ticket price, the insinuated dress code, and the pressure to stay quiet and still in the dark for several hours. The interest in small, nomadic opera companies like Canada's <a href="http://bicycleopera.com/" target="_blank" data-mce-href="http://bicycleopera.com/">Bicycle Opera Project</a>, or the UK's <a href="http://www.operaupclose.com/" target="_blank" data-mce-href="http://www.operaupclose.com/">OperaUpClose</a>, tells us that opera still has a monopoly on incredible singers and the power they hold over a live audience. It would be a risk, certainly, but perhaps the way for large companies to find relevance and new audiences is to pack a bag and go visit some of those people in the venues they're already frequenting.
</p>
