+++
author = ["authors/isaiah-bell.md"]
categories = "Op-ed"
date = "2014-05-24T08:00:00-04:00"
lastmod = "2017-08-10T10:34:00-04:00"
preamble = "This is a guest post by Canadian tenor, composer and brilliant auteur, Isaiah Bell. He's [written for Schmopera before](/on-the-ego/). Enjoy."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502375690082/2017-08-10---Passion.jpg.jpg"
publishDate = "2014-05-24T08:00:00-04:00"
related_articles = ["articles/on-the-ego.md","articles/and-i-know-things-now.md","articles/we-dont-have-to-starve-dreaming-of-an-artistic-middle-class.md","articles/morbid-musings-art-death.md","articles/nude-musicians-less-hot-than-it-sounds.md","articles/the-time-i-spilled-some-secrets-into-a-microphone.md","articles/conundrums-singing-on-command.md","articles/selfdoubt-the-accidental-manual.md"]
related_people = ["scene/people/isaiah-bell.md"]
short_description = "I kind of dread being asked what I do. That’s an awful thing to say, given what an interesting and unique job I have, but it’s true. At a non-music party [NMP, for your future reference!] or in a cab, the conversation usually starts something like this:\n“So you’re travelling a lot for work – what’s your job?”"
slug = "the-business-of-passion"
title = "The Business of Passion"
+++

I kind of dread being asked what I do. That's an awful thing to say, given what an interesting and unique job I have, but it's true. At a non-music party [NMP, for your future reference!] or in a cab, the conversation usually starts something like this:
"So you're travelling a lot for work – what's your job?"

"I'm a singer!"

"Oh, what kind of singer?"

"Classical!"

"Wow!" – and then, shortly afterwards, almost inevitably – "How amazing to be following your passion!"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429832260631/passion-of-the-cellist1.jpg.jpg)
<figcaption>What Passion Definitely Looks Like For Real, You Guys.</figcaption>
</figure>

I always agree, because it _is_ amazing. And also because, often, I'd just rather move on to other topics. Partly, this is because I'm trying to break myself of the unpleasant habit of complaining about what I do in order to make it seem less glamourous (and _may I just_ take a moment to say to those in doubt: I haven't yet caught a whiff of glamour… do let me know if you can point me in its direction). The other reason is that the word "passion" unsettles to me. My knee-jerk reaction is to picture that cellist in the arthritis commercial who is just _so fulfilled_ to be Making Music in her sunlit studio (or on a grassy hilltop or wherever) that all her cares (though, besides early-onset arthritis, she doesn’t have any real cares, because she is a Free Spirit) just ebb away at the touch of bow to string. And I want to scream "It's Not Like That, OK?!"

I realize I probably sound like [this](https://www.youtube.com/watch?v=4vvBAONkYwI) [spoiler alert, this is a link to Britney Spears singing about how hard it is to be famous – _and also looking into a hand-mirror while sitting in front of a big mirror, at 1:33_]. So let me be clear: I really _do_ feel lucky – incredibly lucky – to be living the life of a professional artist. And it’s unfair of me to assume that when people say I’m "following my passion" that they mean I'm spending my life dancing in the rain, whereas other people have to _work_ for a living. It doesn't give people enough credit. It's a reaction to the media-supported artistic ideal I was (probably?) rather stumblingly trying to allude to in [this](http://schmopera.com/two-tenors-youtube-comments/) drunken masterpiece of op-ed – that, for people like the YouTube-comment genius who values the *un*trained child singer higher because of "superior natural ability," to be an artist is just to spill out art. And if you can get paid for that, you’re set!

It irks me, whenever I see a variant of this Wind-In-The-Hair Cellist Experiencing Passion (Am I the only person who has such a specific image of this particular trope?), that this imaginary art-person seems perfectly fulfilled in the moment just to participate in the Holy Sacrament of Passion. We're getting into dangerous territory here, and perhaps I'm outing myself as a sour type who can't feel feelings, but I have to admit – that does not speak to my experience of being a professional singer.

This is NOT to say that I don’t experience these moments of euphoric transport from time to time. It's happening more, actually, as I move toward being able to fully sideline that [nasty gremlin inside my head](http://schmopera.com/on-the-ego/) during performance. Even in the past month there have been multiple times when, in performance, I've felt myself slip into that magic space where it seemed like I was really saying something, and people were really listening, and that was all that mattered. It doesn’t happen as often as you might think, and it feels great.

But is that feeling what the "passion" I'm following is all about? Is that what makes people get into this racket, and _stay in_?

In this [woefully simplistic article](http://elitedaily.com/money/entrepreneurship/10-things-that-truly-passionate-people-do-differently/?fb_action_ids=10101290683781257) on "Truly Passionate People" (which follows the unfortunate current trend of breaking down into 10 or fewer instructive bullet points the defining characteristics of "Happy People", "The Romantically Fulfilled" and other enviable categories of unicorn) the author states that the eponymous Pashies [my abbreviation!] – in addition to living "happier and better lives than the average individual" and "always think[ing] positively about the future" – "have a clear understanding of what [their] purpose in life is." (It also says they get up early in the morning, so that counts me out.)

There's a settled, contented tone in these proclamations that doesn't fit with my experience of being passionate about something. What does it really _mean_ to be passionate, and what kind of place can it/should it take in the life of a professional artist? For someone like me, any creation process or performance is a mixed experience. Even if I'm pleased at the end, and can manage to feel proud of what I've done, the action itself is inevitably full of the intense focus and _effort_ required to not only be honest and be beautiful, but to make it seem like it is all just pouring out of me of its own accord. Because ultimately the point of it all is for other people to have the experience of being fulfilled by the art, _not for me to_. And all this is characterized by a fundamental dissatisfaction with my work – something I am slowing learning to balance, by allowing more room to feel accomplishment – which is what drives me to improve.

Is that what passion is? The push to always try harder even when it’s rough and you _don’t_ feel satisfied and it seems like you'll never reach your goal because the goal is constantly moving just out of your reach?

The author of the aforementioned _Idiot's Guide to Pashies_ [my title!] says "[passions] make us feel that we’re on the right path in life and give us hope for a happy and exciting future."

It’s hard to argue with such a truism… but I will anyways. What bothers me about this kind of glib journalism is the same perceived preconception that makes me not want to talk about what I do with strangers. I often sense, underlying in such statements, a muddy equating of "passion" with that elusive and nebulous old beast "happiness." Happiness being the goal, passion being the road to it. Follow your passion, and it will lead you to happiness. Then you’ll just settle in there at the Happy Homestead and write articles about the Ten Things I Do Differently.

Again, I know this is unfair and reductionist, and that most people probably see passion closer to how I see it – as a driving force, a compulsion even, rather than as a direct line to happiness. What's held in common is that passion gives purpose. What’s different – and I don't think this is just semantics – is the implication that passion = meaning in life = happiness (= I feel happy! Yay! The End).

The truth (for me, anyways… every paragraph printed here should be prefaced by the disclaimer, "The views expressed below are only those of one disgruntled tenor") is that, although following my passion is responsible for some of the most exciting and rewarding moments of my life, it is also responsible for _far more_ tongue-biting-Why-Gawd-Why-screaming innocent-object-punching frustration. This is because, despite what you might hear on *The Voice*, "passion" is not something that _makes you feel good_. And that is precisely why it’s a such a force. To have passion in your life is to have the experience of seeing a problem or an incompleteness and not being able to NOT deal with it. It can pull you out of bed in the morning or keep you up at night because you feel like you'll go insane if you can’t address all the things that are left undone. Passion is the feeling of being *unfulfilled*, and trying to solve that.

In my case, as someone who interprets existing artistic creations, as well as producing my own, the passion my career is built around is the desire to communicate to other people something beautiful that is also representative of something true. It's kind of a mouthful to try to talk about it [witness: previous "sentence"], and it’s certainly a handful to try to do it, knowing it can never be perfect. It enrages me and it opens me up every single day to feeling like I’ll never be good enough. It _isn't_ that stereotypically cathartic process that we know from so many movies about artists (the concept of which, in my opinion, confuses _making_ art with what it's like to _experience_ great art) but, though I might say otherwise when I'm in the muck of it, I wouldn't have it any other way. Having a job that relates to one of my passions _does_ give me a reason to get up in the morning, and it does give my life direction, and the more people from different walks of life I meet, the more I realize how incredible and rare that is. And, bonus: I'm never bored!

Does this ring true to the way you experience passion? Am I just too sensitive and rarefied (I already know the answer to this)? Should I just shut up and play my cello? Let me know in the comments section!
