+++
author = ["authors/frank-pesci.md"]
categories = "Op-ed"
date = "2017-06-25T10:11:00-06:00"
lastmod = "2017-06-29T23:59:00-06:00"
preamble = "This is the final piece in a series of essays by composer and guest contributor Frank Pesci. In four installments originally published on [New Music Box](http://www.newmusicbox.org/articles/author/frank-pesci/), Pesci recounts his participation in Fort Worth Opera's [Frontiers](http://www.fwopera.org/operas/frontiers/) showcase, a major opportunity for emerging American composers. "
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498407454331/2017-06-25---Next.jpg.jpg"
publishDate = "2017-06-29T23:40:00-06:00"
related_articles = ["articles/fine-mess-composer-new-opera.md","articles/preparing-for-performance-what-i-didnt-know-i-knew.md","articles/the-big-and-everpresent-whats-next.md"]
related_companies = ["scene/companies/fort-worth-opera.md"]
short_description = "From the perspective of my relatively secure, European composer bubble, the amount of exposure I received between the announcement of, and participation in, Frontiers bordered on empowering and overwhelming, with a dash of terror for good measure. The response I received from audiences, colleagues, and the staff of Fort Worth Opera affirmed my Brand — &quot;I am becoming a better opera composer&quot; — for the foreseeable future."
slug = "the-big-and-everpresent-whats-next"
title = "The big, and ever-present, &quot;what&#039;s next?&quot;"
+++

I'm sitting at a bar two days after my Frontiers performance. It's a bar where the Frontiers composers spent many hours socializing and talking technique, plans, and projects. Now, I'm alone; most of my colleagues have left Fort Worth and I am waiting for the shuttle that will take me to the plane to begin my journey home.

As ESPN plays on the screen above me, I'm flipping through the small stack of business cards that I collected in the previous days. I'm also making a list of the names of people with whom I’ve been speaking, but who didn't have a card handy — Frontiers panelists, general directors, librettists. In a motion that has been well practiced during the last week, I reach for the interior jacket pocket that holds my business cards. I'm pleased to find only one remaining.

This is why I came. I came to meet people, to make connections, and to begin relationships with creative partners who are looking to build projects from the ground up. In my hands are the spoils of my experience at Frontiers.

## Post-show blues

I'm heartbroken that it's over, but by many accounts, my performance was a gigantic success. My singers — soprano Rachel Blaustein, tenor Brian Wallin, and baritone Alex DeSocio — were prepared, professional, flexible, and totally killed the performance both musically and dramatically. My music staff — conductor Stephen Dubberly, and pianist Matthew Stevens — dug into my score and found more than I had realized I had put into it.

The audience's response to my music was overwhelmingly positive, I think. I actually don't really remember the audience's response as it got wrapped up with my choreography. (Don't fall down the steps. Hug conductor. Shake pianist's hand, then male singer's. Kiss the soprano's hand. Don't knock over the stands or the microphones. Arms open wide to the audience and bow. Are my shoes tied? Yes they are! Drag it on as long as possible before the company bow…and we're done!)

The next morning involved a discussion with six members of the Frontiers panel, a group of decision makers from across the country who had also selected the pieces that were presented in the showcase. I scored points by describing the flexibility of the orchestration and casting options, being told that the absence of "preciousness" in my work and presentation (defined as a reluctance to let go and let collaborators in) was evident. I felt the warmth of comments regarding my lyricism, the balance of my vocal and piano writing, and the creativity of weaving Poe's poetry (what one panelist called "found material") into the libretto and the multiplying effect it had on character development. A review in the local paper said about my opera (which takes place in an mental institution), "…needless to say, you wouldn't want to be in this asylum – as either patient or caregiver." I'll take that as a positive.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498406901664/Frontiers2017-Everyone.jpg.jpg)
<figcaption>Everyone involved in the 2017 Frontiers Showcase at Fort Worth Opera.</figcaption>
</figure>

## The unseen impact

The day before my show, I went to a big-box grocery for a few items and gifts for my cast. And older woman waved me over to her to her checkout counter and we started talking, as strangers often do in this part of the country.

"Would you like to sign up for a rewards card?" No thanks, I live abroad.

"What brings you to Texas?" I'm here with the opera.

"What are you singing?" I'm a Frontiers composer.

This stops her in her tracks. "Isn't that fabulous! What else have you done? I'm a choral singer, do you have any choral music?" I have quite a bit (handing over my card) if you wouldn't mind giving this to your choir director.

She flips my card over in her hands and looks at me with wide eyes. "We HAVE done your music! It's WONDERFUL!"

She looks a little star struck, and wants to shake my hand. I mumble a bit, but give in to the serendipity of the situation, accept her praise, and thank her profusely for her kind words. Leaving the store, I start laughing. This has NEVER happened to me in over a decade of writing and I'm a little unsure what to make of it. The basic reality sets in that when I send things out, either through my publisher, through my online and social media interactions, or through rare opportunities afforded by exposure like I experienced at Frontiers, I welcome the ripples of interactions they produce, and am grateful that something I have done has reached a complete stranger.

I was struck by this again the day after my showcase, when I went to Dallas to attend the New Works Forum at the Opera America Conference. Walking into the room, I immediately started recognizing faces I had only seen online – general directors, Pulitzer winners, singers, directors, librettists — a who's who of leaders in the field. Everyone had their first names in large print on their ID badges, and I could see eyes darting towards my own as I walked around the room, trying to radiate maturity and positivity — or at least, not panic. Most moved on after glancing at my name badge, but a few stopped and came forward, saying that they had been at my show the previous night, or that they had seen my first essay on NewMusicBox two days before.

## Hin und zurück (There and back again)

From the perspective of my relatively secure, European composer bubble, the amount of exposure I received between the announcement of, and participation in, Frontiers bordered on empowering and overwhelming, with a dash of terror for good measure. The response I received from audiences, colleagues, and the staff of Fort Worth Opera affirmed my Brand — "I am becoming a better opera composer" — for the foreseeable future. But no matter how well things turned out (or at least appeared to), it's important for me not to believe my own "hype." What I'm really left with, in the end, is an opportunity.

In a previous incarnation of these essays, I mused that my goal would be coming home from Frontiers with more work than I could possibly handle. While this was a bit naïve, I do find myself with many avenues of communication on which I need to follow up, opera and non-opera projects that will keep me busy through the summer and fall. Just as important as understanding that opera is a collaborative art, opera is also a very slow burn. Projects develop over years, not months. The reality is that I put down roots during those two weeks in Texas, and every single one of them has the potential to develop into a new project. I just have to tend that garden. One win does not make a career, and a particular win does not necessarily mean I will be veering in the direction that win suggests. My immediate task is to kindle the relationships that I struck up, maximize the amount of time that I can spend on developing new projects, and be patient.
