+++
author = ["authors/erik-flaten.md"]
categories = "Review"
date = "2018-09-24T20:32:00-04:00"
lastmod = "2018-09-24T20:33:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537835215918/sqGLASSHANDEL6.jpg.jpg"
primary_image_credit = "Anthony Roth Costanzo in Glass Handel, costumed by Raf Simons for Calvin Klein. Photo by Dominic M. Mercier."
publishDate = "2018-09-24T20:32:00-04:00"
related_articles = ["articles/sky-on-swings-a-mustsee-of-o18.md","articles/brenda-rae-earns-her-ovation-in-o18-lucia.md","articles/racette-an-unmissable-elle-in-o18s-ne-quittez-pas.md","articles/counterculture.md"]
related_companies = ["scene/companies/opera-philadelphia.md"]
related_people = ["scene/people/anthony-roth-costanzo.md"]
short_description = "As the audience made their way to seats, there was a rising sense of tension. We had been informed at least six times that we would be moved around during this multimedia event. One had to question why there were so many disclaimers. Do we really want a stranger moving our chairs during a performance? Well, it turns out, yes we do."
slug = "the-astonishing-product-glass-handel-at-o18"
title = "The astonishing product: Glass Handel at O18"
+++

On Sunday night, a crowd gathered at The Barnes Foundation for a fusion of art, fashion, dance, film, and opera. The world premiere of this multi-faceted artistic experience took place at The Barnes Foundation, and it goes by the name *Glass Handel*. Produced by countertenor [Anthony Roth Costanzo](/scene/people/anthony-roth-costanzo/) and several others, including [Opera Philadelphia](/scene/companies/opera-philadelphia/), *Glass Handel* is a triumph of opera entrepreneurship. 

As the audience made their way to seats, there was a rising sense of tension. We had been informed at least six times that we would be moved around during this multimedia event. One had to question why there were so many disclaimers. Do we really want a stranger moving our chairs during a performance? Well, it turns out, yes we do. To be moved around so as to gain different perspectives via performance artist Ryan McNamara's system of "People Movers" is a critical factor in the accomplishment of the entire work. People Movers, who later are understood as performance artists, allowed patrons to see, hear and watch all aspects of Costanzo's creation by pushing them around in their chairs in a comfortable, efficient and smooth fashion.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537835301628/GLASSHANDEL8.jpg.jpg)
<figcaption>Anthony Roth Costanzo in *Glass Handel*. Photo by Dominic M. Mercier.</figcaption>
</figure>

The featured artists in *Glass Handel* are all of the highest caliber in their fields, including painter George Condo, and Tony Award-winning choreographer, Justin Peck. Those who were fortunate enough to acquire a ticket to this exclusive event are rewarded with unsurpassed performances from a wide range of disciplines. One does not need to be an expert in any area to appreciate the first-rate work that is being done. One of the greatest and most rewarding highlights comes at the very end, when the audience beholds a brand new Condo painting, which he created in front of their eyes, in real time.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537835309922/GLASSHANDEL2.jpg.jpg)
<figcaption>Ricky Ubeda in *Glass Handel*. Photo by Dominic M. Mercier.</figcaption>
</figure>

At the center of the night, both literally and figuratively, is Anthony Roth Costanzo. As all of the various art swirls around him, Costanzo sings through nine selections by Glass and Handel from his recently released solo album, [*Arc*](https://anthonyrothcostanzo.com/ARC). After witnessing him perform live, it is easy to see why he has found such great success. Costanzo sings with his entire soul exposed. His sound is always clear and rich, even in the most delicate moments. He shapes every musical thought exquisitely. While there is much to be said about the greatness of Costanzo's singing, his most impressive feat of the night is the mere fact that he made it all happen. His effort to mount this multimedia event was highly collaborative, and acquired several avenues of support, but Costanzo was its catalyst and primary fundraiser. *Glass Handel* is not only an exciting and colorful presentation of great music, but also a superb example of Costanzo's well-known work ethic and creative spirit.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537835315741/GLASSHANDEL1.jpg.jpg)
<figcaption>Anthony Roth Costanzo in the world premiere production *Glass Handel* at The Barnes Foundation. Photo by Dominic M. Mercier.</figcaption>
</figure>

Conductor Corrado Rovaris led two separate orchestras, one for the Philip Glass works and another baroque ensemble for the Handel. Both groups played with great energy and clarity and the balance between large ensemble and Costanzo was perfect. We hope that more Philip Glass will be in Opera Philadelphia's future, as Rovaris and the musicians showed a great affinity for the American minimalist composer. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537835322089/GLASSHANDEL10.jpg.jpg)
<figcaption>George Condo paints live at *Glass Handel*. Photo by Dominic M. Mercier.</figcaption>
</figure>

Unless you happen to have a spare $350, you're better off attending *Glass Handel* at The Cathedral of Saint John the Divine in November, for a more affordable $75. There is currently nothing else like this production, and after realizing the amount of work and fortuitous timing it required, I am fairly certain that it will be some time before we see anything like it again. As Costanzo says in his notes, creating this production took, "equal parts luck and sweat." If you can afford it, get a ticket and see the astonishing product of Costanzo's luck and sweat.

>*Glass Handel* runs through September 30. For details and ticket information, [click here.](https://www.operaphila.org/whats-on/on-stage-2018-2019/glass-handel/)
