+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2015-04-11T19:33:00-04:00"
lastmod = "2015-04-11T19:33:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428795159692/IanBostridge_Fotor.jpg.jpg"
publishDate = "2015-02-12T09:33:00-05:00"
related_articles = ["articles/roxanna-walitzki-exquisite-corpse.md"]
short_description = "​I spotted a strange review in the Washington Post by Anne Midgette, on Ian Bostridge&#039;s performance of Winterreise at the Library of Congress. I was misled by a clickbait-esque headline (not Anne&#039;s): &quot;&#039;Ian Bostridge Is Not A Classical Singer&#039; Says Anne Midgette&quot;."
slug = "the-art-of-defining-a-singer-and-squashing-anomalies"
title = "The Art of Defining a Singer and Squashing Anomalies"
+++

<p>
	I spotted a <a href="http://www.washingtonpost.com/entertainment/music/tenor-ian-bostridge-performs-a-compelling-rendition-of-winterreise/2015/02/08/643ae528-afae-11e4-886b-c22184f27c35_story.html" target="_blank">strange review in the Washington Post</a> by Anne Midgette, on Ian Bostridge's performance of <em>Winterreise</em> at the Library of Congress. I was misled by a clickbait-esque headline (not Anne's): <a href="http://www.artsjournal.com/2015/02/ian-bostridge-is-not-a-classical-singer-says-anne-midgette.html" target="_blank">"'Ian Bostridge Is Not A Classical Singer' Says Anne Midgette"</a>.
</p>
<p>
	The review itself isn't out of the ordinary. There are, however, some troubling paragraphs:
</p>
<figure data-type="quote">
<blockquote>
	Ian Bostridge is not a classical singer. Yes, he's a tenor, and what he does is vocal performance, and it's strikingly compelling. But classical singers produce sound in a certain way, with a certain kind of vocal support and certain accepted wisdoms about sound and line and diction. Bostridge, by contrast, comes at singing from entirely his own direction and arrives at his own unique conclusions and results.<br>
	
</blockquote>
</figure>
<p>
	I'm surprised Anne used this argument to basically make the point that she doesn't think he's comparable to Gerald Finley. She'd be hard pressed to find two people who give the same definition of a "classical singer". She also seems to be saying Bostridge's autonomy excludes him from the (Anne's) ranks of classical singers. She goes on:
</p>
<figure data-type="quote">
<blockquote>
	Bostridge has a considerable vocal technique to be able to sing "Winterreise's" 24 songs and show no more strain in the last song ("Der Leiermann," the organ-grinder) than the first ("Gute Nacht," good night). But his singing comes from his head, in more ways than one. Hearing it, you sense that rather than being supported from the diaphragm, it is controlled from above, on invisible marionette strings, one effect succeeding another as products of an active, slightly gothic imagination, not always entirely connected to his skinny body as it gyrates nervously around the piano.<br>
	
</blockquote>
</figure>
<p>
	This is the kind of mean, irrelevant criticism, written by people who do not make music for a living, that today's classical music scene simply does not need. There are broke artists everywhere, and so the concert scene (just like the opera scene) has begun to adapt to the fact that only the creative survive. Basically, a critic should be the first one to notice that individuality is invaluable in today's live entertainment, instead of taking shots at Bostridge's perceived oddities. It feels similar to the cool kids who make fun of the uncool kids for reading books.
</p>
<p>
	The real question that came to mind upon reading Midgette's review is this: if the definitions of classical music performances are changing, shouldn't that extend to the classical singers? If singers train for projection and stamina, isn't it because they're going to sing in a 2000-seat theatre? Wouldn't a savvy artist be adaptable to their performance space, and not sing with all they've got just because they can? Isn't singing supposed to be a heightened form of speech, anyway? Don't singers always strive to <em>communicate</em>, not just "produce sound"?
</p>
