+++
author = ["authors/camille-holland.md"]
categories = "Op-ed"
date = "2016-08-04T10:40:00+01:00"
lastmod = "2016-08-11T10:22:00+01:00"
preamble = "This is a guest post by contributor [Camille Holland](/scene/people/camille-holland/). Read the original post on her blog, [The Short-haired Soprano](http://www.camilleholland.ca/blog/the-anxious-singer-10-tips-to-help-with-anxiety-in-audition-and-performance)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1470488392025/2016-08-06---Anxiety.jpg.jpg"
publishDate = "2016-08-11T10:22:00+01:00"
related_articles = ["articles/the-introverts-opera.md","articles/the-opera-party-monologue.md","articles/spotlight-on-stephanie-tritchew.md","articles/networking-for-introverted-performers.md","articles/i-didnt-get-in-a-short-story-about-clarity.md","articles/anxiety-art-and-purpose.md"]
related_people = ["scene/people/camille-holland.md"]
short_description = "This is why I have written down my Top 10 Tips for dealing with an anxiety disorder as a singer: to give a little bit of help to those who, like me, deal with anxiety on a daily basis, and also their colleagues/family/support system who wish to understand them a little better."
slug = "the-anxious-singer-10-tips-to-help-with-anxiety"
title = "The anxious singer: 10 tips to help with anxiety"
+++

Hello! My name is Camille and I have Generalized Anxiety Disorder.

After my diagnosis about a year ago, I started to look into the hows and whys of clinical anxiety. Here is a brief summary of what I've found so far:

- According to the National Institute of Mental Health, an estimated 18.1% of adults in the United States are affected by anxiety disorders ([link](http://www.anxietycentre.com/anxiety-statistics-information.shtml)).  Here in Canada, the Anxiety Disorders Association of Canada states"the 12 month prevalence for any anxiety disorder is over 12% and one in four Canadians will have at least one anxiety disorder in their lifetime" ([link](http://anxietycanada.ca/english/pdf/kirby.pdf)).
- There are several different types of anxiety disorders, including but not limited to Generalized Anxiety Disorder (GAD), Obsessive Compulsive Disorder, Social Anxiety Disorder, Post Traumatic Stress Disorder, and Major/Persistent Depressive Disorder
- Anxiety and Depression often go hand in hand ([link](http://www.adaa.org/about-adaa/press-room/facts-statistics))
- "The causes of anxiety disorders aren't fully understood. Life experiences such as traumatic events appear to trigger anxiety disorders in people who are already prone to anxiety. Inherited traits also can be a factor." ([link](http://www.mayoclinic.org/diseases-conditions/anxiety/symptoms-causes/dxc-20168124))
- In evolutionary psychology, anxiety disorders are thought to be remnants of a once useful evolutionary trait (constantly looking out for danger). Put into a modern society this trait becomes excessive and disruptive, which is why GAD can be thought of as an "unsuccessful search for safety." ([link](http://www.ncbi.nlm.nih.gov/pmc/articles/PMC3181631/))

This is just the very tip of the iceberg for research being done on clinical anxiety. Though all interesting, the most important thing to realize is this: even if you are not personally affected with an anxiety disorder, you almost certainly know someone who is.

This is why I have written down my Top 10 Tips for dealing with an anxiety disorder as a singer: to give a little bit of help to those who, like me, deal with anxiety on a daily basis, and also their colleagues/family/support system who wish to understand them a little better.

## 10. Routine, Routine, Routine

There are few things that I've found more helpful than figuring out what routine works for me before an audition or show and - this is key - ACTUALLY DOING IT. This can be anything. Go running, watch Netflix, have a nap, go shopping, read a book, do origami, go over your music/stage directions (a good idea for everyone, tbh), take pictures of birds, plan your dream trip around the world, don't talk to anyone, talk to everyone, have a solo dance party in your apartment or hotel room. Anything!

If you haven't quite figured out the magic formula that works for you, I offer these simple questions to help get you there:
When during the day are you the least anxious, and when are you the most anxious?
Which activities ease your anxiety, and which increase your anxiety?
What, for you, is the most anxiety-inducing part of performing/auditioning, and what is the least? (Be very specific)

Write down your answers to these questions and from there you should have a clearer idea what your brain and body need to get through a gig. If not, that's OK! Just keep experimenting with different things and eventually you will figure out what works for you. This may also change over time, so always be aware of the signals your body is sending you. The most important thing is to be specific about your needs and to follow through with them.

## 9. Do Your Research

This refers to anything that needs preparation, including hiring a pianist, checking out the best way to get from your hotel to the venue, researching the people in charge of your gig, and (if it's for an opera) knowing what the other characters are doing in your scenes. These are just a few examples. With any singing gig or audition there are a flobbity-jillion things to think about, and anxiety can make it feel simply overwhelming.

If you do your research and know what to expect, it lessens the need for your anxiety to kick into gear. That way, when unexpected complications arise (and they will), you won't already be overwhelmed by the things you could have prepared for.

## 8. Bring Music to Listen To

This is one that I find particularly helpful. To be clear, this DOES NOT refer to recordings of your rep, but rather non-performance related music that you find calming. This could be any genre of music. Just think about what you really enjoy listening to that has nothing to do with your singing, bring it with you, and make sure your device is charged. As musicians we already understand the incredible psychological power that music holds, so we may as well make use of it!

## 7. Self-care

Take time for yourself. That's it. Practice self-awareness and take however much time you need to feel grounded. Put it into your pre-gig routine and stick to it.

Your self-care activity must be quiet and calming, which is why it's separate from \#1. I find breathing exercises to be helpful. Some people might want to take a bath, read, or do yoga. Meditation has enjoyed a burst of popularity lately, so below is a simple meditation exercise to follow.

- Find a quiet room where you will not be distracted or interrupted
- Set a timer for 3, 5, 10 minutes, or whatever length of time you would like (remember, longer doesn't necessarily mean better)
- Sit or lay down in a comfortable position and close your eyes
- Take 5 deep breaths, and then settle your breathing to its natural rhythm
- Focus on your inhale and exhale. Say the corresponding word in your mind if you find it helpful
- If you become distracted by other thoughts, no worries! When you notice this has happened just bring your mind back to your breath
- Remember that meditation takes a while to get used to
- When the timer goes off, slowly open your eyes and return your mind to the outside world
- Pat yourself on the back for being awesome and taking time for yourself!

If you find meditation to be a little daunting, here's a helpful video about its true ease and accessibility:

<figure data-type="video">
<iframe width="501" height="312" src="https://www.youtube.com/embed/LmLyHaHDqks" frameborder="0" allowfullscreen></iframe>
</figure>

## 6. Be Early

This one may seem obvious, but being late is one of the easiest ways to make your anxiety skyrocket. Being right on time is no better since it still doesn't leave you any time to settle. I find if I'm at the venue at least 15 minutes before I'm required to be there, the world is a nicer place. Keep in mind that if you need to change or do your makeup when you arrive this will add to your time. Give yourself 15 extra minutes of nothing to help center your mind and body.

## 5. Have an Extra of Everything Important

This refers to items that would be difficult or impossible to quickly replace, like sheet music, your outfit and shoes, and your resume/bio/headshot. Always have several copies of your materials and at least one extra copy of your sheet music kept in a separate place (this may seem like a lot, but bags get stolen, stuff gets lost, and it's better to be prepared than without music). In addition, it's always a good idea to have copies online just in case (ie. Google Drive or Dropbox).

As for clothing and shoes, this depends on how much room you have left in your luggage or carry-on. Spills, rips, and broken heels happen, no matter how careful you are. I recommend bringing an extra of whatever you think are the most vulnerable parts of your outfit. In my opinion, for men that would be ties and dress shirts, and for women blouses, jewellery, and heels.

And as always, keep all important objects in your carry-on. Airlines are not to be trusted with luggage, especially for overseas travel.

## 4. DO NOT PACK THE DAY OF

Just don't do it. Seriously. I don't think I need to explain why.

## 3. Make Lists

One symptom of Generalized Anxiety Disorder is "difficulty concentrating, or the feeling that your mind 'goes blank'" ([link](http://www.mayoclinic.org/diseases-conditions/generalized-anxiety-disorder/basics/symptoms/con-20024562)). This method may not work for everyone, but I've found it invaluable for keeping me on track. Making packing lists, travel info lists, contact lists, etc... will ensure that you're as prepared as possible, and thus help to minimize anxiety flare-ups.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1470303676557/img-20160728-183554.jpg%3F279)
<figcaption>The list board in my home office.</figcaption>
</figure>

## 2. Breathe

This one goes with #7, but is so important that it needed its own category. Anxiety comes with a long list of physical "side-effects", but the one most detrimental to singers is its effect on breath. When anxiety is heightened, breathing can become rapid and shallow which lessens a singer's connection to their physical support system.

If you find this happening before you need to sing, sit down wherever you can (quiet space or not), close your eyes, and focus on deep belly breaths (inhaling so the belly extends out and contracts in). Count to 3 on the inhale and 3 on the exhale for the first few cycles, then incrementally increase the count until you reach your limit.

Belly breathing is a way to intentionally shift your body to a state of calm. It does this by "[increasing] the supply of oxygen to your brain and [stimulating] the parasympathetic [rest and digest] nervous system..." (link)

## 1. Ask for Help

This is helpful for everyone, and absolutely key for people dealing with anxiety disorders. Whenever you may be unsure of where to go or what to do, just ask someone around you. Either they'll be able to help or they'll be just as lost as you, both of which are a win.
