+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = 2021-08-22T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "For full details on Tête à Tête's 2021 Opera Festival, check out [their line-up](https://www.tete-a-tete.org.uk/festival/tete-a-tete-the-opera-festival-2021/)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1629681106/media/2021/08/TeteaTete2021_ee3rxz.jpg"
primary_image_credit = "Red Gray in The Unravelling Fantasia of Miss H, by Red Gray and Sarah Nicolls, part of Tête à Tête The Opera Festival, 2021. Photo by Claire Shovelton."
related_articles = ["articles/talking-with-singers-heloise-werner.md", "articles/tete-a-tete.md", "articles/tete-a-tete-at-home-a-sampling.md"]
related_companies = ["scene/companies/tete-a-tete.md"]
related_people = ["scene/people/lore-lixenberg.md"]
short_description = "As ever, I was truly inspired by the creativity of the artists in the line-up this season at Tête à Tête; they never fail in their curation of and encouragement for any and all work that lies outside the realm of the traditional. "
slug = "new-inventions-app-eras-at-tete-a-tetes-2021-opera-festival"
title = "New inventions & app-eras at Tête à Tête's 2021 Opera Festival"
youtube_url = ""

+++
The [Tête à Tête](/scene/companies/tete-a-tete/) Opera Festival returned this month for its [14th season](https://www.tete-a-tete.org.uk/festival/tete-a-tete-the-opera-festival-2021/). As always, the programme was varied and wide reaching, ranging from projects in their earliest stages, to complete works. Audiences are offered a panoply of options whether they choose to attend in person or via interactive broadcast. In a very clever move, Tête à Tête has begun to offer live broadcasts of many of the shows in their line-up this season, a solution that sprung from the need to adapt during the COVID-19 pandemic last year. The broadcasts allow for anyone to engage with these performances and more than ever before, have enabled artists to experiment with a more digital approach.

This month, I was lucky enough to catch three of these broadcasts, each of which presented an entirely contrasting types of opera each in a different stage of its development. In common they all had the aspiration for storytelling and community building, and they all shared the infectious joy that live performance sparks.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629674923/media/2021/08/TeteaTete_WhileTheresLight_2_ClaireShovelton_icwuou.jpg){{% /md %}}

<figcaption>Rosie Middleton and Mark Sanders (background) in While There's Light, part of Tête à Tête The Opera Festival, 2021. Photo: Claire Shovelton.</figcaption>

</figure>

First up was [_While There's Light_](https://www.tete-a-tete.org.uk/event/while-theres-light-ib/), a work-in progress presentation by composer Sarah Sarhandi and librettist Vincent Katz based on Katz's English translations of the love poems of 1st-century BCE Roman poet, Sextus Propertius. Sarhandi's score is classically structured but draws on dance music and makes use of drums and electronics. This, paired with her own voltaic viola playing, provided a pulsating, trancelike opening instrumental sequence.

The piece featured three distinct voices pulled from Sextus' writing: Propertius, Cynthia, and Apollo. These roles were sung by tenor [Ebe Oke](/scene/people/ebe-oke/), and mezzo-sopranos [Rosie Middleton](/scene/people/rosie-middleton/) and [Loré Lixenberg](/scene/people/lore-lixenberg/), respectively. Sextus frequently wrote in the first person and most often about his relationship with a woman called Cynthia, thought to be a reference to the god Apollo. Unlike a traditional opera, there was no direct dialogue between the characters: each performer was given a microphone and a single spotlight, each bringing a unique quality to the performance which reflected the meaning behind the text and allowed for the words to wash over the audience without distraction.

The poetry felt surprisingly modern considering it was written some two thousand years ago and somehow still feels very relevant to life today. Katz's translations had a dreamlike quality; an ebb and flow that generated beautifully fragranced, but hazy images. Sarhandi’s music, chantlike and uncomplicated, did everything to highlight the text and draw out its meaning without dominating. It will be interesting to see how the opera, which is so steeped in this text, will morph and change along the way as it develops into its full fledged conformation.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629674931/media/2021/08/TeteaTete_WhileTheresLight_1_ClaireShovelton_hrj8c3.jpg){{% /md %}}

<figcaption>Loré Lixenberg and Mark Sanders (background) in While There's Light, part of Tête à Tête The Opera Festival, 2021. Photo: Claire Shovelton.</figcaption>

</figure>

Next was Loré Lixenberg’s new app-era, [_SINGLR_](https://cockpitdirect.gn.apc.org/show/singlr). Part browser-based app, part opera, part live-testing event, _SINGLR_ is a love-letter to extended vocal technique. Though still in its early stages as a functioning app, the concept for _SINGLR_ has been buzzing around in the mind of Lixenberg for quite some time. As a specialist in extended vocal technique, she was looking for a way for people to connect in a genuine way through the use of their voices. The result was the app, SINGLR. Much like the well-known dating apps Tinder and Grindr, the app would allow users to create a profile for themselves and then meet and chat to other singles. The difference is that the profile would be made up entirely by your recorded voice – no photos, no write up – just the voice.

The initiatory performance presented by The Voice Party and Tête à Tête, was an experimental first-time meeting for this group of _SINGLR_ users. The performance featured two live in-person performers sitting face-to-face and communicating through sound as if they were speaking through the app. There was also another live performer who was communicating to her partner through a laptop, the screen of which was projected for the audience. There was also a third pair who were connecting via Zoom and being streamed live for the audience in the room. All of this created a cacophony of sound which shifted and morphed as naturally as spoken conversation. The mix of live and virtual performers was a part of creating a COVID-19-safe environment but was also the vehicle for a distinctive texture to the soundscape with the combination of live and digital sounds.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629675370/media/2021/08/TeteaTete_Singlr_1_ClaireShovelton_i2pb1w.jpg){{% /md %}}

<figcaption>Loré Lixenberg in SINGLR, part of Tête à Tête The Opera Festival, 2021. Photo: Claire Shovelton.</figcaption>

</figure>

This was a true embracing of the digital and a commentary on our ability to connect genuinely with one another. Social media and dating sites tend to show us filtered, edited versions of each other. With _SINGLR_, the connection is one based on communication; "speaking" in a voice that is uniquely your own and carefully listening to the other persons responses to be in play with each other.

For those who would like to try out _SINGLR_, it is your opportunity to share who you are through your voice, and you are encouraged to allow your true self to shine through. The SINGLR app is in the process of being developed now with more live performances on the horizon. Anyone interested in the app, is welcomed to get in touch.

The final piece was [_The Unravelling Fantasia of Miss. H_](https://www.tete-a-tete.org.uk/event/the-unravelling-fantasia-of-miss-h-live/), an opera with music and words by Red Gray and Sarah Nicolls which tells the story of real-life historical figure Mary Frances Heaton who was arrested over a dispute with an Anglican priest. She was taken to court where she was deemed a "lunatic" and sentenced to a lifetime of confinement at Wakefield Asylum.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629675395/media/2021/08/TeteaTete_Singlr_2_ClaireShovelton_s5snmw.jpg){{% /md %}}

<figcaption>Loré Lixenberg (background) in SINGLR, part of Tête à Tête The Opera Festival, 2021. Photo: Claire Shovelton.</figcaption>

</figure>

This opera was perhaps the closest I've seen to "finished product" at this festival. It appeared to be very well rehearsed and fully realized. The story was told simply, with very little in the way of prop or set but done in a very physical, choreographed, all-hands-on deck way by the three performers on stage. This created an entirely convincing storytelling environment which had me hooked for the full length of the piece.

The focal point of the piece was Sarah Nicolls' one-of-a-kind piano invention which almost needs to be seen to be believed. A baby grand piano with the lid removed to expose the strings, suspended upside-down held in place by some very clever contraption on wheels. The keyboard was flipped so that it could be played by someone sitting or standing upright. The piano became the main set piece, the entire orchestra, and even its own character in the story. It was rolled around the stage, knocked on, stroked to create a whole world of unconventional sounds, and in a very impressive move, was set swinging wildly on its stand while being played.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629675218/media/2021/08/TeteaTete_MissH_1_ClaireShovelton_eq72o5.jpg){{% /md %}}

<figcaption>Sarah Nicolls as Mary Matthewson in The Unravelling Fantasia of Miss. H, part of Tête à Tête The Opera Festival, 2021. Photo: Claire Shovelton.</figcaption>

</figure>

But perhaps the true heart of this piece was the sensitive heart-wrenching performance by Red Gray in the role of Mary. She was fully integrated into this role in an impressive acting feat. She so completely embodied the character it was impossible not to empathize with her plight. Gray's somewhat reedy voice felt like an extension of Mary Heaton rather than a voice imposed upon the character. The music was quite traditional in form and perhaps a little simplistic but suited the storytelling perfectly. It was a welcomingly fresh and honest approach to opera.

Throughout the performance, pieces of embroidery were revealed on Mary's dress to the point where embroidery threads were being pulled from all over her dress, turning the costume – and Mary herself – into a living art installation. Mary Frances Heaton became known for her embroidery samplers, a few of which are still surviving today. They were her means of telling her story and holding onto her memories. The beautiful embroidery done on the costume for this piece were a visual representation of Mary's mind, and the meaning that the thread held for her. The reverence and attention this traditionally female craft was given, elevated this piece beyond opera.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629675171/media/2021/08/TeteaTete_MissH_2_ClaireShovelton_gdjiyi.jpg){{% /md %}}

<figcaption>Red Gray as Mary Frances Heaton in The Unravelling Fantasia of Miss. H, part of Tête à Tête The Opera Festival, 2021. Photo: Claire Shovelton.</figcaption>

</figure>

As ever, I was truly inspired by the creativity of the artists in the line-up this season at Tête à Tête; they never fail in their curation of and encouragement for any and all work that lies outside the realm of the traditional. It is a wonderful reminder that even in these difficult times for opera, the cogs of creativity are still turning. The ability to engage with these works is now more important and more necessary than ever.