+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = 2020-09-25T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Items on the Tête à Tête Opera Festival line-up are still [available for online viewing](https://www.tete-a-tete.org.uk/festival/2020-festival-whats-on/). Yay!"
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1601057690/media/2020/09/sqTAT_yovlfo.jpg"
primary_image_credit = "Lars Fisher as Mr. Williams in The Trilobite, Or The Fall of Mr Williams, Tête à Tête Opera Festival, 2020. Photo: Claire Shovelton."
related_articles = ["articles/angel-s-bone.md"]
related_companies = ["scene/companies/tete-a-tete.md"]
related_people = ["scene/people/cn-lester.md", "scene/people/peter-edge.md", "scene/people/anna-prowse.md", "scene/people/lars-fischer.md", "scene/people/lore-lixenberg.md", "scene/people/anna-braithwaite.md"]
short_description = "These are strange times, and I am still not convinced that going virtual is the way. Has it afforded us some opportunities we would not have had otherwise? Sure. Has it required us to get creative in ways we could not have imagined? Certainly."
slug = "tete-a-tete-at-home-a-sampling"
title = "Tête à Tête at home: a sampling"
youtube_url = ""

+++
I was able to catch a few live broadcasts from the [Tête à Tête festival](https://www.tete-a-tete.org.uk/festival/2020-festival-whats-on/) this season from the comfort of my own home over past week. While I feel that there can no replacement for live theatre, it was a real treat to skip the commute and the crowds. Tête à Tête deserve commendation for their dedication to putting the festival on this year, continuing to bring new theatre works to their audience as they do every summer.

Of course, the programme had to be somewhat adapted to make allowances for COVID-19 restrictions and proper social distancing measures. This required some inventive re-working of pieces, reducing the number of live performers (and audience members) in the theatre, and making use of Zoom with all of its versatility. Most crucially, it included live broadcasts of all of the pieces on the festival bill, making the programme accessible to all.

The programme of over 50 events taking place over a span of two weeks felt thematically harmonious as we all begin to reflect on the utter weirdness the pandemic has landed us in through the making, watching, and performing of art.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1601057803/media/2020/09/TAT-Persephone-Shovelton_bhr8i5.jpg){{% /md %}}

<figcaption>Anna Braithwaite (Persephone/Singer) and Clare O’Connell (Chimera/Cellist) in Persephone's Dream, Tête à Tête Opera Festival, 2020. Photo: Claire Shovelton.</figcaption>

</figure>

Now, more than six months into COVID and this altered way of life, we are beginning to see the fruits of some of these reflections. [_Persephone’s Dream_](https://www.tete-a-tete.org.uk/event/persephones-dream/), a digital/live hybrid opera is one of these reflections. Born out of the pandemic from the mind of Tania Holland Williams, the opera uses the character of Persephone as a reference point, transporting us to her underground dream world. It tackles all of the emotions (good and bad) around the pandemic head on and reflects on feelings of isolation, the quieting of the world, and the return to nature. It poses the question, “If the dream is so good, why wake?”. Why indeed.

> Fischer is the only performer on stage but gives a dramatic and thoroughly convincing performance all on his own. 

This project was a truly collaborative effort. Holland Williams wrote the libretto and then enlisted the talents of Gavin Alexander, Kevin Grist, and [Anna Braithwaite](/scene/people/anna-braithwaite/) for the music. Braithwaite performs the role of Persephone on stage and is joined by cellist Clare O’Connell who in addition to her beautiful playing, voices the character of Chimera. They are accompanied by a "Chorus of Curious Eyes" projected on screen, streamed live over Zoom.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1601057890/media/2020/09/TAT-BIRD-1-Shovelton_gdblbs.jpg){{% /md %}}

<figcaption>Lore Lixberg in BIRD, Tête à Tête Opera Festival, 2020. Photo: Claire Shovelton.</figcaption>

</figure>

In a time when connecting with other humans creatively has become a technical challenge and real-life meetings are fraught with risk, this purpose-made piece was surprisingly cohesive. With costume, set, and Zoom background design from Sarah Jane Booth, the piece had a fully realized aesthetic. The Chorus who appeared on zoom felt purposeful and added a layer to the piece that would have been lacking without them. It was all-round very thoughtfully done and was the successful culmination of many people coming together to create something that made meaning of our current situation and gave cause for some much-needed sharing and reflection.

Two of the other pieces I saw were similar in that they had to be adapted for a socially distanced and virtual-friendly performance setting but also shared a common musical language that was based heavily on electronics and field recording samples. They are Lore Lixenberg’s [_BIRD_](https://www.tete-a-tete.org.uk/event/bird/) and Elfyn Jones’ [_Trilobite, Or the Fall Of Mr. Williams_](https://www.tete-a-tete.org.uk/event/the-trilobite-or-the-fall-of-mr-williams-interactive-broadcast/). _BIRD_ is a 30-minute piece with concept, composition, and performance by mezzo-soprano [Lore Lixenberg](/lore-lixenberg-is-the-mother/). The core of this piece is a film made up of both found and recorded images and clips featuring birds. It is sometimes utterly bizarre and sometimes soothingly Attenborough-esque.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1601057920/media/2020/09/TAT-Trilobite-Shovelton_nf0tnk.jpg){{% /md %}}

<figcaption>Lars Fischer in The Trilobite, Or The Fall of Mr Williams, Tête à Tête Opera Festival, 2020. Photo: Claire Shovelton.</figcaption>

</figure>

Lixenberg, alone on stage with her microphone and laptop layers her voice over the film while a drama is being played out on screen. We witness a man transforming into a bird. In the last 10 minutes of the piece, Lixenberg herself is changed as well through her bird-like vocal explorations. For me, the piece was an interesting exploration into the lives of these wonderful, feathered creatures so famous for their song. In it was the joy of allowing yourself to be taken over by something strange and inexplicable. Originally, the piece would have featured live dancers on stage as well as violin, accordion, and electronics and so it was shown at Tête à Tête in a greatly reduced capacity. That being said, the core of the piece for me is definitely the film and though I enjoyed it, I doubt that an unrestricted performance would have made any real difference where it was concerned. Conceptually, this piece is really interesting, and I think it has a lot of room to grow.

> As this consciousness begins to remember its past, individual voices cry out and The Mind starts to crack.

Elfyn Jones’ _Trilobite, Or the Fall Of Mr. Williams_ is the third and final piece in a triptych of "sonoperas". The idea here is that the piece is built from field recordings Jones took (in this case) on Exmoor. The sounds – chipping at rock, waves, windshield wipers etc, all form the bedrock for the piece on top of which the score is composed. The story of this piece is told in flashback in the seconds it takes the unfortunate geology teacher and trilobite enthusiast Mr. Williams to fall off a cliff. Tenor [Lars Fischer](/scene/people/lars-fischer/) plays the role of Mr. Williams and is accompanied over zoom in pre-recorded video by mezzo-soprano [Anna Prowse](/scene/people/anna-prowse/) and baritone [Peter Edge](/scene/people/peter-edge/) who play the angels who attend him and various other characters from his memory.

Of all the pieces I heard over the course of the festival, this one is the most traditional in sound and structure. Fischer is the only performer on stage but gives a dramatic and thoroughly convincing performance all on his own. The visuals on screen depicted through various Zoom backgrounds, and outdoor locations along with the electronic soundscape assist in setting a scene very effectively. This is a piece that takes advantage of technology in place of a set and costuming and does so very capably.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1601057945/media/2020/09/TAT-WSIS-Shovelton_n84lzz.jpg){{% /md %}}

<figcaption>CN Lester in We Sing/I Sang, Tête à Tête Opera Festival, 2020. Photo: Claire Shovelton.</figcaption>

</figure>

Leo Doulton’s improvised piece _We Sing/I Sang_ takes interactive to the next level with audience participation not only being encouraged but crucial to the piece. Live audience members were asked to send in their responses to the questions being posed to them on their devices over the course of the performance. These responses directly impact the direction the performers take on stage and essentially change the outcome of the piece. In a world where the norm is for cell phones to be kept on silent and out of sight and for audience members to be quiet observers, this piece welcomes them to weigh in and take an active role in the shaping of the work, blurring the space between audience and performer.

_We Sing/I Sang_ featured Hannah Gardiner on viola and [CN Lester](/scene/people/cn-lester/) on vocals. Leo Doulton performed a series of improvised movements in the style of Japanese Noh Theatre which was informed by both the audience’s selections and the musical language that Hannah and CN were creating in the space. Conceptually, I really liked this piece. A collective consciousness called "The Mind" has risen in a post-apocalyptic world but as this consciousness begins to remember its past, individual voices cry out and The Mind starts to crack. Part improvised opera, part ritual, this piece feels timely and oddly familiar. I only wish it could have been more realized aesthetically.

I always enjoy the adventure of Tête à Tête. I never quite know what to expect and I always leave feeling pleasantly surprised, uplifted, and inspired by the performances I have seen. I really admire the importance they place on giving artists free reign with their projects and promoting theatre that may not otherwise have a home. This season was particularly difficult for theatre makers everywhere but Tête à Tête deserve special credit for doing it anyway. These are strange times, and I am still not convinced that going virtual is the way. Has it afforded us some opportunities we would not have had otherwise? Sure. Has it required us to get creative in ways we could not have imagined? Certainly. But I am looking forward to the time when we will once again be able to partake in theatre and music making live and without restriction.