+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-11-25T13:17:00+00:00"
lastmod = "2016-12-13T09:37:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1481475651083/2016-12-11---Roses.jpg.jpg"
publishDate = "2016-12-13T09:15:00+00:00"
related_articles = ["articles/spotlight-on-danielle-buonaiuto.md","articles/moving-stories-as-one-at-chicago-fringe-opera.md"]
related_people = ["scene/people/breanna-sinclaire.md"]
short_description = "&quot;I was a very high tenor,&quot; she says, even recalling many conversations with her mentors and peers about pursuing a career as a countertenor. On a daily basis, Sinclairé &quot;always had this debate with myself&quot; about how to train her voice; though not an easy decision to make, there was at least one simple truth to the matter: &quot;I never felt comfortable playing tenor roles.&quot;"
slug = "tenor-mezzo-transition"
title = "From tenor to mezzo: one singer&#039;s path through gender transition"
+++

Though their sounds may seem drastically different, the physical differences in the instrument of the highest soprano and the lowest bass is mere millimetres in size. The sweet spot for working opera singers is found through a combination of nature and nurture, and for every singer who falls neatly into a vocal *Fach* pigeon hole, there seems to be another whose voice lies in the grey areas between mezzo and soprano, or between baritone and tenor.

For some singers, it can take a long time to find the repertoire that suits their voice. The *Fach* system is funny; in one sense, it's a guide for singers and those who hire them, roughly telling listeners what they can expect in an audition. In another sense, the various *Fachs* come with other traits, almost personal qualities - like a bubbly coloratura or a virile baritone - that contribute to the professional image of an opera singer.

It's an interesting thought: how many working singers out there find themselves playing roles with whom they have little in common? Characters that they just don't "get"? And as a singer, would that ever start to bother you?

Baltimore native and mezzo-soprano [Breanna Sinclairé](/scene/people/breanna-sinclaire/) recalls distinctly that feeling of a disconnect between herself and the roles she sang. Her story is more complicated than a simple sense of "I don't identify with Rodolfo"; Sinclairé is a trans woman, whose history as an opera singer includes training as a tenor before her transition. 

"I was a very high tenor," she says, even recalling many conversations with her mentors and peers about pursuing a career as a countertenor. On a daily basis, Sinclairé "always had this debate with myself" about how to train her voice; though not an easy decision to make, there was at least one simple truth to the matter: "I never felt comfortable playing tenor roles."

"Singing in the tenor range, I was still battling with my gender and would envy sopranos because I knew this was the *Fach* I should be singing," Sinclairé recalls. "I hated the timbre of my tenor voice. It was flat, shaky, not a true tenor sound, and had no core. It didn't feel authentic."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1481463731721/2016-11-24---Breanna-Sinclaire.jpg.jpg)<figcaption>Breanna Sinclairé.</figcaption>
</figure>

It's a question that piques curiosity: how does a singer, well, *sing* during a gender transition?

It's not surprising that, like any singer working toward technical goals, the answer for trans singers lies in building a good foundation of vocal technique. Perhaps it's a disheartening moment, for a singer with substantial training to go "back to basics" with their voice as they transition, learning to create and resonate sound in a different way. [Dr. Todd Wieczorek](http://music.uwo.ca/faculty/bios/todd-wieczorek.html), Professor of Voice at Western University, who has some experience in teaching trans students, sees technical foundations as a ever-useful tool for any singer at any level. "Much of the technique for good singing is basic technique for good singing," says Wieczorek.

A teacher with a trans student is charged with a certain care in choosing their repertoire, and even the unique challenges of finding and negotiating vocal *passaggi* (or register transitions). The unique challenges for the trans singer come in providing feedback about their changing voice, and, Wieczorek adds, "trusting the technique they have as the voice begins the shift."

Sinclairé recalls a similar process with her coach, [Ruby Pleasure](https://www.sfcm.edu/faculty/pleasure), with whom she had extra lessons as she was transitioning. "Technically, I was starting all over, re-learning the voice. Those were the hardest three years of my life." She always had an easy head voice, and with her coach, she explored her upper register further. "I could not believe I had these notes. Sometimes I think maybe the estrogen helped with this. I am actually unsure, but it was interesting, comfortable, and wasn't strained."

Regardless of her transition, Sinclairé's training always involved a focus on breath, and using that breath to sing through the changes happening in her voice. "Singing is supposed to be playful, experimental," she says. "It's through age, and lots of practice, that your voice begins to produce a healthy sound. At the Conservatory, I practiced daily, because I knew I was meant to do this and I was driven to succeed."

Sinclairé likens her hormone therapy to a second puberty of sorts. "It's rough," she says, "but all I can say is the hormones didn't change my voice drastically, it was slight and brief change - meaning my timbre got softer and less heavy."

Though hormone therapy alters the voice, a trans singer retains some of the same vocal qualities of their birth gender; the concept of "passing" as a [cisgender](https://en.wikipedia.org/wiki/Cisgender) singer is largely reliant on physiology, as it is for body shapes and facial structure.

"For trans men, the vocal shift downward would be assisted by testosterone treatment, but it would be challenging to get the resonance space to conform to that of a cis man," says Wieczorek. "For trans women, the naturally occurring testosterone prior to transitioning would predispose the voice to a lower range, physiologically."

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/KMSrIiWcER4?start=140" frameborder="0" allowfullscreen></iframe>
</figure>

It's an interesting thought, to ponder the idea of a trans mezzo who can "vocally pass" as a cisgender mezzo (of course, "passing" is no requisite of a successful transition, gender or otherwise). If we consider just the voice, singers usually sound their best when they're singing repertoire that technically fits them. For a baritone who should be singing tenor repertoire, it's often a case of misdiagnosis that seems to mirror the difference between a tenor who should be singing mezzo repertoire.

To be sure, that's an oversimplification of Sinclairé's transition, even within the scope of her professional life. To move from baritone to tenor is one thing; you sing auditions for people who have heard you pre-change, and they are surprised/delighted/appalled. But to pair a new voice type with a change of gender - that's quite another thing to include in your audition package.

"I think now, I'm ready to venture out into the world and audition for female roles," says Sinclairé of her professional, post-transition life as a mezzo-soprano. "Right now, the important focus should be on my musicality, how I interpret the words with my sound, and how I use it. The classical field takes a lot of discipline and work. And I'm going to keep working until more doors open."

Sinclairé, who has sung with the Colorado Symphony, the San Francisco Gay Men's Chorus, and who helped celebrate transgender and queer performers at the [14th Annual Fresh Meat Festival](http://freshmeatproductions.org/), sees her career as an "evolving" one. "I've had some great experiences performing in art spaces, where I was accepted as the woman I am. I remember when I performed my final recital at the Conservatory, an audience member came up to me and said, 'When I closed my eyes and heard to sing, you sounded like a female, there was no doubt in my mind!'"

