+++
author = ["authors/gwenna-fairchildtaylor.md"]
categories = "Editorial"
date = "2016-09-16T09:52:00+01:00"
lastmod = "2016-09-17T08:56:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474028718270/2016-09-16---"
primary_image_credit = "Photo: Amanda Graham via Flickr."
publishDate = "2016-09-16T13:40:00+01:00"
related_articles = ["articles/coaches-voice-teachers-and-the-grey-area-in-between.md", "articles/3-life-lessons-that-practice-rooms-can-teach-you.md"]
related_companies = ["scene/companies/university-of-toronto-opera.md"]
related_people = ["scene/people/gwenna-fairchildtaylor.md"]
short_description = "My work up north has made me a better singer and artist, without question. At the most basic level it&#039;s one of the ways I remind myself why art is so, so important, even though trying to be a singer is so difficult. So here are five epiphanies I&#039;ve had because of my time teaching in some of the most beautiful places on earth."
slug = "teaching-in-the-arctic-5-things-that-one-singer-learned"
title = "Teaching in the Arctic: 5 things that one singer learned"

+++
Hi, I'm Gwenna!  I'm a soprano and a recent UofTOpera graduate, among other things. I love singing - it's when I feel most like myself. Opera is my favourite. I also think teaching people about music is vitally important.  So I do both, even though I'm still figuring out how to balance it all.

In combination with doing all the stuff a young singer does (auditions, gigs, lessons, coachings, etc.) I teach way up in northern Canada, with lots of help from government grants and sponsors. Usually trips are between one and three weeks, depending on the time frame I have available and what the grant can afford. I have 2 more trips planned in the near future. I'm going to Cambridge Bay, Nunavut in January and Pangnirtung, Nunavut in February. Temperatures in Cambridge Bay at that time hover between -25 and -35 Celsius, plus whatever scary windchill, and it is near 24 hour darkness. Crazy, right?

This summer I spent around half of my time working on my singing and the other half teaching in Kuujjuaq, Nunavik and Iqaluit, Nunavut. I've been doing variations of this for 6 years, but my projects have been funded by Government of Nunavut grants for the last 2 years.

I offer free classes to kids and adults in communities in Nunavut. Participants sing in all three official languages (Inuktitut, English, French). In its first year, my program in Iqaluit had 14 participants register. I recently finished the second year, and we had 48 participants register and another 10 or 15 on the wait list. It has grown so quickly!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474016060969/2016-09-16---Gwenna-students.jpg.jpg)<figcaption>Gwenna Fairchild-Taylor's class of youngest students in Iqaluit. Photo by Thomas Rohner.</figcaption>
</figure>

There is a huge learning curve, and it has been exceptionally challenging, to say the least, but that is a conversation for another day.

I've been wanting to write about this for a while, but I didn't really know what to say. Lots of people ask me about this all the time, and I think it's time to share a bit about it.

Before I continue I have to make one thing very clear.  I find the lack of resources, understanding and attention from those of us living in the southern half of Canada unacceptable.

What we are doing is not enough. The fact that we're just starting to pay attention is good, but it isn't nearly good enough. People deal with food insecurity every day, many kids aren't finishing school, the suicide rate in the north is devastatingly high, there is not enough access to proper medical care and counselling services, and much more. There are some things that I have seen or have been disclosed to me that would break your heart.

If you take anything from my writing about this make it be a desire to pay more attention and to demand better for our indigenous communities. We need to do more. We need to do better. End of story. I urge you to learn more about Truth and Reconciliation and read the [report released in June 2015](http://www.trc.ca/websites/trcinstitution/index.php?p=890).

Among all of this is a beauty and a resilience that I greatly admire. People in northern communities have beautiful culture, beautiful language and are warm, kind and welcoming to me. The kids are full of life and energy and creativity.

I've learned just as much watching throat singers and drum dancers perform as I have in many voice masterclasses. When I talk to throat singers they speak to me about finding deeper, more connected sounds. Huh. Sounds familiar, doesn't it?

My work up north has made me a better singer and artist, without question. At the most basic level it's one of the ways I remind myself why art is so, so important, even though trying to be a singer is so difficult.  So here are five epiphanies I've had because of my time teaching in some of the most beautiful places on earth.

### Music classes aren't just about the music and the notes on the page.

When I sing with the participants and teach them stuff about the voice, yes, on the surface it is about the music.  But really, it goes way deeper than that. It is my opinion that working with people on their voices and their ability to express stories is about far more than meets the eye. I'm interested in reminding people that they are in possession of a strong voice and a strong mind. Their opinions and thoughts are so worthy of being shared and I want people to have the skills to share them.

That's why I spend the time on this that I do, to give someone full access to their voice to use as an expressive and communicative tool. I welcome all kinds of singing in class - it makes me so happy to watch people throat sing in particular - it's so collaborative. It’s magic.

I make it clear that I only know how to teach a small part of singing, and I welcome them to teach me things about other traditions. I can't throat sing - it wouldn’t be so good for my own singing, but I’ve learned a lot about how it works by watching and asking questions. There's also quite a lot of pop singing everywhere I go, not unlike teaching in Toronto.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474028868790/2016-09-16---Gwenna-Iqaluit.jpg.jpg)
<figcaption>Gwenna Fairchild-Taylor in Iqaluit, NU.</figcaption>
</figure>

### Opera is for everyone. Truly.

As part of my work I often end up singing for participants- they're curious, and it helps me to break the ice a bit. "I’ll sing for you if you sing for me!" Last year in Iqaluit I even teamed up with a pianist and gave a recital. Opera is something that most in northern communities have never experienced live, just like throat singing is something a lot of us in the south haven't had the pleasure of seeing live.

In the 5 years I've been doing this I've seen the faces of many, many fascinated children. It would warm your heart. No one has told them that opera is boring, so they aren't bored! They tell me they'd like to see an opera one day. They are quiet and attentive as soon as I open my mouth, which is actually kind of amazing, given that many are quite energetic and love to run around.

While I was in Iqaluit, my colleague and I did a workshop at the youth home. I sang for the participants, and they picked the language: German. So, I picked Elsa's Dream. Wagner on Frobisher Bay - interesting! We were sitting around a table, no piano, there was no formality and nothing to hide behind. It was one of the most powerful musical experiences of my life. I connected to the piece in a way I hadn't previously and I figured out a lot about communication. I want to bring that with me every time I sing!

My heart hurts for those kids, who, previously to living there, were in devastating situations. I wanted to sit on the couch and distracting myself with something. But I promised myself this past trip that I would keep to my regular practice schedule, which I have struggled with in the past when teaching in the north.

And so I dusted myself off and was working on this piece that, truth be told, I am pretty scared of. But that day, my body just let go of the worry I was feeling about it…perhaps because my mind was still busy worrying about the kids. Whatever resistance my own body had been subconsciously providing was totally gone, and the piece wasn't at all scary any more.

I feel like nothing can be better for your singing than broadening your perspective, appreciation  and empathy for others in the world. Sounds super corny, I know.

### Not everyone is going to want what you offer and that's ok.

What you have to give isn't right for everyone, but that doesn't mean what you have to offer isn't good. Am I talking about auditions right now, or am I talking about my work in the north? Both, it would seem! Obviously I still struggle with this (I can't be the only one!), but through my work in the north I'm slowly coming closer to not feeling every rejection letter as a personal attack, because it isn't really that. I have had kids who drop out of my classes without an explanation, only to return the next year and show up every time. Sometimes timing is everything - that continues to frustrate me both in my singing and my teaching, but it is the truth!

### Patience is a necessary thing.

I am not a particularly patient person - anyone who knows me can tell you that. I am almost always early, I find lateness super annoying. If I had my way I would plan everything months in advance.   But in the north, you have to be patient. For one thing, the Internet is 3 or 4 times slower, if not more. It was really ...fun... trying to upload stuff for young artist applications while I was in Iqaluit this August/September, let me tell you! When I started I was frustrated with some lack of communication. But as my relationship with people in communities has improved, it has slowly (over a period of years) gotten easier. I needed to earn some trust first.

All this to say: stuff takes time. I'm trying to remind myself about that in my singing, being someone with an instrument that won't be 'ready' for a while. It's slowly sinking in…slowly…

### If you don't know, ask. If you need help, ask.

No one will think less of you and a lot of the time they'll be happy to help!  When I started I wanted to do this all myself, but in reality I needed a lot of help to get stuff going in the beginning. There's a whole list of people that make these programs happen - I still rely on a lot of people now. If it was just me I probably wouldn't get very far.

I was at party the other day and a very, very kind person called me "a force of nature". I’m super flattered, but it isn’t just me! Maybe I'm the one who makes the phone calls and sends the emails and organizes everything, but it is the collective energy of everyone that makes it happen. Many people up north and in Ontario are what makes this possible.

This year there was enough grant funding to have a partner teacher in Iqaluit and it made all the difference. I think the program was way better  because of it. This is the structure I would love to have moving forward. I'm hoping that funding lets this happen in the future, because a budgetary reality is that I'm teaching on my own 99% of the time. It can be very isolating.

But you can't do everything yourself, and you can't know everything. I have learned so much from respectfully asking questions to people who live in communities I visit and carefully listening to the answers. They have been really lovely about educating me. The programs that I run are far from perfect - I'm just doing the best I can to keep learning from people and making them better. I don't know everything and most of the time I’m convinced I don’t know enough. All I can do is learn more!

Again, I'd urge you to do some reading at [this link to the Truth and Reconciliation Commission of Canada](http://templatelab.com/truth-and-reconciliation-commission-calls-to-action/).

***

Feature image: [Amanda Graham](https://www.flickr.com/photos/ytwhitelight/5423894153/in/photolist-9ghSLr-9ghS2V-fCWAka-9ZKayq-uqoLtG-hfbUik-9ZGiJD-hfdBGi-hfc4M9-9ZGkhe-9ZGn3c-7EPWGh-9ZGmtg-9gkWFj-7EL3EV-hfbY3V-hfcysW-hfdALR-vnp3T6-h6KadE-jYfeT-v5PEhj-jYfiM-vk6rNJ-vmSs1h-vk6sms-9ZGi7z-9ghRQv-9ZKaoA-9ghSqM-9gkX2o-7EL4zc-9hkV6C-9hhMQ8-9ZGiXK-9ZKbnb-2fs1CJ-9hkVoq-9hkVzo-9ZKdmu-qopvXG-hfc8Lw-ph3FMd-dLrf6w-JfiDxm-9FS2N3-5VaYYd-8t7BMV-cwSuYG-cJbPYE) via [Flickr](https://creativecommons.org/licenses/by-nc-sa/2.0/).