+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2019-08-05T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "The 2019 [Tête-à-Tête: The Opera Festival](https://www.tete-a-tete.org.uk/festival-calendar-at-a-glance-2018/) line-up continues through 10 August."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1565030391/media/2019/08/sqHildegard_rbnfb3.jpg"
primary_image_credit = ""
related_articles = ["articles/check-out-tete-a-tete.md"]
related_companies = ["scene/companies/tete-a-tete.md"]
related_people = []
short_description = "All senses were catered to as audience members were misted with fragrant water and touched softly by the performers while being whispered and sung to directly."
slug = "site-specific-intimate-selections-from-tete-a-tete-the-opera-festival"
title = "Site-specific & intimate: selections from Tête-à-Tête: The Opera Festival"
youtube_url = ""

+++
I recently had the pleasure of seeing two pieces in [Tête-à-Tête's Opera Festival line up](https://www.tete-a-tete.org.uk/festival-calendar-at-a-glance-2018/) this summer. Though very different in style and subject matter, they are alike in their re-imagining of the traditional operatic performance space and in their bending of the limitations of the genre.

>All senses were catered to as audience members were misted with fragrant water and touched softly by the performers while being whispered and sung to directly.

The first piece was Nwando Ebizie's performative installation _Hildegard: Visions_; an immersive performance that combined three original commissions using the life and work of Hildegard of Bingen as a starting point to explore her experience with cosmic visions and their connection to neurodiversity through the use of  structural light, electronic soundscapes, and cross cultural rituals. Though billed as an opera, it felt more like a participatory, sensory exploration. Workshopped over the course of a week, it had a naturalistic and improvisational feel that was well suited to it, given its grounding in the research and development field.an immersive performance that combined three original commissions using the life and work of Hildegard of Bingen as a starting point to explore her experience with cosmic visions and their connection to neurodiversity through the use of  structural light, electronic soundscapes, and cross cultural rituals.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1565031416/media/2019/08/Hildegard1_syhpvm.jpg){{% /md %}}

<figcaption>Hildegard: Visions, Tête-à-Tête: The Opera Festival, 2019. Photo: Claire Shovelton.</figcaption>

</figure>

All senses were catered to as audience members were misted with fragrant water and touched softly by the performers while being whispered and sung to directly.  There was a strong participation element as audience members were asked to wear items of clothing, shine torches, and towards the end of the piece, join in a euphoric, ritualistic dance that carried on endlessly as people began to filter out after the allotted "performance time" had ended. Structural lighting design by Shelley James was a crucial element of the piece and effectively executed, filling the space with a dazzling, other-worldly glow. The audience was fully immersed in the sound of the piece as pre-recorded polyphonic singing, whispering, and sound effects blared from speakers in every corner of the room, bathing us in an entanglement of sound.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1565031426/media/2019/08/Hildegard2_ow8bwy.jpg){{% /md %}}

<figcaption>Hildegard: Visions, Tête-à-Tête: The Opera Festival, 2019. Photo: Claire Shovelton.</figcaption>

</figure>

The second piece was composer, librettist, and director Francesca Le Lohe's Ango-Japanese _The Key_, based on the 1956 novella of the same name by author Junichiro Tanizaki which tells a story of a suffering marriage entirely through journal entries. The characters interact indirectly with each other by reading each other's diaries and as their actions become bolder, they threaten to destroy the marriage entirely.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1565031436/media/2019/08/Hildegard3_s5b8dc.jpg){{% /md %}}

<figcaption>Hildegard: Visions, Tête-à-Tête: The Opera Festival, 2019. Photo: Claire Shovelton.</figcaption>

</figure>

The site-specific piece was performed in the West Dulwich mid-century home of London architect Angus Shepherd which created the perfect setting for this wonderfully and meticulously crafted piece. Featuring three trios and a solo dancer, each trio was made up of a singer, a western stringed instrument, and a traditional Japanese instrument, namely; Shakuhachi (bamboo flute), Sho (mouth organ), and Shumedaiko (percussion). 

>The word "intimacy" comes to mind when describing both pieces.

Each trio was set up in a different room of the house, but the design was such that sound easily carried over multiple floors and through open windows. The trios performed simultaneously but with music that was independent of each other's. Often, one trio would swell to a _forte_ while the other faded to silence. The instruments would weave seamlessly in and out of each other, directing the narrative to different rooms of the house. The audience were free to walk from room to room as and when we wanted, creating our own perspective on this story told from multiple angles.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1565031455/media/2019/08/TheKey2_le3i0y.jpg){{% /md %}}

<figcaption>THE鍵KEY, Tête-à-Tête: The Opera Festival, 2019. Photo: Claire Shovelton.</figcaption>

</figure>

Both pieces challenged the audience in participatory, exploratory ways. Unlike more traditional performances with an audience sitting facing a stage to which all of the action is confined to, the "stage" became the entire performance space whether it be a black box theatre, or someone's living room, and in this sense, the audience had a large role to play. Participation was a requirement in _Visions_, as the audience became an integral part of the ritual that was being played out through the piece and therefore, our involvement was also an integral part of the overall mood of the piece. Similarly, in _The Key_, audience members inadvertently became a part of the performance as we wandered around the space, responding to the performers needs and movements.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1565031465/media/2019/08/TheKey3_wvrmjy.jpg){{% /md %}}

<figcaption>THE鍵KEY, Tête-à-Tête: The Opera Festival, 2019. Photo: Claire Shovelton.</figcaption>

</figure>

The word "intimacy" comes to mind when describing both pieces, and while it is more of a mood obtained in _Visions_, it is also a strong thematic point in _The Key_. Large performance spaces can be made to feel intimate if the performers strive to create that particular atmosphere, but this is much more easily achieved with the limited space of a family home that only allows for 20 or so audience members.

>I am excited to see what else is in store.

Not only was the subject matter particularly intimate, delving into the inner workings of a marriage, but because the piece took place in a home, the sense that the audience was peering into their private lives was all the more prevalent. _Visions_ created this sense of intimacy by transforming a dark, characterless space into a lush and welcoming one that invited the audience to sit freely and comfortably as the performance happened all around us.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1565031475/media/2019/08/TheKey4_h6kuy8.jpg){{% /md %}}

<figcaption>THE鍵KEY, Tête-à-Tête: The Opera Festival, 2019. Photo: Claire Shovelton.</figcaption>

</figure>

Both pieces played with the boundaries of the audience's comfort with intimacy. In a large concert hall, it is easy to separate oneself from the emotional intimacy of the stage but with these two pieces, there was no choice but to be confronted with it.

Tête-à-Tête continues to challenge the boundaries of opera with its yearly summer festival" three weeks of explosive creativity and inspiration. Both _Hildegard: Visions_ and _The Key_ have presented a unique way of looking at the art form. Site-specific performances have a beautiful intimacy to them that allow for a more personal experience for both the audience and the performers and these two pieces are proof that opera truly can be performed anywhere. I am excited to see what else is in store.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1565031484/media/2019/08/TheKey5_rvl0jq.jpg){{% /md %}}

<figcaption>THE鍵KEY, Tête-à-Tête: The Opera Festival, 2019. Photo: Claire Shovelton.</figcaption>

</figure>