+++
author = ["authors/molly-simoneau.md"]
categories = "Review"
date = "2017-09-17T15:01:00-04:00"
lastmod = "2017-09-17T21:37:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505677162194/2017-09-17---square---Tamara-Wilson-Aida-and-Yonghoon-Lee-Radames.Aida.photo-by-Scott-Suchman.jpg.jpg"
primary_image_credit = "Tamara Wilson (Aida) and Yonghoon Lee (Radamès) in Aida, Washington National Opera, 2017. Photo: Scott Suchman."
publishDate = "2017-09-17T21:27:00-04:00"
related_articles = ["articles/talking-with-singers-ekaterina-semenchuk.md","articles/no-opera-is-not-misogynist.md","articles/stellar-singing-curious-costumes-in-enos-aida.md","articles/sleek-storytelling-costly-illusions-wnos-alcina.md"]
related_companies = ["scene/companies/washington-national-opera.md"]
related_people = ["scene/people/tamara-wilson.md","scene/people/yonghoon-lee.md","scene/people/gordon-hawkins.md","scene/people/soloman-howard.md","scene/people/ekaterina-semenchuk.md"]
short_description = "While Zambello&#039;s attempt to create a modern, stylized Aida may have failed, this performance is a delight for the ears. Tamara Wilson&#039;s flawless performance alone is worth making the trip to the Kennedy Center."
slug = "tamara-wilson-gives-a-flawless-aida-at-wno"
title = "Tamara Wilson gives a &quot;flawless&quot; Aida at WNO"
+++

It's not a new idea to invite well-known artists to join an opera production's design team; Marc Chagall's famous 1967 *Magic Flute* production for [The Metropolitan Opera](/scene/companies/the-metropolitan-opera/) comes to mind as a notable example, and William Kentridge's productions of *The Nose* and [*Lulu*](/in-review-lulu-at-eno/) have run at the Met and [English National Opera](/scene/companies/english-national-opera/) to acclaim in the last decade. 

In this tradition, [Washington National Opera](/scene/companies/washington-national-opera/) artistic director Francesca Zambello invited the Los Angeles-based graffiti artist RETNA to collaborate on the designs for her [*Aida*](http://www.kennedy-center.org/calendar/event/OSOSA), and it's easy to see why. RETNA's art, which consists of patterns of bold graphic symbols, inspired by calligraphy and hieroglyphs, invokes the ancient Egyptian writing that adorns stone temple walls that have stood for thousands of years in the Sahara. Unfortunately, the result of this collaboration is an opera set that is too often garish and unsightly, the apparently meaningless glyphs creating an overly busy backdrop for what is otherwise a pretty standard, by-the-book *Aida*.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505677467960/2017-09-17---Yonghoon-Lee-Radames-and-Ekaterina-Semenchuk-Amneris.-Aida.-photo-by-Scott-Suchman.jpg.jpg)
<figcaption>Yonghoon Lee (Radamès) and Ekaterina Semechuk (Amneris) in *Aida*, Washington National Opera, 2017. Photo by Scott Suchman.</figcaption>
</figure>

But what this *Aida* lacks in visual aesthetics, it more than makes up for musically. Soprano [Tamara Wilson](/scene/people/tamara-wilson/) sings the title role with such ease and grace, one could imagine her getting up up at the end of the final scene, going back to the beginning, and doing the whole thing again without breaking a sweat. In the soft, contemplative passages of her first aria, "Ritorna vincitor", she manages to hold the stage, even as supers move furniture around her. It's rare to hear a voice that can powerfully soar over Verdi's full choral and orchestral forces, while still holding on to its incredible beauty and clarity of tone, and then turning around to offer crystalline pianissimos, including a gloriously floated high-C in "O patria mia".

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505677352690/2017-09-17---Tamara-Wilson-Aida.Aida.photo-by-ScottSuchman.jpg.jpg)
<figcaption>Tamara Wilson (Aida) in *Aida*, Washington National Opera, 2017. Photo by Scott Suchman.</figcaption>
</figure>

Opposite Wilson's Aida, tenor [Yonghoon Lee](/scene/people/yonghoon-lee/) makes for a handsome Radamès, with an exciting spinto voice which pierces the orchestra in his more heroic passages, but seems to become muffled when he attempts softer, more tender moments. In the rising vocal lines of "Celeste Aida", he seems to come off the voice in an attempt to shape the phrase, and in the final duet, he is simply outmatched by Wilson. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505677365285/2017-09-17---Yonghoon-Lee-Radames2.Aida.photo-by-Scott-Suchman.jpg.jpg)
<figcaption>Yonghoon Lee (Radamès) in *Aida*, Washington National Opera, 2017. Photo by Scott Suchman.</figcaption>
</figure>

Rounding out the love triangle, mezzo-soprano [Ekaterina Semenchuk](/scene/people/ekaterina-semenchuk/) brings a thrilling chest voice and soaring top notes to her sympathetic portrayal of Amneris. However, she is the victim of Zambello's awkward staging when her disembodied head appears behind a scrim to deliver her final lines at the end of the tomb scene. I'm sure I wasn't the only audience member who had to stifle a laugh.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505677382635/2017-09-17---Elaterina-Semenchuk-Amneris-and-Tamara-WIlson-Aida.Aida.photo-by-Scott-Suchman.jpg.jpg)
<figcaption>Ekaterina Semenchuk (Amneris) and Tamara Wilson (Aida) in *Aida*, Washington National Opera, 2017. Photo by Scott Suchman.</figcaption>
</figure>

[Morris Robinson](/scene/people/morris-robinson/) as Ramfis fills the hall with the booming bass that has made him famous, and bass Solomon Howard, fast becoming a favorite of the WNO audience, is well-cast as the King of Egypt.  As Amonasro, baritone [Gordon Hawkins](/scene/people/gordon-hawkins/)' voice seemed tired, but he more than makes up for it with his commanding stage presence in the Nile scene.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505677404258/2017-09-17---Morris-Robinson-Ramfis%2C-Yonghoon-Lee-Radames%2C-Soloman-Howard-King-of-Egypt.Aida.Photoby-ScottSuchman.jpg.jpg)
<figcaption>(l-r): Morris Robinson (Ramfis), Yonghoon Lee (Radamès), and Soloman Howard (King of Egypt) in *Aida*, Washington National Opera, 2017. Photo by Scott Suchman.</figcaption>
</figure>

The cast is complimented by 9 dancers who perform choreography by Jessica Lang in several scenes, including a long ballet during the famous Triumphal March. And here I have to confess that I have never enjoyed the dance elements in any opera, which always seem like "filler" to me, when compared to other performances where dance is the primary focus. I'm sorry to say that this *Aida* proved no exception.  

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505677282392/2017-09-17---Aida.-photo-by-Scott-Suchman.jpg.jpg)
<figcaption>A scene from *Aida*, Washington National Opera, 2017. Photo by Scott Suchman.</figcaption>
</figure>

The WNO orchestra sounds as fine as ever under the baton of Evan Rogister, and they have been sounding fine these last few years, from the glittering strings in the first few bars of the overture to the booming brass, complete with antiphonal trumpets on stage, during the Triumphal March. The chorus also holds their own, singing with richness and clarity.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505677528201/2017-09-17---Kana-Kimura-dancer-Morris-Robinson-Ramfis%2C-Yonghoon-Lee-Radames.Aida.Photo-by-ScottSuchman.jpg.jpg)
<figcaption>Kana Kimura (dancer), Morris Robinson (Ramfis), and Yonghoon Lee (Radamès) in *Aida*, Washington National Opera, 2017. Photo by Scott Suchman.</figcaption>
</figure>

While Zambello's attempt to create a modern, stylized *Aida* may have failed, this performance is a delight for the ears. Tamara Wilson's flawless performance alone is worth making the trip to the Kennedy Center.

>Aida plays until September 23, including a second cast led by [Leah Crocetto](/talking-with-singers-leah-crocetto/), Marina Prudenskaya (Amneris), and Carl Tanner (Radamès). For details and ticket information, [click here.](http://www.kennedy-center.org/calendar/event/OSOSA)

