+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-07-24T18:14:00-04:00"
lastmod = "2017-08-09T16:47:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502234500081/2017-08-09---Paul-Kwak.jpg.jpg"
publishDate = "2017-08-09T13:09:00-04:00"
related_articles = ["articles/stop-shaming-adele.md","articles/baby-opera-singers-getting-angry-for-the-right-reasons.md","articles/the-voice-teacher-series-edith-wiens.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md"]
related_people = ["scene/people/christine-goerke.md","scene/people/ailyn-prez.md","scene/people/jamie-barton.md"]
short_description = "&quot;People have so much fear about injury or the discovery of pathology on the vocal cords,&quot; Kwak explains of common diagnoses like nodules, cysts, or polyps on the cords. &quot;I think a lot of it was borne out of this unscientific school of voice teaching.&quot;"
slug = "talking-with-voice-docs-dr-paul-e-kwak"
title = "Talking with voice docs: Dr. Paul E. Kwak"
+++

"My career, I would say, is a portrait of indecision," smiles Dr. Paul E. Kwak, laryngologist at New York's NYU Langone Medical Center. Kwak is also a graduate of the Juilliard School, where he studied Collaborative Piano with famed pianist and voice coach, Margo Garrett. Though medicine was always a probable career path, he adds, "I think the music piece was always a really important heart piece. I always loved playing."

The chance to study with Garrett, whom he calls a "phenomenon", was part of Kwak's move to Juilliard. "She has this sort of innate sense of how fragile they can be at times, or how vulnerable one is when one sings," he says. "I learned a lot of that empathy from her."

The musical and medical streams came together near the end of his time at Juilliard, when he met [Dr. Steven Zeitels](https://en.wikipedia.org/wiki/Steven_M._Zeitels) and heard him give a lecture on vocal health. Speaking with Kwak about his work at NYU Langone, it's clear that he's passionate about connecting with singers and helping them to have their best possible performances. For singers in search of consultation or vocal therapy, finding someone like Kwak - whose musical and medical backgrounds add up to a thorough understanding of a singing career - is a bit of a jackpot.

"Singers are surprised when I ask them specific questions about their repertoire," he says. Where many doctors would collect surface-level information about a singer's artistic choices, Kwak and his team focus on a patient's range, tessitura, where their *passaggio* lies, and what genres of music they sing. For Kwak and his team, more is certainly more when it comes to gleaning information about a new patient, and "just being able to have that conversation gives [singers] a level of comfort and a level of confidence."

## "I believe that *Fach* is not necessarily encoded in your laryngeal anatomy."

"If you looked at 10 peoples' larynxes," says Kwak, "particularly in the absence of sound, you would have a hard time telling them apart." Perhaps that's not a surprising statement to those with some familiarity with the voice; yet it's a fact that offers much-needed perspective within an industry like opera, which has a history of strict vocal categorization. It may be considered taboo to have both roles on a current résumé, but "between a Countess and a Brünnhilde, there are often very few differences in the actual anatomy of the cords."

"I believe that *Fach* is not necessarily encoded in your laryngeal anatomy," Kwak proposes. "I believe that questions of *Fach* are about inhabiting that anatomy in the best way possible." That "best way possible" changes with aging, the shape of the face and pharynx, hormonal fluctuations, and of course, the solidification of vocal technique.

A symptom of these changes, from the singer's point of view, is the sense that their repertoire no longer "fits", that it's too small or too large for their instrument. Packing a voice into a role that's "too small", Kwak suggests, "becomes a mismatch between breath, lung capacity, and larynx." Conversely, a singer's successful move into larger repertoire is "more about volume and efficiency of breath, rather than big differences in anatomy of the cords."

This isn't to say that there's no limit to the kind of repertoire a singer can take on during his or her career. "The missing piece of the discussion at opera houses - and Broadway theatres - is this issue of rest and recovery," Kwak point out. "The vocal cords need that period of rest to recover from an expected amount of swelling and trauma, which we estimate is on the order of 36-48hrs after a show."

Given the demands of an operatic performance, singers will inevitably show evidence of hard work on their instruments. "If you scope a singer right when she steps offstage, there's a certain amount of expect swelling on the cords," says Kwak. "The problem, is that if you keep talking and singing on those cords night after night, that's how Broadway singers often get into trouble. There's literally no period of recovery."

Given that opera singers perform less frequently, compared to Broadway performers, it makes for an interesting hypothetical: if the period of rest is included in the mix, "any singer in the opera world, could theoretically do any role he or she wanted to, and not have the expectation that there is inherently going to be an injury to the vocal cords."

For Kwak, the risk of injury doesn't lie simply in the decision to move from an Adina to a Senta, but in the technique involved in that decision. "A singer cannot transform her laryngeal anatomy, so I think it is fundamentally a mechanical adjustment, about using the breath in a different way, about using the muscles of the larynx in a different way, and about coordinating them." 

Notoriously opinionated, opera lovers can come to conclusions about their favourite singers, and often those opinions are not rooted in an understanding of vocal anatomy or physiology. Kwak suggests that when people predict that a singer's new repertoire choices are too ambitious, I think what they may be concerned about is that there's going to be too much trauma on the cords in an effort to make a bigger sound; when actually that growth should probably come from better coordination of breath, alignment, and placement."

Without intentional malice, opera fans can often conflate the ideas of vocal fitness for a role, and the perceived aesthetic of that role. "People do have these very rigid ideas of what's right and appropriate for a certain role and a certain opera." 

Not every singer has the same trajectory of roles throughout their career, nor should they be charged with sounding like Lucia Popp's Queen of the Night, or Vickers' Peter Grimes. "In a way, you lose the appreciation of each unique voice," says Kwak, who suggests that opera fans not have unyielding conceptions of "a Sophie" or "an Elsa", but instead, "we should probably just be more open to simply discussing 'Jamie' and 'Christine' and 'Ailyn'."

Opera fans who offer their opinions are relatively harmless, and in fact there is often much pleasure in these kinds of discussions among aficionados; yet Kwak is troubled when the trend extends to instructors who conflate opinion and pedagogy. "The problem - at least from my perspective - with vocal instruction that's not somewhat firmly rooted in anatomy and sciences, is that it does give permission to that freedom of opinion on voices that's uninformed." Those free opinions can include predicting major vocal trauma, based on a singer's decision to try out new - usually heftier - roles. "Whenever people talk about how singers are going to ruin their voices by moving into heavier repertoire, I have a great urge to ask them what in the world they mean by that."

"One [teacher] I really admire is [Stephen King](http://music.rice.edu/facultybios/king.shtml)," Kwak offers. "His teaching is so firmly rooted in vocal anatomy and science. He imparts that to the singer in terms that are easy to grasp, and it takes the voodoo out of it."

## "I think that there is too little awareness of what it really does take."

Further complicating the matter are the competing, even conflicting to-do lists between professional singers and the people who hire them. Singers are responsible for learning a role, traveling long distances to rehearse it, and staying healthy and fit enough to deliver solid performances, across time zones and in all manner of climate. Kwak notes, "I think that there is too little awareness of what it really does take physically to do that."

Singing A440 means that a singer's cords collide with each other 440 times per second. If that sounds like a lot, you're right, and higher voice types can rack up collisions in the 1000s per second. Kwak likens the demands – singing and speaking – on a voice throughout the day to a "vocal bank account". Say, for example, that your anatomy and function allow you for 1,000,000 vocal fold collisions before you start getting fatigued.

"You're onstage for three hours doing a Sitzprobe, and you use 500,000 of them. And then you have to talk to the director afterwards, and that's another 200,000. And then you go out to dinner with friends and that's another 300,000. Then you decide you have to come home and call your family." It's at this point, says Kwak, that a singer starts "getting in the red."

For most singers, it's not news that performance days call for some extra care. Being mindful of one's speaking voice counts for a lot, too. "You hear all these singers who just fry their voices when they're speaking. That ends up being more traumatic to the cords, because you're speaking all day and you're not thinking about resonance, support, or efficiency."

Kwak acknowledges the responsibility on the singer's end for paying attention to how much wear and tear their voices get on a daily basis, but it's not meant as a frightful warning. "We expect a certain amount of edema or swelling after a performance," he says. "But the body has innate mechanisms for healing that, as long as you give it the opportunity to do so."

"I think that's one of the most important principles," says Kwak, who adds that "the larynx is actually quite resilient." Part of most singers' training includes education about vocal care, and negotiating the perceived dangers of loud speaking, alcohol, dairy products, and acid reflux can create in singers a sense of paranoia about their instruments.

"People have so much fear about injury or the discovery of pathology on the vocal cords," Kwak explains of common diagnoses like nodules, cysts, or polyps on the cords. "I think a lot of this is borne out of mythology that arises from pedagogy that is unrooted in science." 

## "The unfounded fear is that it's unrecoverable."

To have "stuff" (pathology) on one's cords isn't an ideal situation for a singer, but as Kwak puts it, "the unfounded fear is that it's unrecoverable." Patients at his clinic in New York include many young singers who feel something abnormal in their throats, and are "shaking and sweating" in anticipation of a diagnosis of nodules.

"90% of them have totally normal looking cords, and when they find out they don't have nodules, they start crying." It's a source of stress for singers at all points of their career, and one that Kwak wants to relieve and demystify. "What a thing, to be so preoccupied with the idea that if you have nodules, it's a career ender," he says. "That is one of my soap boxes and missions in my career, to try to undo some of that."

For many working singers, it may seem as though anomalies on the vocal cords are rare and catastrophic symptoms of vocal damage, but Kwak insists that structural pathologies are much more common than people think. "People would be shocked to know who is in our offices and who has 'stuff' on their cords," he says. "Lead singers who appear frequently at major opera houses around the world."

Simply put, Kwak believes, "a structural pathology is not a career-ender." He is quick to clarify that it's "not quite the message" to say that there is no consequence to having nodules or cysts on the cords. Still, "I think of all the people that we know in major houses, in major companies, in all genres of singing, who are singing with 'structural pathology' and thrilling and touching us night after
night."

>For more about Dr. Paul E. Kwak, start by following him on [Twitter](https://twitter.com/paulekwak) and visiting the NYU Langone Medical Center [website.](http://nyulangone.org/conditions)
