+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-03-12T14:28:00+00:00"
lastmod = "2017-03-21T14:31:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1489331744272/2017-03-12---Zachary-Nelson.jpg.jpg"
primary_image_credit = "Photo: Dario Acosta."
publishDate = "2017-03-21T14:12:00+00:00"
related_articles = ["articles/talking-with-singers-luca-pisaroni.md","articles/talking-with-singers-craig-irvin.md","articles/talking-with-singers-ailyn-perez.md","articles/young-singers-in-santa-fe-stephen-martin.md","articles/don-pasquale-a-colorful-season-starter-at-minnesota-opera.md","articles/talking-with-singers-clarence-frazer.md"]
related_companies = ["scene/companies/the-santa-fe-opera.md"]
related_people = ["scene/people/zachary-nelson.md"]
short_description = "&quot;When I was in Chicago doing Das Rheingold, it was the first Wagner I&#039;d ever done,&quot; Nelson recalls. &quot;I was sitting onstage on opening night, and Eric Owens is just wailing away [as Wotan]. I&#039;m standing there on the stage with him, and I just started welling up.&quot; It was a moment in his career that will stick with him, and which offered a clear picture of the rewards that remain in store for the young baritone."
slug = "talking-with-singers-zachary-nelson"
title = "Talking with singers: Zachary Nelson"
+++

"When I was in college, the only thing I had in my head was, I have to make it to the absolute top as fast as possible." Ambition was never something that American baritone [Zachary Nelson](/scene/people/zachary-nelson/) lacked, and he remembers the [Opera Apprentice Program at Santa Fe Opera](https://www.santafeopera.org/about-us/apprentice-opportunities/singers/about-the-program) as one of his earliest professional goals. "I'm a freshman in college, I barely know how to read music, my skills are deplorable at this point," he recalls, adding that his first application for Santa Fe resulted in a "resounding" rejection. 

Now, he laughs at his reaction to his missed opportunity in Santa Fe. "I was like 'how dare they?' I was so cocky." Convinced he needed to be singing in specific places by a specific time, "I thought, 'I have to be there now.' But really, I don't have to be there now."

"I think I was in a rush because I couldn't see the forest through the trees," he says. "I still have trouble with that, sometimes." Of course, it's easier to see the proverbial forest in hindsight, and now, Nelson's busy international career speaks to the rewards of playing the long game. Eventually, he did earn a spot in both Santa Fe's young artist program and its mainstage season; over the last several years, Nelson has made major debuts at Lyric Opera of Chicago, San Francisco Opera, and the Canadian Opera Company.

"You get the idea that these are massive companies and they're A houses," says Nelson of his notable company debuts. "I get the feeling I want to walk in with a suit and tie every day and be very buttoned-up." Despite any expectations, Nelson found that like smaller companies, big houses are full of people who have the same creative goal. "You get to the house and you start working with the people, and it's just another production," he explains. "It's just a bunch of people that just want to put on the best show possible."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1489854582496/2017-03-18---Nelson-Escamillo%2BSZ%2B1.jpg.jpg)
<figcaption>Zachary Nelson as Escamillo in *Carmen*, Salzburg Landestheater. Photo by Anna-Maria Löffelberger.</figcaption>
</figure>

## "I think all of us have a bit of a bad guy in us."

One notable difference in working at major opera houses is the size of the audience, and that's something that gets Nelson excited. "You get to really share with as many people as possible." In recent seasons, he has kept busy in roles like Belcore (*L'elisir d'amore*), Figaro (*Le nozze di Figaro*) and Escamillo (*Carmen*); particularly with the latter, Nelson's singing includes some of opera's most famous hits. "I think that's the best part of the job," he says of singing well-loved tunes like the "Toreador Song" in *Carmen*. "When you get to sing on the hits - like a tenor singing 'Libiamo' [from *La traviata*] - a lot of people go to the opera for those moments."

Nelson made his Wagner debut last fall in Chicago, singing Donner in *Das Rheingold*, and he's currently preparing to sing Enrico in *Lucia di Lammermoor* at Santa Fe Opera. Interestingly, the friendly baritone finds himself drawn to what he calls "the companions". Characters like Marcello in *La bohème*, or even Figaro in *Il barbiere di Siviglia*, come with a sense of camaraderie and play. "In *Barber*, [Figaro] is messing around, and he's plotting with his best friend [Almaviva]. They're constantly trying to play jokes and prank Bartolo," says Nelson. "These companions, for some reason I really connect with them."

Of course, few people can resist playing a villain, and Donizetti's Enrico comes with a few guilty pleasures. "I'm also always hoping for a bad guy, especially one that's trying to kill a tenor," he laughs. "Studying a role like Enrico, who's this despicable character, you want to say, 'I'm not like this at all'." Yet Nelson has found that the trick to playing a bad guy is approaching the character with some real sympathy. "Connecting with a villain, I want to say it's hard, but it's kind of not, because I think all of us have a bit of a bad guy in us."

"It's like a guilty pleasure. 'Oh my gosh, I kind of get where he's coming from.'"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1489854593394/2017-03-18---Nelson-Figaro%2BDD%2B5.jpg.jpg)
<figcaption>Zachary Nelson as Figaro in *Le nozze di Figaro*, Dresden Semperoper. Photo: Matthias Creutziger.</figcaption>
</figure>

## "Don't get lazy."

Nelson is a singer who seems to take his nomadic lifestyle in stride. "Living on the road, in general, has made me incredibly minimalistic," he says. "I'm really good at packing." He's also good at packing some semblance of a routine, including "half a kitchen". Waking up to his trusty Bialetti coffee maker counts as one of the little daily details, which "keep me sane".

Maintaining a routine - both inside and outside of the rehearsal room - can be one of the most difficult skills for working singers to learn. Nelson finds his balance in that cure-all, moderation. He stays true to his schedule of work, exercise, and healthy eating, swearing by a simple rule: "Don't get lazy."

As important as rest and routine are, Nelson doesn't subscribe to a hermit-like life between rehearsals "If I'm itching for a burger and beer, and I don't have a show the next day, I'm going to go get that burger and beer," he admits. "I don't want to be constantly in my own head, thinking about the state of my vocal cords."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1489854606026/2017-03-18---Nelson-Malatesta%2B3.jpg.jpg)
<figcaption>Zachary Nelson as Dr. Malatesta, with Andrew Shore as Don Pasquale in *Don Pasquale*, Sante Fe Opera. Photo: Ken Howard.</figcaption>
</figure>

Nelson has also found the benefits that come from several years of work in various houses around the world. "If you work long enough, the world gets smaller and smaller," he says, referring to the small pockets of temporary community he finds among his colleagues on various gigs. Along with the new introductions in new cities, he finds that the real joy can come from crossing paths with old friends along the way. "It's a friendship that you can just pick up, and it's really comforting."

"I definitely miss home a lot. I miss a lot of my friends," he says, not alone in his regret for missing birthdays, weddings, and new babies as he works in all corners of the globe. Yet it seems that, at least for now, singing is worth the sacrifices.

## To just be a little cog in that, it's so gratifying.

"When I was in Chicago doing *Das Rheingold*, it was the first Wagner I'd ever done," Nelson recalls. "I was sitting onstage on opening night, and [Eric Owens](/scene/people/eric-owens/) is just wailing away [as Wotan]. I'm standing there on the stage with him, and I just started welling up." It was a moment in his career that will stick with him, and which offered a clear picture of the rewards that remain in store for the young baritone.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1489854661352/2017-03-18---Nelson-LOC%2BDonner%2B1.jpg.jpg)
<figcaption>Zachary Nelson as Donner with Laura Wilde as Freia in *Das Rheingold*, Lyric Opera of Chicago. Photo: Todd Rosenberg.</figcaption>
</figure>

He has now worked with enough operatic veterans, whose careers span decades, to recognize the slow burn of the business. "You do shows with people who have been in this industry for twenty years or longer, and it's kind of funny how relaxed a lot of them are," he explains. "And then there are people like me, who are green at times. We want to do everything we can in one day of rehearsal." Nelson, like most singers with his level of love for opera, seeks a career of longevity, meaning he's in the middle of "a marathon, not a sprint."

We asked Nelson if he had ever thought about why he chose opera as a professional pursuit. "I think that's a question I'm asking myself once a week," he laughs. "And the answer, honestly, changes a lot." His jokes that his mother, who was a singer herself, "brainwashed me as a little kid, playing Met broadcasts in the car." Though he didn't look seriously at singing until his late teens, Nelson has a clear love for opera. "The fact that I get to do this for a living right now, it's just an experience."

In opera, "the music is amazing, the drama is, I think, unparalleled. To just be a little cog in that, it's so gratifying."
