+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-10-28T11:01:00-04:00"
lastmod = "2018-10-28T19:47:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540737217938/sqThomasHampson_byJiyangChen_1.jpg.jpg"
publishDate = "2018-10-28T19:47:00-04:00"
related_articles = ["articles/talking-with-singers-luca-pisaroni.md","articles/talking-with-singers-matthew-polenzani.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/thomas-hampson.md","scene/people/isaiah-bell.md"]
short_description = "&quot;As a singer, as a professional, experienced singer, older colleague,&quot; Hampson advises young singers entering the profession, &quot;I can only say that the industry you&#039;re in is not the industry I started in.&quot;"
slug = "talking-with-singers-thomas-hampson"
title = "Talking with singers: Thomas Hampson"
+++

"Nude was always off the table," says Thomas Hampson of the much-anticipated love scene he would stage as the title role in Rufus Wainwright's second opera, *Hadrian*. "There were various contemplations of clad and unclad, for both of us." For all the experience in Hampson's career - three decades, over 80 roles, and 170 recordings - a homosexual love scene was a first for the famed baritone.

Director Peter Hinton noted that this wordless scene, musically scored with great care by Wainwright, is a rare onstage moment of tenderness and love between two men. Though audience members may have been voyeuristic in their curiosity over the scene - and perhaps the chemistry between Hampson and up-and-coming Canadian tenor Isaiah Bell, who sings the role of Hadrian's lover Antinous - the creative team behind *Hadrian* was focused instead on defining deep intimacy between the two men.

Regardless of whether the focus of the scene is on the physical - how much skin was shown, or how graphic the action would become - or about depicting love, a sex scene is certainly a vulnerable thing to rehearse. "It was a very methodical, slow process," says Hampson of his work with intimacy coach Siobhan Richardson. "It's really about what physical gestures mean what, and what physical gestures convey what."

Creating this scene was a small part of the staggering task of creating a new opera; Hampson, though he admits to minimal influence in *Hadrian*'s genesis, took judicious opportunities to vouch for the importance of the voice. Where Wainwright's original writing for Hadrian was too low for Hampson to sing with maxiumum impact, the baritone made the case for revisions. "I essentially rewrote the second half of the trio [with Antinous and Sabina], and [Rufus] was thrilled," he says. "It was all about what makes this work."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540737356455/COCHadrian_photobyCatherinePisaroni_LennysStudio.jpg.jpg)
<figcaption>Thomas Hampson (Hadrian) and Isaiah Bell (Antinous) in the Canadian Opera Company's world premiere production of *Hadrian*, 2018. Photo: Catherine Pisaroni/Lenny's Studio.</figcaption>
</figure>

Hampson's status as an operatic A-lister has earned him the clout to add his two cents to a composer as he writes a world premiere. Yet he's aware that it's not the same for his younger colleagues - and not just because of seniority.

"As a singer, as a professional, experienced singer, older colleague," Hampson advises young singers entering the profession, "I can only say that the industry you're in is not the industry I started in." His impressive discography, much of which is devoted to his acclaimed interpretations of German Lied, is something that "no one on the planet today" could accomplish, even over multiple decades of work. "The recording industry, the radio industry, all of that is completely different."

And in the world of opera, Hampson bemoans the few and far-between chances that young singers have to learn their craft. Despite their entering an environment where there is a dearth of ways to gain professional experience, opera's artists are under a level of scrutiny that has never been higher. "The fishbowl we all live in is pretty horrifying for young singers, much less the lack of opportunity," he says.

Perhaps depressingly, Hampson compares the modern industry with his own early years, where he racked up roles of all sizes at houses like the Deutsche Oper am Rhein in Düsseldorf and the Zürich Opera House. Each time he stepped onstage, there seemed a symbiotic agreement between Hampson and the company he sang for, that his performance was part of a long-reaching professional trajectory. 

"There was this foregone conclusion that with every operatic role and experience, you should develop into something vocally and theatrically better," Hampson says. "I don't see that kind of emphasis today."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540737290090/ThomasHampson_byDarioAcosta_2.jpg.jpg)
<figcaption>Thomas Hampson. Photo: Dario Acosta.</figcaption>
</figure>

What he does see is a focus not on developing opera singers, but on developing opera productions. With the integrity of a singular production a growing priority, companies are on the hunt for singers who fit a specific aesthetic - be it musical or visual; and in response, singers are training not to become autonomous and unique artists, but to become useful to the operatic industry. In fact, they're persuaded to do so, Hampson argues. "We no longer encourage young singers to become singers. We teach them how to become voices that are useful for an industry purpose. That bothers me a lot, as a pedagogue."

It leaves a bad taste, to see evidence of the opera industry losing its noble aim to put excellent voices above all. The ripple effect is significant: as young singers shift their focus toward fitting into industry pigeon-holes - clearly-defined voice types, an "HD-ready" physical appearance - their time is no longer spent on the crux of the whole industry: telling stories *with the voice*.

Perhaps it's Hampson's continuous work in art song that has kept him tethered to this basic tenet of his profession; without costumes, sets, or director's "concepts", a recital singer is left with the simple tools of voice, melody, and text. "A young singer who doesn't sing songs is just going to have a different process of finding the internal life of who he or she is on stage," says Hampson. "There's not an opera singer on the planet who wouldn't benefit from singing songs."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540737297642/ThomasHampson_byDarioAcosta_1.jpg.jpg)
<figcaption>Thomas Hampson. Photo: Dario Acosta.</figcaption>
</figure>

Simply put, the opera industry's "insatiable production mentality" is at the expense of a focus on the voice. For Hampson, a display of excellent singing "was always about the absence of reality, it was never about the display of voice. However, you cannot portray the absence of reality without the vehicular ability to sing those notes."

Perhaps it's because it's difficult to do well, and perhaps it's because it's expensive to produce, but Hampson sees classical music and opera at a crossroads. "The viability of the art form today is fighting with the essential philosophical question of entertainment versus development."

And Hampson is not ambiguous in his siding firmly with the integrity of the art form. "You show me the letters of the great composers that talk about 'timbres' and 'types', and I'll shut up," he says. "They talk about people representing others' emotions."

>Hampson [heads next](https://thomashampson.com/category/calendar/) to Austria, Israel, Germany, and the United States before his return to Toronto in April, in concert with bass-baritone Luca Pisaroni. For more, follow Hampson on [Twitter](https://twitter.com/thomashampson), [Facebook](https://www.facebook.com/w.thomashampson/), and [Instagram](https://www.instagram.com/thomashampson/).
