+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-08-30T11:06:00+01:00"
lastmod = "2016-08-31T12:54:00+01:00"
preamble = "For successful character tenors, it can seem as though they have sung in every opera, at every opera house in the world; no different is the career of American character tenor [Steven Cole](/scene/people/steven-cole/), who has spent his four-decade career inhabiting the comprimario roles of *The Magic Flute*, *Madama Butterfly*, *Les contes d'Hoffmann*, *Ariadne auf Naxos*, *Boris Godunov*, and *A Midsummer Night's Dream*. He is featured in [John F. Martin's *In Character: Opera Portraiture*](https://www.amazon.com/Character-Portraiture-John-F-Martin/dp/1574674536), as Sellem, the auctioneer, in Robert Lepage's production of *The Rake's Progress* at San Francisco Opera.\n\nThis season, Cole sings Don Basilio and Don Curzio in Stephen Lawless' production of [*Le nozze di Figaro*](https://www.kcopera.org/performances/the-marriage-of-figaro-16/) at Lyric Opera of Kansas City, and he joins the Atlanta Symphony for Christopher Theofanidis' oratorio [*Creation/Creator*](https://www.atlantasymphony.org/ConcertsAndTickets/Calendar/2016-2017/CS17-Theofanidis-Creation-Creator). \n\nCole's life onstage is an extraordinary one, and we were thrilled to have the chance to ask him about opera, Broadway, sharing the stage with Jessye Norman, and what he calls the \"the best job in the world.\""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1472642487517/2016-08-31---Cole.jpg.jpg"
primary_image_credit = "Photo courtesy of CAMI."
publishDate = "2016-08-31T12:49:00+01:00"
related_articles = ["articles/talking-with-singers-russell-thomas.md","articles/talking-with-singers-craig-irvin.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md","scene/companies/opra-national-de-paris.md","scene/companies/canadian-opera-company.md","scene/companies/san-francisco-opera.md","scene/companies/houston-grand-opera.md","scene/companies/washington-national-opera.md","scene/companies/seattle-opera.md","scene/companies/salzburg-festival.md"]
related_people = ["scene/people/steven-cole.md"]
short_description = "&quot;I have a secret: I have taped (yes, old fashioned) every performance out of my mouth for 40 years. So I always listen to the tape before the next performance and make little notes: &#039;too much consonant on X...sharper rhythms at Y...Steven, enjoy more the double consonants tonight...stay more in head...E flat was flat...support more...keep the legato in that passage...that went well, you reached all your personal goals in getting the text across...&#039;&quot;"
slug = "talking-with-singers-steven-cole"
title = "Talking with singers: Steven Cole"
+++

## What do you think are some unique challenges and joys of playing a character role?

The only challenge I can think of - which isn't really a challenge - is that one must be musically impeccable. If one is doing *Madama Butterfly*, we are in trouble if the Goro has to be musically corrected! One needs to know their role inside and out, and be prepared to sing it any way requested by the director. As far as the conductor is concerned, I consider our work collaborative. 

My job is pure joy. I love my *Fach*. The variety means you are never bored.  I always say, imagination is currency. I get to be wildly inventive in telling the story. 

## What did you learn about performing during your time on Broadway? How does that world compare to opera?

Well, first when I was performing on Broadway, I got to bike to work from my apartment! Singing operatic character parts, I have had to travel to Austria, Australia, Belgium, Canada, England, France, Italy, Spain, and Switzerland. Hardly "had to." The traveling was joy. And an honor. 

Of course on Broadway, dancing was often a part of the job. 

I always try to keep it fresh by doing something different every performance whether at the Salzburg Festival or singing Sportin' Life on Broadway. I never thought it was a big deal, until recently a colleague said: "I can't believe you change it every night." Now, note the changes are within the framework of what we have rehearsed. 

Broadway does teach stamina. And although it is not in my official bio, at the very beginning of my career I did a popular nude show off-Broadway. Now that will teach you to have NO fears! In fact, when we are up there before 3,000 people, we are nude. 

Also, on Broadway, one doesn't say, "I can't do THAT and sing." I do the same thing in opera: if they want me to roll down the stairs and then sing my aria, done. If they want me to tap dance while singing Sellem's difficult music, done. One learns flexibility and how to relish being versatile. 

## How have you kept yourself in good vocal and physical health over a four-decade career?

One should never forget the role that luck plays in life and your career. And luck can be "encouraged." 

For example, when I was lucky enough to make my European debut in Aix-en-Provence singing Monostatos in German, my spoken French was pretty good. So it was considered exotic, fun, and helpful to the PR department to have me do interviews in French. So I was in the right place with the right skill. Lucky. That production was a co-production with Nice, Lyon, and televised.

It was an audition having it on television, that led to my having sung a wide variety of repertoire in Avignon, Bordeaux, Caen, Grenoble, Lyon, Marseille, Monte Carlo, Nantes, Nancy, Paris, Perignan, Strasbourg, Vichy. Not to forget Lausanne and Geneva. Luck. That was a long way of saying, my health vocally and physically is luck. 

But needless to say, I exercise regularly, ride my bike everywhere. And sing repertoire that is right for me. I stay in my lane. People used to always say: "But don't you want to sing Tamino rather than Monostatos?"

And I would say, "No, I want to sing Monostatos with Tamino's fee, which is what I do!"

## Was it a conscious decision to focus on character roles?

Yes. There were two indications that that was my direction.

After studies in Paris, briefly with Pierre Bernac, and then London with an Australian named Arnold Rose for about 3 years, I came back to the USA and was a fellow at Tanglewood studying with Phyllis Curtin. During that summer, Seiji Ozawa was not happy with the Monsieur Triquet for a concert version of *Eugene Onegin* They dragged me out of Curtin's class to audition for Seiji (sight-reading the score in French. Ah, youth!) 

Two nights later I made my debut with the Boston Symphony. And got very positive feedback. Then I sang the Crabman in *Porgy and Bess* for the Houston Grand Opera. And constantly got mentioned in the press for my 3 minute performance. It became very evident that that was my direction. 

I used to do silly things like audition for the summer program at Santa Fe with a *Clemenza di Tito* aria because I had a coloratura facility. Needless to say, I did not get into their young artist program!  But David Gockley, who ran Houston Grand Opera, was so impressed with that Crabman that he asked me to leave the tour and sing Dr. Caijus in *Falstaff* in the main house (although I prefer my beloved Bardolfo). I love my repertoire. 

## What have been some of your professional highlights thus far?

So many. It was thrilling to sing the revised version of Ligeti's *Le Grand Macabre* in Salzburg with Esa-Pekka conducting and Peter Sellars directing, with Ligeti at every rehearsal. It was wonderful to make my Met debut as the Dancing Master in *Ariadne auf Naxos* with the likes of Jessye Norman, Kathleen Battle, Tatiana Troyanos, Herman Prey, with James Levine conducting. I loved doing my "Animals, big and small" in the foyer of the re-opened/renovated Liceu in Barcelona. And singing *Ariadne* there with Gruberova. 

It was delightful to sing all three Monteverdi operas with Michel Corboz in Lausanne.  Fabulous to have sung Boieldieu's *La Dame Blanche* and *Carmen* at the Opéra Comique, where they were premiered. 

It was fabulous to be singled out as one of the best performances of the season in San Francisco when I sang The Scrivener in *Khovanshchina*. And I have gone to Australia twice, for *Butterfly* and *Fanciulla*. It is always an honor to be invited so far away to do your craft. And just last summer it was delightful to sing Cavalli's *Veremonda* at the Spoleto Festival. I always love singing Baroque opera. The character tenor traditionally ends an act! 

Singing Linfea in *La Calisto* in Salzburg with René Jacobs was pretty heady. 

Etc., etc., etc.

## Do you have any routines or habits on the day of a performance?

I like to be physically active earlier in the day. The voice is warmed up when the body is warmed up. Lately, I have been singing Mozart recitatives to warm up. But everything for me is text driven. I often say my text as though I am a radio announcer. 

And at every performance I have a different goal. I have a secret: I have taped (yes, old fashioned) every performance out of my mouth for 40 years. So I always listen to the tape before the next performance and make little notes: "too much consonant on X...sharper rhythms at Y...Steven, enjoy more the double consonants tonight...stay more in head...E flat was flat...support more...keep the legato in that passage...that went well, you reached all your personal goals in getting the text across...don't rest on your laurels tonight," etc. 

One of my favorite activities on the day of a performance is to go to an art museum. It makes me meditative. And emotionally ready to spend 5 hours in the theater. 

## Why do you sing professionally?

I have the best job in the world. In fact, I am a social worker. A giver. I make peoples' lives easier through performing. They come to the theater to forget their woes for a few hours. Music is my mistress. And I approach my career as a job. I never take it personally if someone doesn't like my work. My business is very subjective. I am not to everyone's taste. One just wants enough people who feel you are their *plat du jour*. 
