+++
author = ["authors/eva-cahen.md"]
categories = "Interview"
date = "2019-01-30T00:48:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "San Diego Opera's production of _Rigoletto_ runs February 2-10. For details, [click here](https://www.sdopera.org/season/2018-2019-season/rigoletto)."
preamble = "American baritone Stephen Powell is singing the title role in _Rigoletto_ at the San Diego Opera on February 2, 5, 8, and 10. The production is directed by Michael Cavanagh and the conductor is Steven White. Alisa Jordheim is Gilda and Scott Quinn is the Duke of Mantua."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1548813295/media/2019/01/sqSDORigolettoPowell.jpg"
primary_image_credit = "San Diego Opera presents Verdi's masterpiece, Rigoletto, February 2-10, 2019, starring Stephen Powell (pictured) in the title role. Photo by Cory Weaver for The Portland Opera."
related_articles = ["articles/talking-with-singers-matthew-polenzani.md", "articles/talking-with-singers-morris-robinson.md"]
related_companies = ["scene/companies/san-diego-opera.md"]
related_people = ["scene/people/stephen-powell.md"]
short_description = "I wanted to be Billy Joel when I was growing up because he was a classically trained pianist too. He wrote his own music, sang his own stuff, arranged his own music, his songs, and told a story."
slug = "talking-with-singers-stephen-powell"
title = "Talking with singers: Stephen Powell"
youtube_url = ""

+++
**Why do you sing?**

The human voice is, without disrespect to other instruments, the most immediate and visceral. As human beings, we all have a voice and we all have the same bodies. Even people who are not musicians or have no musical knowledge can relate to that. You can witness it in how people follow music in everyday life, whether it's classical, rock, pop or jazz. The things we talk about most are the voices and the singers, or bands, like the Beatles. In opera it's really about the voice.

I began as a piano major at Northwestern University and came to the voice after. A voice professor for whom I played heard that I sang and started to give me lessons. He encouraged me to change and pursue voice as a vocation. After I got to Northwestern, I realized that a piano performance major really was not for me. My personality is not solitary. I wanted to collaborate and be with other people, even as much as I love the repertoire and playing the piano.

Voice is a challenge because of how difficult it is and how much time it takes to perfect it, to develop the technique that you need to sing this kind of repertoire in a healthy way, and to maintain longevity as well. I also loved being on stage. It suited my personality, which is more demonstrative and outgoing. I found my niche there.

I wanted to be Billy Joel when I was growing up because he was a classically trained pianist too. He wrote his own music, sang his own stuff, arranged his own music, his songs, and told a story. The voice was more important than the music. From a young age, I was fascinated and drawn to the human voice. That's why I sing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548812993/media/2019/01/StephenPowell.jpg){{% /md %}}

<figcaption>Stephen Powell, baritone.</figcaption>

</figure>

**You're performing Rigoletto in San Diego starting Feb. 2.  Rigoletto is, to say the least, a strange kind of character, an anti-hero probably, if he’s a hero at all. He's outright unlikable in the beginning - mocking, cynical, and teaming up with an assassin without much regret. Yet, he's completely vulnerable in his love for his daughter. How do you put all those contradictory character traits into your performance?**

The complexity of Rigoletto's characters is fairly human because none of us are all one thing. We have a dark side. We also have a tendency to show parts of our personality in public and other parts in private. Rigoletto is a conflicted and angry person and he is also a father. He is in a tenuous position at best and has to care for his daughter. He has a job and he's lucky he's not homeless.

> My wife (soprano Barbara Shirvis) is a singer too. When we go home, we can just be normal human beings and relax. Other people might not have the opportunity to vent or let out in an artistic environment. We're lucky that way.

I can relate to those conflicting feelings as a human being. I can relate to being a father because I have two sons (18 and 20), and to trying to protect your children from the big bad world. A daughter is even harder, especially in this time period, and having no control. Part of his anger is about what he does as a jester for these awful people because he has to maintain a home and some kind of semblance of a life to protect his daughter and to survive. We discussed this in rehearsal, how we all endeavour to protect our loved ones, and this can create the exact thing we are trying to avoid. I am over protective and the unintended consequences of my overbearing love is to actually make her do exactly what I'm trying to stop her from doing.

Rigoletto is able to tap into his resentment and anger in his job because he can make fun of the nobility within the safety and protection of the Duke. He can vent whereas any other person would have their head cut off. I relate to that as a singer. You can get your emotions out in the characters you play onstage, display your passions in an environment that's safe and accepted and encouraged. It's helpful as a human to be able to sing your emotions out and to participate in relationships that you can understand with other characters within the opera. My wife (soprano Barbara Shirvis) is a singer too. When we go home, we can just be normal human beings and relax. Other people might not have the opportunity to vent or let out in an artistic environment. We're lucky that way.

Maybe the two sides of Rigoletto are very extreme. Obviously, he has very quick temper and then he turns very quickly to be the tenderest of fathers, which is confusing to Gilda. It's confusing to any child when they see a parent that's polarized like that.

**I understand that Rigoletto is also vocally challenging. Can you talk about the challenges of it? How does it compare to some of the other roles you've performed?**

Of the Verdi roles, it is longer and sits higher in the voice. Because of the character, the hump, sometimes a limp, and because your body isn't as erect or in a position that you're used to singing in, it requires more energy and more technical facility. Pacing how you sing this role is really crucial because one of the last notes is the highest note that you sing in the entire opera. It’s interpolated but it's expected.

It takes some years to get to the point where you think you can sing it and determine if it’s safe and right for you - getting it into your voice in a way that's not harmful and allows you to finish the role in a healthy manner. The difficulty of it is all those things. To compare it to the other Verdi roles, it's a little longer and a little higher. Iago is difficult too and it’s pretty high. All the Verdi roles have their difficulties. They require a lot of energy, a lot of mental focus. Not that Mozart and Bach don’t, they certainly do, but it's a different style.

> When people say they don't like Mozart or they prefer the romantic period, I honestly don't understand it, even if everyone has their own opinion. There's really nothing I don't like.

A Verdi baritone is a specific type of baritone that you grow into as you mature. It's a physicality of maturation within your body. Some people are that from the beginning, but not many. I sang my first Verdi roles when I was 34. It was Ford in _Falstaff_ and then I did Germont in _La Traviata_. You have to sing the right repertoire that's right for your voice. I didn't come to _Rigoletto_ until my early forties.

About a year ago, I jumped in to do the Count in _Marriage of Figaro_. I hadn't done Mozart in probably 10 years. It was interesting and very helpful vocally to realize that I could still do Mozart healthily and well, and that singing Verdi hadn't made my technique go off the rails. If you don't sing it correctly, you compensate with other parts of your body and it can damage your voice. I was happy to know that I could still do the Count, which was a lot of fun.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548813427/media/2019/01/SDOTraviataPowellWinters.jpg){{% /md %}}

<figcaption>Stephen Powell (Germont) and Corinne Winters (Violetta) in La traviata, San Diego Opera, 2017.</figcaption>

</figure>

**I saw this is your fifth production of _Rigoletto_. How is Director Michael Cavanagh's approach to this opera and this character different from the other _Rigolettos_ you've performed?**

I love it that Michael has a plan and is very organized. We had a very short rehearsal period – we basically staged this in a week, maybe eight days. That's a little different than other productions I've done. I appreciate Michael so much because he knows the show. All the things he talks about, like the choices, the character, and the movements on stage have purpose and meaning that are driven by the music. He is very tuned into the music.

I've worked with Steven White, the conductor, before. He's a great singing conductor and he's married to a soprano, Elizabeth Futral. He knows the voice inside and out. He's very attentive to our needs on stage, very connected to us, and a great musician with a great technique with this baton. The two of them together have really made the process go smoothly, which I appreciate very much. Plus, my colleagues are terrific. This is my tenth production in San Diego. I know the people and I know that the atmosphere is always relaxed, supportive, and positive. I knew that coming here and that gives you a peace of mind that you don't always get.

**You sing a very wide range of roles. You sing from the baroque to the modern, you sing concert presentations and operas, you sing in English as well as many other languages including Italian, German, and Russian. Is there any one period you are most at ease in? Any one language? Is there any one form that you prefer?**

I'm the type of person who needs a variety of things to challenge me. With the piano repertoire, I played all the way from baroque to modern - Bach, Mozart, Beethoven, Brahms, Schumann, Stravinsky and Rachmaninov. That spanned my musical experience before I started singing opera. I was introduced to Monteverdi early in choirs. I loved it all and couldn't get enough. When people say they don't like Mozart or they prefer the romantic period, I honestly don't understand it, even if everyone has their own opinion. 

There's really nothing I don't like. I see it as a challenge and a privilege to have the opportunity to bring to life music that is 300 or 400 years old, or 100 years or 50 years old, to try to understand what the composer was thinking in his time period, why he said what he said or she said, and why he chose to set the text the way he did. I ended up with a theory and composition degree because I changed from piano. I studied the construction of music as well as the harmonic and thematic structure, the instrumentation and orchestration. I was always fascinated by what composers did technically on the page to elicit the emotions or to characterize the text. It's fascinating to me and there are so many great composers. For example, five or six different composers have set the same Goethe poem in their own language and all of it is great.

> There's so much you cannot do until you are out there in performance, figuring out what has to happen and what you need. It takes a couple of times.

As an opera singer, to have approached it systematically and slowly as I did, slowly to make sure I was healthy, to come to the point where I can sing Rigoletto, that's a huge source of satisfaction and joy for me. I love singing the Verdi repertoire. The roles of Rigoletto, Iago, Macbeth, Germont, Falstaff – these are some of the greatest characters in literature.

With languages, Italian is of course the greatest, but I love singing in all of them. They each have their own unique way of conveying ideas and feelings and emotions. Russian is a great language for singing. It feels really good in the mouth. It rolls off the tongue. Like Italian, it has great vowels for singing and lends itself to that. But German has all the plosives like _ich_ and _ach_, that are less vowel-oriented and more consonant. It’s a challenge in and of itself and also lends itself to another kind of expression. French is a challenge because of the closed vowels, a lot of the _u_ and _i_ sounds don't lend themselves to an open throat and operatic singing. It's challenging to convey the language purely, but in a vocally healthy way, and to express the nature of French poetry and music in the styles that are required for each.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548813570/media/2019/01/SDOButterflyStephenPowell.jpg){{% /md %}}

<figcaption>Stephen Powell (foreground) as Sharpless in Madama Butterfly, San Diego Opera, 2003.</figcaption>

</figure>

**What are some of the opera roles you would like to perform that you haven't done yet?**

There are a few Verdis I've not done, like _Nabucco_, _Ballo_, _La forza del destino_, _Ernani_ - but they're not done very often. There are also ones I'd love to do more, like _Trovatore_, _Macbeth_, _Otello_ and _Falstaff_. I would love more shots at them. It takes a couple productions to get a role into your body and into your voice, and to have a chance to explore it. There's so much you cannot do until you are out there in performance, figuring out what has to happen and what you need. It takes a couple of times. I would also love to do, now that I'm middle aged, some of the classic musical theater like _South Pacific_, _Camelot_, _My Fair Lady_, and _Oklahoma!_ even if the guy is younger. I do _Sweeney Todd_ a lot, and that's fun.

> Opera gets knocked a lot because people can't act - although that has become more emphasized in the last 20 years, which I think is fantastic because I believe both can happen.

**I did notice that you also sing musical theater. For purists, is that as challenging as opera or less challenging? Do you have a preference for either?**

If you're going to do eight shows a week, that's pretty challenging. The issue of course is miked as opposed to not miked. I've always done _Sweeney Todd_ miked because that's how Sondheim wrote it, but it's operatic in scope. You still need to have some classical training to sing it really well and to have an understanding of the voice.

I don't want to be too negative about what's happening now, but in my opinion, for Broadway, they are singing in a way that’s less connected to their body and more reliant upon the microphones. The sound changes. There's a different way of forcing the sound through the resonators in your skull. It's different than opera and classical singing. I'm not a great fan of the style of singing right now, which is why I mentioned those classics. People like Gordon MacRae, Howard Keel, John Raitt, Shirley Jones, Julie Andrews, and Mary Martin, in the heyday of the 40s, 50s, 60s, and 70s, were classically trained and didn't have microphones in the theater. They had to project the same way we do. It's only after the microphones became available and the sound system started to change and be used in smaller theaters on Broadway that the style and the vocal production also started to change.

Another difference is that musical theater is character-driven while opera is musically driven. So musical theater requires really good acting. I think it's much more expected, a much more needed characterization for those performers. Opera gets knocked a lot because people can't act - although that has become more emphasized in the last 20 years, which I think is fantastic because I believe both can happen. If you are a good performer, you study properly, and you care enough, you can act and sing at the same time, both equally well. Same argument between what's more important – the music or the words. They're both important and a good performer who spends the proper amount of time on both does a good combination of the two. They can't really be separated. One is not more important the other. Both of them can be presented in an equal way.

**Thank you so very much. It was really a pleasure meeting you.**