+++
author = ["authors/eva-cahen.md"]
categories = "Interview"
date = "2019-05-06T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "Stephen Costello and Stephen Powell present _One Amazing Night_ on May 15 at the Balboa Theatre. For details and tickets, [click here](https://www.sdopera.org/season/2018-2019-season/one-amazing-night-2019)."
preamble = "San Diego Opera is presenting [_One Amazing Night_](https://www.sdopera.org/season/2018-2019-season/one-amazing-night-2019) on May 15, 2019 at the Balboa Theater in San Diego with two American operatic stars, tenor Stephen Costello and baritone Stephen Powell. I had the opportunity to ask Stephen Costello some questions a few weeks before the recital while he was still busy singing the role of Alfredo Germont in _La Traviata_ at New York's Metropolitan Opera."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1557186341/media/2019/05/sqStephenCostello-pc-SimonPauly.jpg"
primary_image_credit = "Photo: Simon Pauly"
related_articles = ["articles/talking-with-singers-clay-hilley.md", "articles/talking-with-singers-eleazar-rodriguez.md", "articles/talking-with-singers-stephen-powell.md"]
related_companies = ["scene/companies/san-diego-opera.md"]
related_people = ["scene/people/stephen-powell.md", "scene/people/stephen-costello.md"]
short_description = "\"In my off time, I come home. My wife Yoon and I live in NY. She plays violin in the orchestra of the Metropolitan Opera. I don't get enough of a chance to see her and I'm hardly ever at home.\""
slug = "talking-with-singers-stephen-costello"
title = "Talking with singers: Stephen Costello"
youtube_url = ""

+++
**How is it different to do a recital than a whole opera?**

A recital doesn't have nearly as many elements as an opera. There are no costume changes and no fittings. The orchestra is usually behind you rather than in front of you. In an opera, you might be on stage for an entire scene for 30 or 40 minutes. At a concert, you sing one aria, and then there might be someone else with you, or you could walk off the stage.

It's not that one is easier than the other because it is still the same amount of opera singing. Each has its own challenges. For instance, you’re not carrying the entire show all night in an opera. You're usually there with other colleagues. It's more of a group effort. In a concert, it's usually just you and the orchestra. The focus is on what you're doing all the time. It's a different beast. It's being more aware of yourself in your body and realizing that there isn't anything else that's attracting attention. The audience is constantly focused on you and they're watching every little detail. If you're doing something that makes you look uncomfortable, it is going to make the audience feel uncomfortable too. I like both but they’re completely different experiences.

Of course, in an opera, you have a lot more time for rehearsals. The dress rehearsal is a chance to run the show in its entirety, as if it were a performance. In a concert, you usually don't get the opportunity to do that, especially if it's a concert of arias as opposed to a concert of an opera.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557186361/media/2019/05/SDORegiment012313.jpg){{% /md %}}

<figcaption>Stephen Costello as Tonio in The Daughter of the Regiment, San Diego Opera, January-February 2013. Photo by J. Katarzyna Woronowicz.</figcaption>

</figure>

**How do you program the repertoire for a recital?**

We usually get together with the music director of the concert, and the other singer, in this case with Stephen Powell. We'll program some pieces that we can do together.

Then, we'll each individually program our arias. In this program, a lot of them are arias I've sung before and some are things I haven't. This time, I've programmed some _Madama Butterfly_ pieces so I can sing them before I do the opera \[at the New National Theater in Tokyo in June\] right after the concert.

> "You can always take something from what you're listening to and use it somewhere else."

**Is there a different relationship with the audience in a recital than in a full-length opera?**

In a recital setting, depending on the size of the theater, it's a more intimate relationship because you can see the audience members. In an opera production, the lighting effects make the audience darker, and you don't see much past the conductor. In the instance of a concert, you can usually see the faces of the people in the audience. That can be great. It helps you get your point across more easily because you can have direct contact with the audience. Sometimes though, it can throw you off if you catch someone talking or texting. It can be a double-edged sword. Each is an opportunity to share music with an audience in completely different forms. They're completely different but I get the same gratification from each.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557186493/media/2019/05/StephenCostello-pcMerriCyr.jpg){{% /md %}}

<figcaption>Photo: Merri Cyr.</figcaption>

</figure>

**Why do you sing?**

When I started singing, I realized there was something about it that gave me a personal connection. The voice is your instrument and that makes it personal. No two voices are the same. They don't have the same sound, the same color, nor the same projection. Every voice is unique and individual by itself.

> "I was comfortable with classical music, but it took me a while to get comfortable with it as a vocal art."

It makes for a really exciting career. You're always meeting different people and seeing different things. It's like going to a museum where you don't see any two paintings that are the same. I was a trumpet player for years. Opera still gives me a really great chance to collaborate with instrumentalists. At the same time, I get to work with other actors who may not be singing in a production. It's an opportunity to work with all the different art forms acting, dance, instrumentalists. There are so many different elements in it that I get a lot of satisfaction from.

I was probably around 18 or 19 when I started to work on voice, right after high school. I started with musical theater, but I wasn't a voice student. I just liked singing. I lived in Philadelphia and came from a middle-class American family. Languages weren't a thing. We were completely American. I wasn't comfortable with opera at first because of all those other aspects. I didn't know Italian nor French. I had worked on it a little bit in school but not enough to think I would ever be singing an entire opera in a foreign language. It intimidated me.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557266767/media/2019/05/SDOFaustCostello.jpg){{% /md %}}

<figcaption>Stephen Costello in the title role of Faust, San Diego Opera, 2011. Photo courtesy of San Diego Opera.</figcaption>

</figure>

When I sang an aria for the first time, and an art song, I knew what it felt like to sing so I was comfortable with it. But I was uncomfortable with getting the language right. It's important to start where you're comfortable so you can experiment with it and get a feeling with how the voice feels. I loved musical theater and I went on from there. I got introduced to a teacher in college and in turn, he introduced me to the recordings of Fritz Wunderlich. I listened to his interpretations and that's what gave me the motivation to get into classical music. The intellectual aspect made it interesting to work on it. It related back to my trumpet playing.

Because I had played trumpet since middle school and also a little bit in college, I was comfortable with classical music, but it took me a while to get comfortable with it as a vocal art.

My family wasn't from a musical background. My uncle was a music teacher, but not a professional musician. My mom and dad listened to music, not necessarily classical but all the different types of music. My sister was also in the orchestra, but she was doing it as an extracurricular activity.

> "It's weird how I have a relationship to the music even though I grew up in Northeast Philadelphia."

**You're well known for singing in _Moby Dick_, and you've sung other music by Jake Heggie. You've also just released a recording of bel canto songs. Those are very different.**

It's a lot different. When you are doing not just bel canto, but Puccini and Verdi also, you don't have any reference from the composer except for notes that he wrote or stories that other people wrote about working with the composer or conductor, about what they understood it should mean.

With _Moby Dick_ and contemporary music, it's completely different to have the composer there. You can talk to him about it and know exactly what he wants. You can say you're interpreting something in a certain way because it's what the composer wanted. There isn't room for an opinion except maybe the first time you collaborate, and something is uncomfortable or wrong.

Having the composer there is very valuable. Jake Heggie explained his music. There's less reading into the history of the composer and more reading into the history of the story. When you do Verdi or Puccini, you have to read into both, the history of the composer and the history of the story. You also have to look at conductors who conducted premieres of those pieces and see how they interpreted them because if they interpreted the premiere, they must have worked with the composer. There's a lot more research involved in doing an older piece than in doing a newer piece.

**Musically, where do you see yourself in 10 years? Are there musical genres and composers you would be excited at approaching?**

I'm getting a stride in my life that I'm enjoying. I don't know if I want to plan too far in advance.

I would like to do more French repertoire, like Werther or Hoffmann in the future. I just did my first Don José this past year. I really like the French repertoire. There's something about it that I can relate to very well. It makes me feel comfortable. It's odd because I don't have a French background. It's weird how I have a relationship to the music even though I grew up in Northeast Philadelphia. I've always felt comfortable in French. Even as I'm learning it, I can see where it's going, and I understand it. I went to Paris to sing for the first time last year. They invited me back to do more productions, some in French, like _Manon_.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557186516/media/2019/05/StephenCostello-pc-SimonPauly.jpg){{% /md %}}

<figcaption>Photo: Simon Pauly.</figcaption>

</figure>

**You have a very busy and exciting performance schedule. What do you do to unwind?**

In my off time, I come home. My wife Yoon and I live in NY. She plays violin in the orchestra of the Metropolitan Opera. I don't get enough of a chance to see her and I'm hardly ever at home.

I love coming home and spending time with her and together discovering different areas of the city. I've only been in NYC for one and one half years. I love finding restaurants that I might not have known. Recently, we've been watching a lot of cooking shows, like _Master Chef_ and _Hell's Kitchen_, the Gordon Ramsay shows. It's been fun for us to try to recreate the dishes that we see on the shows. In NY, it's even more fun because you can get everything delivered to your door.

If we see something, rather than writing it down and trying to remember to get it at the store later, in the ten minutes that we've seen it we can post an order to have it delivered and taste it right away. We also have a cocker spaniel Pebbles, who's getting on in age. He's 15 years old and spending time with him is important for us.

**What kind of music do you listen to during your down time?**

I listen to all kinds of music – classical, pop, jazz, Broadway – everything. You can always take something from what you're listening to and use it somewhere else. You shouldn't be snobbish about the music that you listen to. Even now, there are some things that I still don't understand fully, and social media can play a role. Watching how people use it, what it is that makes one person more famous than another person, why people like this music over that other music? If you have a chance, I think it's important to follow everything and keep an open mind.